/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.config;

import java.util.Collection;
import java.util.Map;
import org.jboss.galleon.Errors;
import org.jboss.galleon.ProvisioningDescriptionException;
import org.jboss.galleon.config.ConfigCustomizations;
import org.jboss.galleon.config.FeaturePackConfig;
import org.jboss.galleon.config.FeaturePackDepsConfigBuilder;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.jboss.galleon.universe.UniverseSpec;
import org.jboss.galleon.util.CollectionUtils;

public class FeaturePackDepsConfig
extends ConfigCustomizations {
    protected final UniverseSpec defaultUniverse;
    protected final Map<String, UniverseSpec> universeSpecs;
    protected final Map<FeaturePackLocation.ProducerSpec, FeaturePackConfig> fpDeps;
    protected final Map<String, FeaturePackConfig> fpDepsByOrigin;
    private final Map<FeaturePackLocation.ProducerSpec, String> channelToOrigin;

    protected FeaturePackDepsConfig(FeaturePackDepsConfigBuilder<?> builder) throws ProvisioningDescriptionException {
        super(builder);
        this.fpDeps = CollectionUtils.unmodifiable(builder.fpDeps);
        this.fpDepsByOrigin = CollectionUtils.unmodifiable(builder.fpDepsByOrigin);
        this.channelToOrigin = builder.channelToOrigin;
        this.defaultUniverse = builder.defaultUniverse;
        this.universeSpecs = CollectionUtils.unmodifiable(builder.universeSpecs);
    }

    public boolean hasDefaultUniverse() {
        return this.defaultUniverse != null;
    }

    public UniverseSpec getDefaultUniverse() {
        return this.defaultUniverse;
    }

    public boolean hasUniverse(String name) {
        return name == null ? this.defaultUniverse != null : this.universeSpecs.containsKey(name);
    }

    public UniverseSpec getUniverseSpec(String name) throws ProvisioningDescriptionException {
        UniverseSpec universe;
        UniverseSpec universeSpec = universe = name == null ? this.defaultUniverse : this.universeSpecs.get(name);
        if (universe == null) {
            throw new ProvisioningDescriptionException((name == null ? "The default" : name) + " universe was not configured");
        }
        return universe;
    }

    public boolean hasUniverseNamedSpecs() {
        return !this.universeSpecs.isEmpty();
    }

    public Map<String, UniverseSpec> getUniverseNamedSpecs() {
        return this.universeSpecs;
    }

    public FeaturePackLocation getUserConfiguredSource(FeaturePackLocation fpSource) {
        UniverseSpec universeSource = fpSource.getUniverse();
        if (this.defaultUniverse != null && this.defaultUniverse.equals(universeSource)) {
            return new FeaturePackLocation(null, fpSource.getProducerName(), fpSource.getChannelName(), fpSource.getFrequency(), fpSource.getBuild());
        }
        for (Map.Entry<String, UniverseSpec> entry : this.universeSpecs.entrySet()) {
            if (!entry.getValue().equals(universeSource)) continue;
            return new FeaturePackLocation(new UniverseSpec(entry.getKey(), null), fpSource.getProducerName(), fpSource.getChannelName(), fpSource.getFrequency(), fpSource.getBuild());
        }
        return fpSource;
    }

    public boolean hasFeaturePackDeps() {
        return !this.fpDeps.isEmpty();
    }

    public boolean hasFeaturePackDep(FeaturePackLocation.ProducerSpec producer) {
        return this.fpDeps.containsKey(producer);
    }

    public FeaturePackConfig getFeaturePackDep(FeaturePackLocation.ProducerSpec producer) {
        return this.fpDeps.get(producer);
    }

    public Collection<FeaturePackConfig> getFeaturePackDeps() {
        return this.fpDeps.values();
    }

    public FeaturePackConfig getFeaturePackDep(String origin) throws ProvisioningDescriptionException {
        FeaturePackConfig fpDep = this.fpDepsByOrigin.get(origin);
        if (fpDep == null) {
            throw new ProvisioningDescriptionException(Errors.unknownFeaturePackDependencyName(origin));
        }
        return fpDep;
    }

    public String originOf(FeaturePackLocation.ProducerSpec producer) {
        return this.channelToOrigin.get(producer);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.channelToOrigin == null ? 0 : this.channelToOrigin.hashCode());
        result = 31 * result + (this.defaultUniverse == null ? 0 : this.defaultUniverse.hashCode());
        result = 31 * result + (this.fpDeps == null ? 0 : this.fpDeps.hashCode());
        result = 31 * result + (this.fpDepsByOrigin == null ? 0 : this.fpDepsByOrigin.hashCode());
        result = 31 * result + (this.universeSpecs == null ? 0 : this.universeSpecs.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FeaturePackDepsConfig other = (FeaturePackDepsConfig)obj;
        if (this.channelToOrigin == null ? other.channelToOrigin != null : !this.channelToOrigin.equals(other.channelToOrigin)) {
            return false;
        }
        if (this.defaultUniverse == null ? other.defaultUniverse != null : !this.defaultUniverse.equals(other.defaultUniverse)) {
            return false;
        }
        if (this.fpDeps == null ? other.fpDeps != null : !this.fpDeps.equals(other.fpDeps)) {
            return false;
        }
        if (this.fpDepsByOrigin == null ? other.fpDepsByOrigin != null : !this.fpDepsByOrigin.equals(other.fpDepsByOrigin)) {
            return false;
        }
        return !(this.universeSpecs == null ? other.universeSpecs != null : !this.universeSpecs.equals(other.universeSpecs));
    }
}

