/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.config;

import java.util.Map;
import org.jboss.galleon.ProvisioningDescriptionException;
import org.jboss.galleon.config.FeaturePackConfig;
import org.jboss.galleon.config.FeaturePackDepsConfig;
import org.jboss.galleon.config.FeaturePackDepsConfigBuilder;
import org.jboss.galleon.universe.UniverseSpec;
import org.jboss.galleon.util.StringUtils;

public class ProvisioningConfig
extends FeaturePackDepsConfig {
    private final Builder builder;

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ProvisioningConfig provisioningConfig) throws ProvisioningDescriptionException {
        return new Builder(provisioningConfig);
    }

    private ProvisioningConfig(Builder builder) throws ProvisioningDescriptionException {
        super(builder);
        this.builder = builder;
    }

    public Builder getBuilder() {
        return this.builder;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.fpDeps == null ? 0 : this.fpDeps.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProvisioningConfig other = (ProvisioningConfig)obj;
        return !(this.fpDeps == null ? other.fpDeps != null : !this.fpDeps.equals(other.fpDeps));
    }

    public String toString() {
        StringBuilder buf = new StringBuilder().append('[');
        if (this.defaultUniverse != null) {
            buf.append("default-universe=").append(this.defaultUniverse);
        }
        if (!this.universeSpecs.isEmpty()) {
            if (this.defaultUniverse != null) {
                buf.append(' ');
            }
            buf.append("universes=[");
            StringUtils.append(buf, this.universeSpecs.entrySet());
            buf.append("] ");
        }
        StringUtils.append(buf, this.fpDeps.values());
        this.append(buf);
        return buf.append(']').toString();
    }

    public static class Builder
    extends FeaturePackDepsConfigBuilder<Builder> {
        private Builder() {
        }

        private Builder(ProvisioningConfig provisioningConfig) throws ProvisioningDescriptionException {
            if (provisioningConfig != null) {
                for (FeaturePackConfig featurePackConfig : provisioningConfig.getFeaturePackDeps()) {
                    this.addFeaturePackDep(provisioningConfig.originOf(featurePackConfig.getLocation().getProducer()), featurePackConfig);
                }
                if (provisioningConfig.defaultUniverse != null) {
                    this.setDefaultUniverse(provisioningConfig.defaultUniverse);
                }
                for (Map.Entry entry : provisioningConfig.universeSpecs.entrySet()) {
                    this.addUniverse((String)entry.getKey(), (UniverseSpec)entry.getValue());
                }
                this.initConfigs(provisioningConfig);
            }
        }

        public ProvisioningConfig build() throws ProvisioningDescriptionException {
            return new ProvisioningConfig(this);
        }
    }
}

