/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.diff;

import difflib.DiffUtils;
import difflib.Patch;
import difflib.PatchFailedException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jboss.galleon.MessageWriter;
import org.jboss.galleon.diff.FileSystemDiffResult;
import org.jboss.galleon.diff.OursStrategy;
import org.jboss.galleon.diff.Strategy;
import org.jboss.galleon.diff.TheirsStrategy;

public abstract class FileSystemMerge {
    private final Path stagedInstallation;
    private final Path customizedInstallation;
    protected final MessageWriter messageWriter;

    protected FileSystemMerge(MessageWriter messageWriter, Path stagedInstallation, Path customizedInstallation) {
        this.stagedInstallation = stagedInstallation;
        this.customizedInstallation = customizedInstallation;
        this.messageWriter = messageWriter;
    }

    protected Path resolveStagePath(Path path) {
        return this.stagedInstallation.resolve(path);
    }

    protected Path resolveOriginPath(Path path) {
        return this.customizedInstallation.resolve(path);
    }

    public abstract void executeUpdate(FileSystemDiffResult var1) throws IOException;

    public abstract void patchFailure(Path var1);

    protected void patchFiles(Map<Path, List<String>> changes) {
        for (Map.Entry<Path, List<String>> change : changes.entrySet()) {
            this.patchFile(change.getKey(), change.getValue());
        }
    }

    protected void patchFile(Path path, List<String> diff) {
        Path file = this.resolveStagePath(path);
        String unifiedDiff = "";
        if (this.messageWriter.isVerboseEnabled()) {
            unifiedDiff = diff.stream().collect(Collectors.joining(System.lineSeparator()));
        }
        try {
            Patch<String> patch = DiffUtils.parseUnifiedDiff(diff);
            List<String> updatedLines = DiffUtils.patch(Files.readAllLines(file, StandardCharsets.UTF_8), patch);
            Files.write(file, updatedLines, new OpenOption[0]);
        }
        catch (PatchFailedException | IOException ex) {
            this.messageWriter.verbose(ex, "Couldn't patch file %s with %s because %s", file, unifiedDiff, ex.getMessage());
            this.patchFailure(path);
        }
    }

    public static class Factory {
        public static FileSystemMerge getInstance(Strategy strategy, MessageWriter messageWriter, Path stagedInstallation, Path customizedInstallation) {
            switch (strategy) {
                case THEIRS: {
                    return new TheirsStrategy(messageWriter, stagedInstallation, customizedInstallation);
                }
            }
            return new OursStrategy(messageWriter, stagedInstallation, customizedInstallation);
        }
    }
}

