/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.layout;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.stream.Stream;
import javax.xml.stream.XMLStreamException;
import org.jboss.galleon.Errors;
import org.jboss.galleon.ProvisioningDescriptionException;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.config.FeaturePackConfig;
import org.jboss.galleon.config.FeaturePackDepsConfig;
import org.jboss.galleon.config.ProvisioningConfig;
import org.jboss.galleon.layout.FeaturePackLayoutFactory;
import org.jboss.galleon.layout.FeaturePackLayoutTransformer;
import org.jboss.galleon.layout.FeaturePackPluginVisitor;
import org.jboss.galleon.layout.ProvisioningLayoutFactory;
import org.jboss.galleon.plugin.ProvisioningPlugin;
import org.jboss.galleon.spec.FeaturePackSpec;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.jboss.galleon.universe.UniverseSpec;
import org.jboss.galleon.util.CollectionUtils;
import org.jboss.galleon.util.IoUtils;
import org.jboss.galleon.xml.FeaturePackXmlParser;

public class ProvisioningLayout<F extends FeaturePackLayout>
implements Closeable {
    public static final String STAGED = "staged";
    public static final String TMP = "tmp";
    private ProvisioningConfig config;
    private final ProvisioningLayoutFactory layoutFactory;
    private Set<FeaturePackLocation.ProducerSpec> missingVersions = Collections.emptySet();
    private Map<FeaturePackLocation.ProducerSpec, Set<FeaturePackLocation.FPID>> conflicts = Collections.emptyMap();
    private Map<FeaturePackLocation.ProducerSpec, F> loaded = new HashMap<FeaturePackLocation.ProducerSpec, F>();
    private List<F> ordered = new ArrayList<F>();
    private final Handle handle;

    ProvisioningLayout(ProvisioningLayoutFactory layoutFactory, ProvisioningConfig config, FeaturePackLayoutFactory<F> fpFactory) throws ProvisioningException {
        this.layoutFactory = layoutFactory;
        this.config = config;
        this.handle = layoutFactory.createHandle();
        try {
            this.build(fpFactory);
        }
        catch (Error | RuntimeException | ProvisioningException e) {
            this.handle.close();
            throw e;
        }
    }

    <O extends FeaturePackLayout> ProvisioningLayout(ProvisioningLayout<O> other, final FeaturePackLayoutFactory<F> fpFactory) throws ProvisioningException {
        this(other, new FeaturePackLayoutTransformer<F, O>(){

            @Override
            public F transform(O other) {
                return fpFactory.newFeaturePack(other.getFPID().getLocation(), other.getSpec(), other.getDir());
            }
        });
    }

    <O extends FeaturePackLayout> ProvisioningLayout(ProvisioningLayout<O> other, FeaturePackLayoutTransformer<F, O> transformer) throws ProvisioningException {
        this.layoutFactory = other.layoutFactory;
        this.config = other.config;
        for (FeaturePackLayout otherFp : other.ordered) {
            F fp = transformer.transform(otherFp);
            this.loaded.put(fp.getFPID().getProducer(), fp);
            this.ordered.add(fp);
        }
        this.handle = other.handle;
        this.handle.incrementRefs();
    }

    public ProvisioningLayoutFactory getFactory() {
        return this.layoutFactory;
    }

    public <O extends FeaturePackLayout> ProvisioningLayout<O> transform(FeaturePackLayoutFactory<O> fpFactory) throws ProvisioningException {
        return new ProvisioningLayout<O>(this, fpFactory);
    }

    public <O extends FeaturePackLayout> ProvisioningLayout<O> transform(FeaturePackLayoutTransformer<O, F> transformer) throws ProvisioningException {
        return new ProvisioningLayout<O>(this, transformer);
    }

    public ProvisioningConfig getConfig() {
        return this.config;
    }

    public boolean hasFeaturePacks() {
        return !this.loaded.isEmpty();
    }

    public boolean hasFeaturePack(FeaturePackLocation.ProducerSpec producer) {
        return this.loaded.containsKey(producer);
    }

    public F getFeaturePack(FeaturePackLocation.ProducerSpec producer) throws ProvisioningException {
        FeaturePackLayout p = (FeaturePackLayout)this.loaded.get(producer);
        if (p == null) {
            throw new ProvisioningException(Errors.unknownFeaturePack(producer.getLocation().getFPID()));
        }
        return (F)p;
    }

    public List<F> getOrderedFeaturePacks() {
        return this.ordered;
    }

    public boolean hasPlugins() {
        return this.handle.pluginsDir != null;
    }

    public Path getPluginsDir() {
        return this.handle.pluginsDir;
    }

    public boolean hasResources() {
        return this.handle.resourcesDir != null;
    }

    public Path getResources() {
        return this.handle.resourcesDir;
    }

    public Path getResource(String ... path) throws ProvisioningException {
        return this.handle.getResource(path);
    }

    public Path getTmpPath(String ... path) {
        return this.handle.getTmpPath(path);
    }

    public ClassLoader getPluginsClassLoader() throws ProvisioningException {
        return this.handle.getPluginsClassLoader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends ProvisioningPlugin> void visitPlugins(FeaturePackPluginVisitor<T> visitor, Class<T> clazz) throws ProvisioningException {
        ClassLoader pluginsCl = this.getPluginsClassLoader();
        Thread thread = Thread.currentThread();
        ServiceLoader<T> pluginLoader = ServiceLoader.load(clazz, pluginsCl);
        Iterator<T> pluginIterator = pluginLoader.iterator();
        if (pluginIterator.hasNext()) {
            ClassLoader ocl = thread.getContextClassLoader();
            try {
                thread.setContextClassLoader(pluginsCl);
                ProvisioningPlugin plugin = (ProvisioningPlugin)pluginIterator.next();
                visitor.visitPlugin(plugin);
                while (pluginIterator.hasNext()) {
                    visitor.visitPlugin((ProvisioningPlugin)pluginIterator.next());
                }
            }
            finally {
                thread.setContextClassLoader(ocl);
            }
        }
    }

    public Path newStagedDir() throws ProvisioningException {
        return this.handle.newStagedDir();
    }

    protected void build(FeaturePackLayoutFactory<F> factory) throws ProvisioningException {
        ArrayList<FeaturePackLocation.ProducerSpec> depBranch = new ArrayList<FeaturePackLocation.ProducerSpec>();
        while (true) {
            this.layout(this.config, depBranch, factory);
            if (!this.conflicts.isEmpty()) {
                throw new ProvisioningDescriptionException(Errors.fpVersionCheckFailed(this.conflicts.values()));
            }
            if (this.missingVersions.isEmpty()) break;
            ProvisioningConfig.Builder builder = ProvisioningConfig.builder();
            if (this.config.hasDefaultUniverse()) {
                builder.setDefaultUniverse(this.config.getDefaultUniverse());
            }
            for (Map.Entry<String, UniverseSpec> universe : this.config.getUniverseNamedSpecs().entrySet()) {
                builder.addUniverse(universe.getKey(), universe.getValue());
            }
            for (FeaturePackConfig fpConfig : this.config.getFeaturePackDeps()) {
                FeaturePackLocation.ProducerSpec producer = fpConfig.getLocation().getProducer();
                if (this.missingVersions.contains(producer)) {
                    fpConfig = FeaturePackConfig.builder(this.layoutFactory.getUniverseResolver().resolveLatestBuild(fpConfig.getLocation())).init(fpConfig).build();
                    this.missingVersions = CollectionUtils.remove(this.missingVersions, producer);
                }
                builder.updateFeaturePackDep(this.config.originOf(producer), fpConfig);
            }
            builder.initConfigs(this.config);
            for (FeaturePackLocation.ProducerSpec producer : this.missingVersions) {
                builder.addFeaturePackDep(FeaturePackConfig.forLocation(this.layoutFactory.getUniverseResolver().resolveLatestBuild(producer.getLocation())));
            }
            this.config = builder.build();
            this.missingVersions = Collections.emptySet();
            this.ordered.clear();
        }
    }

    private void layout(FeaturePackDepsConfig fpDepsConfig, List<FeaturePackLocation.ProducerSpec> branch, FeaturePackLayoutFactory<F> factory) throws ProvisioningException {
        if (!fpDepsConfig.hasFeaturePackDeps()) {
            return;
        }
        int branchSize = branch.size();
        Collection<FeaturePackConfig> fpDeps = fpDepsConfig.getFeaturePackDeps();
        ArrayList<F> queue = new ArrayList<F>(fpDeps.size());
        for (FeaturePackConfig fpConfig : fpDeps) {
            FeaturePackSpec spec;
            FeaturePackLocation fpl = fpConfig.getLocation();
            if (fpl.getBuild() == null) {
                this.missingVersions = CollectionUtils.addLinked(this.missingVersions, fpl.getProducer());
                continue;
            }
            FeaturePackLayout fp = (FeaturePackLayout)this.loaded.get(fpl.getProducer());
            if (fp != null) {
                FeaturePackLocation.FPID loadedFpid = fp.getFPID();
                if (loadedFpid.equals(fpl.getFPID()) || branch.contains(fpl.getProducer())) continue;
                Set<FeaturePackLocation.FPID> versions = this.conflicts.get(loadedFpid.getProducer());
                if (versions != null) {
                    versions.add(fpl.getFPID());
                    continue;
                }
                versions = new LinkedHashSet<FeaturePackLocation.FPID>();
                versions.add(loadedFpid);
                versions.add(fpl.getFPID());
                this.conflicts = CollectionUtils.putLinked(this.conflicts, fpl.getProducer(), versions);
                continue;
            }
            Path fpDir = this.layoutFactory.resolveFeaturePackDir(fpl);
            Path fpXml = fpDir.resolve("feature-pack.xml");
            if (!Files.exists(fpXml, new LinkOption[0])) {
                throw new ProvisioningDescriptionException(Errors.pathDoesNotExist(fpXml));
            }
            try (BufferedReader reader = Files.newBufferedReader(fpXml);){
                spec = FeaturePackXmlParser.getInstance().parse(reader);
            }
            catch (IOException | XMLStreamException e) {
                throw new ProvisioningException(Errors.parseXml(fpXml), e);
            }
            F producer = factory.newFeaturePack(fpl, spec, fpDir);
            this.loaded.put(fpl.getProducer(), producer);
            queue.add(producer);
            if (!this.missingVersions.isEmpty()) {
                this.missingVersions = CollectionUtils.remove(this.missingVersions, fpl.getProducer());
            }
            branch.add(fpl.getProducer());
        }
        if (!queue.isEmpty()) {
            for (FeaturePackLayout p : queue) {
                this.layout(p.getSpec(), branch, factory);
                this.handle.copyResources(p.getDir());
                this.ordered.add(p);
            }
        }
        for (int i = 0; i < branch.size() - branchSize; ++i) {
            branch.remove(branch.size() - 1);
        }
    }

    @Override
    public void close() {
        this.handle.close();
    }

    public static class Handle
    implements Closeable {
        private final ProvisioningLayoutFactory layoutFactory;
        private Path workDir;
        private ClassLoader pluginsCl;
        private boolean closePluginsCl;
        private Path pluginsDir;
        private Path resourcesDir;
        private Path tmpDir;
        private int refs;

        Handle(ProvisioningLayoutFactory layoutFactory) {
            this.layoutFactory = layoutFactory;
            this.refs = 1;
        }

        protected void incrementRefs() {
            ++this.refs;
        }

        private void copyResources(Path fpDir) throws ProvisioningException {
            Path fpPlugins;
            Path fpResources = fpDir.resolve("resources");
            if (Files.exists(fpResources, new LinkOption[0])) {
                this.resourcesDir = this.getWorkDir().resolve("resources");
                try {
                    IoUtils.copy(fpResources, this.resourcesDir);
                }
                catch (IOException e) {
                    throw new ProvisioningException(Errors.copyFile(fpResources, this.resourcesDir), e);
                }
            }
            if (Files.exists(fpPlugins = fpDir.resolve("plugins"), new LinkOption[0])) {
                if (this.pluginsDir == null) {
                    this.pluginsDir = this.getWorkDir().resolve("plugins");
                }
                try {
                    IoUtils.copy(fpPlugins, this.pluginsDir);
                }
                catch (IOException e) {
                    throw new ProvisioningException(Errors.copyFile(fpPlugins, this.pluginsDir), e);
                }
            }
        }

        protected Path newStagedDir() throws ProvisioningException {
            Path stagedDir;
            block18: {
                stagedDir = this.getWorkDir().resolve(ProvisioningLayout.STAGED);
                if (Files.exists(stagedDir, new LinkOption[0])) {
                    try (DirectoryStream<Path> stream = Files.newDirectoryStream(stagedDir);){
                        for (Path p : stream) {
                            IoUtils.recursiveDelete(p);
                        }
                        break block18;
                    }
                    catch (IOException e) {
                        throw new ProvisioningException(Errors.readDirectory(stagedDir), e);
                    }
                }
                try {
                    Files.createDirectories(stagedDir, new FileAttribute[0]);
                }
                catch (IOException e) {
                    throw new ProvisioningException(Errors.mkdirs(stagedDir), e);
                }
            }
            return stagedDir;
        }

        protected Path getResource(String ... path) throws ProvisioningException {
            if (this.resourcesDir == null) {
                throw new ProvisioningException("Configuration does not include resources");
            }
            if (path.length == 0) {
                throw new IllegalArgumentException("Resource path is null");
            }
            if (path.length == 1) {
                return this.resourcesDir.resolve(path[0]);
            }
            Path p = this.resourcesDir;
            for (String name : path) {
                p = p.resolve(name);
            }
            return p;
        }

        protected Path getTmpPath(String ... path) {
            if (path.length == 0) {
                return this.getTmpDir();
            }
            if (path.length == 1) {
                return this.getTmpDir().resolve(path[0]);
            }
            Path p = this.getTmpDir();
            for (String name : path) {
                p = p.resolve(name);
            }
            return p;
        }

        protected ClassLoader getPluginsClassLoader() throws ProvisioningException {
            if (this.pluginsCl != null) {
                return this.pluginsCl;
            }
            this.pluginsCl = Thread.currentThread().getContextClassLoader();
            if (this.pluginsDir != null) {
                ArrayList<URL> urls = new ArrayList<URL>();
                try (Stream<Path> stream = Files.list(this.pluginsDir);){
                    Iterator i = stream.iterator();
                    while (i.hasNext()) {
                        urls.add(((Path)i.next()).toUri().toURL());
                    }
                }
                catch (IOException e) {
                    throw new ProvisioningException(Errors.readDirectory(this.pluginsDir), e);
                }
                if (!urls.isEmpty()) {
                    this.closePluginsCl = true;
                    this.pluginsCl = new URLClassLoader(urls.toArray(new URL[urls.size()]), this.pluginsCl);
                }
            }
            return this.pluginsCl;
        }

        private Path getTmpDir() {
            return this.tmpDir == null ? (this.tmpDir = this.getWorkDir().resolve(ProvisioningLayout.TMP)) : this.tmpDir;
        }

        private Path getWorkDir() {
            return this.workDir == null ? (this.workDir = this.layoutFactory.newConfigLayoutDir()) : this.workDir;
        }

        public boolean isClosed() {
            return this.refs == 0;
        }

        @Override
        public void close() {
            if (this.refs == 0 || --this.refs > 0) {
                return;
            }
            if (this.closePluginsCl) {
                try {
                    ((URLClassLoader)this.pluginsCl).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (this.workDir != null) {
                IoUtils.recursiveDelete(this.workDir);
            }
            this.layoutFactory.handleClosed();
        }
    }

    public static interface FeaturePackLayout {
        public FeaturePackLocation.FPID getFPID();

        public FeaturePackSpec getSpec();

        public Path getDir();
    }
}

