/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.layout;

import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.galleon.Errors;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.config.ProvisioningConfig;
import org.jboss.galleon.layout.FeaturePackLayoutFactory;
import org.jboss.galleon.layout.ProvisioningLayout;
import org.jboss.galleon.spec.FeaturePackSpec;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.jboss.galleon.universe.Universe;
import org.jboss.galleon.universe.UniverseResolver;
import org.jboss.galleon.util.IoUtils;
import org.jboss.galleon.util.LayoutUtils;
import org.jboss.galleon.util.ZipUtils;

public class ProvisioningLayoutFactory
implements Closeable {
    private final Path home;
    private final UniverseResolver universeResolver;
    private AtomicInteger openHandles = new AtomicInteger();

    public static ProvisioningLayoutFactory getInstance(UniverseResolver universeResolver) {
        return new ProvisioningLayoutFactory(IoUtils.createRandomTmpDir(), universeResolver);
    }

    public static ProvisioningLayoutFactory getInstance(Path home, UniverseResolver universeResolver) {
        return new ProvisioningLayoutFactory(home, universeResolver);
    }

    private ProvisioningLayoutFactory(Path home, UniverseResolver universeResolver) {
        this.home = home;
        this.universeResolver = universeResolver;
    }

    public UniverseResolver getUniverseResolver() {
        return this.universeResolver;
    }

    public ProvisioningLayout<ProvisioningLayout.FeaturePackLayout> newConfigLayout(ProvisioningConfig config) throws ProvisioningException {
        return this.newConfigLayout(config, new FeaturePackLayoutFactory<ProvisioningLayout.FeaturePackLayout>(){

            @Override
            public ProvisioningLayout.FeaturePackLayout newFeaturePack(final FeaturePackLocation fpl, final FeaturePackSpec spec, final Path dir) {
                return new ProvisioningLayout.FeaturePackLayout(){

                    @Override
                    public FeaturePackLocation.FPID getFPID() {
                        return fpl.getFPID();
                    }

                    @Override
                    public FeaturePackSpec getSpec() {
                        return spec;
                    }

                    @Override
                    public Path getDir() {
                        return dir;
                    }
                };
            }
        });
    }

    public <F extends ProvisioningLayout.FeaturePackLayout> ProvisioningLayout<F> newConfigLayout(ProvisioningConfig config, FeaturePackLayoutFactory<F> factory) throws ProvisioningException {
        return new ProvisioningLayout<F>(this, config, factory);
    }

    Path resolveFeaturePackDir(FeaturePackLocation fpl) throws ProvisioningException {
        Path fpDir = LayoutUtils.getFeaturePackDir(this.home, fpl.getFPID(), false);
        if (Files.exists(fpDir, new LinkOption[0])) {
            return fpDir;
        }
        Universe<?> universe = this.universeResolver.getUniverse(fpl.getUniverse());
        Path artifactPath = universe.getProducer(fpl.getProducerName()).getChannel(fpl.getChannelName()).resolve(fpl);
        try {
            Files.createDirectories(fpDir, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new ProvisioningException(Errors.mkdirs(fpDir), e);
        }
        try {
            ZipUtils.unzip(artifactPath, fpDir);
        }
        catch (IOException e) {
            throw new ProvisioningException("Failed to unzip " + artifactPath + " to " + fpDir, e);
        }
        return fpDir;
    }

    ProvisioningLayout.Handle createHandle() {
        ProvisioningLayout.Handle handle = new ProvisioningLayout.Handle(this);
        this.openHandles.incrementAndGet();
        return handle;
    }

    void handleClosed() {
        this.openHandles.decrementAndGet();
    }

    Path newConfigLayoutDir() {
        return IoUtils.createRandomDir(this.home);
    }

    @Override
    public void close() {
        IoUtils.recursiveDelete(this.home);
        if (this.openHandles.get() != 0) {
            throw new IllegalStateException("Remaining open handles: " + this.openHandles.get());
        }
    }
}

