/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.maven.plugin.util;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.installation.InstallRequest;
import org.eclipse.aether.installation.InstallationException;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.VersionRangeRequest;
import org.eclipse.aether.resolution.VersionRangeResolutionException;
import org.eclipse.aether.resolution.VersionRangeResult;
import org.eclipse.aether.version.Version;
import org.jboss.galleon.ArtifactCoords;
import org.jboss.galleon.maven.plugin.FpMavenErrors;
import org.jboss.galleon.universe.maven.MavenArtifact;
import org.jboss.galleon.universe.maven.MavenUniverseException;
import org.jboss.galleon.universe.maven.repo.MavenArtifactVersion;
import org.jboss.galleon.universe.maven.repo.MavenRepoManager;

public class MavenArtifactRepositoryManager
implements MavenRepoManager {
    private final RepositorySystem repoSystem;
    private final RepositorySystemSession session;
    private final List<RemoteRepository> repositories;

    private static ArtifactCoords toLegacyCoords(MavenArtifact artifact) {
        return ArtifactCoords.newInstance(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), artifact.getExtension());
    }

    public MavenArtifactRepositoryManager(RepositorySystem repoSystem, RepositorySystemSession repoSession) {
        this.repoSystem = repoSystem;
        this.session = repoSession;
        this.repositories = null;
    }

    public MavenArtifactRepositoryManager(RepositorySystem repoSystem, RepositorySystemSession repoSession, List<RemoteRepository> repositories) {
        this.repoSystem = repoSystem;
        this.session = repoSession;
        this.repositories = repositories;
    }

    @Override
    public void resolve(MavenArtifact coords) throws MavenUniverseException {
        ArtifactResult result;
        DefaultArtifact defaultArtifact = new DefaultArtifact(coords.getGroupId(), coords.getArtifactId(), coords.getClassifier(), coords.getExtension(), coords.getVersion());
        ArtifactRequest request = new ArtifactRequest().setArtifact(defaultArtifact).setRepositories(this.repositories);
        try {
            result = this.repoSystem.resolveArtifact(this.session, request);
        }
        catch (ArtifactResolutionException e) {
            throw new MavenUniverseException(FpMavenErrors.artifactResolution(MavenArtifactRepositoryManager.toLegacyCoords(coords)), e);
        }
        if (!result.isResolved()) {
            throw new MavenUniverseException(FpMavenErrors.artifactResolution(MavenArtifactRepositoryManager.toLegacyCoords(coords)));
        }
        if (result.isMissing()) {
            throw new MavenUniverseException(FpMavenErrors.artifactMissing(MavenArtifactRepositoryManager.toLegacyCoords(coords)));
        }
        coords.setPath(Paths.get(result.getArtifact().getFile().toURI()));
    }

    @Override
    public void resolveLatestVersion(MavenArtifact coords, String lowestQualifier) throws MavenUniverseException {
        this.resolve(coords.setVersion(this.getLatestVersion(coords, lowestQualifier)));
    }

    @Override
    public String getLatestVersion(MavenArtifact coords, String lowestQualifier) throws MavenUniverseException {
        VersionRangeResult rangeResult;
        DefaultArtifact artifact = new DefaultArtifact(coords.getGroupId(), coords.getArtifactId(), coords.getExtension(), coords.getVersionRange());
        VersionRangeRequest rangeRequest = new VersionRangeRequest().setArtifact(artifact).setRepositories(this.repositories);
        try {
            rangeResult = this.repoSystem.resolveVersionRange(this.session, rangeRequest);
        }
        catch (VersionRangeResolutionException ex) {
            throw new MavenUniverseException(ex.getLocalizedMessage(), ex);
        }
        MavenArtifactVersion latest = null;
        if (rangeResult != null) {
            if (lowestQualifier == null) {
                lowestQualifier = "";
            }
            for (Version version : rangeResult.getVersions()) {
                MavenArtifactVersion next = new MavenArtifactVersion(version.toString());
                if (!next.isQualifierHigher(lowestQualifier, true) || latest != null && latest.compareTo(next) > 0) continue;
                latest = next;
            }
        }
        if (latest == null) {
            throw new MavenUniverseException("Failed to determine the latest version of " + coords.getCoordsAsString());
        }
        return latest.toString();
    }

    @Override
    public void install(MavenArtifact coords, Path path) throws MavenUniverseException {
        InstallRequest request = new InstallRequest();
        request.addArtifact(new DefaultArtifact(coords.getGroupId(), coords.getArtifactId(), coords.getClassifier(), coords.getExtension(), coords.getVersion(), Collections.emptyMap(), path.toFile()));
        try {
            this.repoSystem.install(this.session, request);
        }
        catch (InstallationException ex) {
            throw new MavenUniverseException("Failed to install " + coords.getCoordsAsString(), ex);
        }
    }

    @Override
    public boolean isResolved(MavenArtifact artifact) throws MavenUniverseException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isLatestVersionResolved(MavenArtifact artifact, String lowestQualifier) throws MavenUniverseException {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

