/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.universe;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.repo.RepositoryArtifactResolver;
import org.jboss.galleon.universe.Universe;
import org.jboss.galleon.universe.UniverseFactory;
import org.jboss.galleon.universe.UniverseSpec;
import org.jboss.galleon.util.CollectionUtils;

public class UniverseFactoryLoader {
    private static final UniverseFactoryLoader INSTANCE = new UniverseFactoryLoader();
    private final Map<String, UniverseFactory> factories;
    private Map<String, RepositoryArtifactResolver> artifactResolvers = Collections.emptyMap();

    public static UniverseFactoryLoader getInstance() {
        return INSTANCE;
    }

    private UniverseFactoryLoader() {
        ServiceLoader<UniverseFactory> loader = ServiceLoader.load(UniverseFactory.class);
        Map<Object, Object> factories = Collections.emptyMap();
        for (UniverseFactory factory : loader) {
            if (factories.isEmpty()) {
                factories = Collections.singletonMap(factory.getFactoryId(), factory);
                continue;
            }
            if (factories.containsKey(factory.getFactoryId())) {
                throw new IllegalStateException("Only one universe factory is allowed per repository type " + factory.getFactoryId() + " but found " + factory + " and " + factories.get(factory.getFactoryId()));
            }
            if (factories.size() == 1) {
                HashMap<Object, Object> tmp = new HashMap<Object, Object>(2);
                tmp.putAll(factories);
                factories = tmp;
            }
            factories.put(factory.getFactoryId(), factory);
        }
        this.factories = CollectionUtils.unmodifiable(factories);
    }

    public Set<String> getFactories() {
        return this.factories.keySet();
    }

    public UniverseFactoryLoader addArtifactResolver(RepositoryArtifactResolver artifactResolver) {
        return this.addArtifactResolver(artifactResolver.getRepositoryId(), artifactResolver);
    }

    public UniverseFactoryLoader addArtifactResolver(String repoId, RepositoryArtifactResolver artifactResolver) {
        this.artifactResolvers = CollectionUtils.put(this.artifactResolvers, repoId, artifactResolver);
        return this;
    }

    public Universe<?> getUniverse(String factoryId, String location) throws ProvisioningException {
        UniverseFactory factory = this.getUniverseFactory(factoryId);
        return factory.getUniverse(this.getArtifactResolver(factory.getRepositoryId()), location);
    }

    public Universe<?> getUniverse(String factoryId, String location, String repoId) throws ProvisioningException {
        return this.getUniverseFactory(factoryId).getUniverse(this.getArtifactResolver(repoId), location);
    }

    public Universe<?> getUniverse(String factoryId, String location, RepositoryArtifactResolver artifactResolver) throws ProvisioningException {
        UniverseFactory factory = this.getUniverseFactory(factoryId);
        if (artifactResolver == null) {
            throw new ProvisioningException("artifactResolver is null");
        }
        return factory.getUniverse(artifactResolver, location);
    }

    public Universe<?> getUniverse(UniverseSpec universeSource) throws ProvisioningException {
        UniverseFactory factory = this.getUniverseFactory(universeSource.getFactory());
        return factory.getUniverse(this.getArtifactResolver(factory.getRepositoryId()), universeSource.getLocation());
    }

    private UniverseFactory getUniverseFactory(String factoryId) throws ProvisioningException {
        UniverseFactory factory = this.factories.get(factoryId);
        if (factory == null) {
            throw new ProvisioningException("Universe factory " + factoryId + " has not been installed");
        }
        return factory;
    }

    private RepositoryArtifactResolver getArtifactResolver(String repositoryId) throws ProvisioningException {
        RepositoryArtifactResolver artifactResolver = this.artifactResolvers.get(repositoryId);
        if (artifactResolver == null) {
            throw new ProvisioningException("Repository artifact resolver " + repositoryId + " has not been configured");
        }
        return artifactResolver;
    }

    RepositoryArtifactResolver getArtifactResolverOrNull(String repoId) {
        return this.artifactResolvers.get(repoId);
    }
}

