/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.universe;

import java.nio.file.Path;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.repo.RepositoryArtifactResolver;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.jboss.galleon.universe.Universe;
import org.jboss.galleon.universe.UniverseFactoryLoader;
import org.jboss.galleon.universe.UniverseResolverBuilder;
import org.jboss.galleon.universe.UniverseSpec;
import org.jboss.galleon.util.CollectionUtils;

public class UniverseResolver {
    private final UniverseFactoryLoader ufl;
    private Map<UniverseSpec, Universe<?>> resolvedUniverses = Collections.emptyMap();

    public static Builder builder() throws ProvisioningException {
        return new Builder(null);
    }

    public static Builder builder(UniverseFactoryLoader ufl) throws ProvisioningException {
        return new Builder(ufl);
    }

    UniverseResolver(UniverseResolverBuilder<?> builder) throws ProvisioningException {
        this.ufl = builder.getUfl();
    }

    public UniverseFactoryLoader getFactoryLoader() {
        return this.ufl;
    }

    public Universe<?> getUniverse(UniverseSpec universeSpec) throws ProvisioningException {
        Universe<?> resolved = this.resolvedUniverses.get(universeSpec);
        if (resolved == null) {
            resolved = this.ufl.getUniverse(universeSpec);
            this.resolvedUniverses = CollectionUtils.put(this.resolvedUniverses, universeSpec, resolved);
        }
        return resolved;
    }

    public FeaturePackLocation resolveLatestBuild(FeaturePackLocation fpl) throws ProvisioningException {
        String latestBuild = this.getUniverse(fpl.getUniverse()).getProducer(fpl.getProducerName()).getChannel(fpl.getChannelName()).getLatestBuild(fpl);
        return new FeaturePackLocation(fpl.getUniverse(), fpl.getProducerName(), fpl.getChannelName(), fpl.getFrequency(), latestBuild);
    }

    public Path resolve(FeaturePackLocation fpl) throws ProvisioningException {
        return this.getUniverse(fpl.getUniverse()).getProducer(fpl.getProducerName()).getChannel(fpl.getChannelName()).resolve(fpl);
    }

    public boolean isResolved(FeaturePackLocation fpl) throws ProvisioningException {
        return this.getUniverse(fpl.getUniverse()).getProducer(fpl.getProducerName()).getChannel(fpl.getChannelName()).isResolved(fpl);
    }

    public RepositoryArtifactResolver getArtifactResolver(String repositoryId) throws ProvisioningException {
        RepositoryArtifactResolver ar = this.ufl.getArtifactResolverOrNull(repositoryId);
        if (ar == null) {
            throw new ProvisioningException("Repository artifact resolver " + repositoryId + " was not configured");
        }
        return ar;
    }

    public Set<UniverseSpec> getUniverses() {
        return this.resolvedUniverses.keySet();
    }

    public static class Builder
    extends UniverseResolverBuilder<Builder> {
        private Builder(UniverseFactoryLoader ufl) throws ProvisioningException {
            this.ufl = ufl;
        }

        public UniverseResolver build() throws ProvisioningException {
            return new UniverseResolver(this);
        }
    }
}

