/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.universe;

import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.repo.RepositoryArtifactResolver;
import org.jboss.galleon.universe.UniverseFactoryLoader;
import org.jboss.galleon.universe.UniverseResolver;

public abstract class UniverseResolverBuilder<T extends UniverseResolverBuilder<?>> {
    protected UniverseFactoryLoader ufl;

    public T setUniverseFactoryLoader(UniverseFactoryLoader ufl) throws ProvisioningException {
        if (this.ufl != null) {
            throw new ProvisioningException("Universe factory loader has already been initialized");
        }
        this.ufl = ufl;
        return (T)this;
    }

    public T addArtifactResolver(RepositoryArtifactResolver artifactResolver) throws ProvisioningException {
        return this.addArtifactResolver(artifactResolver.getRepositoryId(), artifactResolver);
    }

    public T addArtifactResolver(String repoId, RepositoryArtifactResolver artifactResolver) throws ProvisioningException {
        this.getUfl().addArtifactResolver(repoId, artifactResolver);
        return (T)this;
    }

    protected UniverseResolver buildUniverseResolver() throws ProvisioningException {
        return new UniverseResolver(this);
    }

    protected UniverseFactoryLoader getUfl() throws ProvisioningException {
        if (this.ufl == null) {
            this.ufl = UniverseFactoryLoader.getInstance();
        }
        return this.ufl;
    }
}

