/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.universe;

public class UniverseSpec {
    private final String factory;
    private final String location;
    private final int hash;

    public static UniverseSpec fromString(String src) {
        if (src.charAt(src.length() - 1) == ')') {
            int start = src.indexOf(40);
            if (start < 2) {
                throw new IllegalArgumentException("Universe spec '" + src + "' does not follow format factory_id[(location)]");
            }
            return new UniverseSpec(src.substring(0, start), src.substring(start + 1, src.length() - 1));
        }
        return new UniverseSpec(src, null);
    }

    public UniverseSpec(String factory, String location) {
        this.factory = factory;
        this.location = location;
        int prime = 31;
        int hash = 1;
        hash = 31 * hash + (factory == null ? 0 : factory.hashCode());
        this.hash = hash = 31 * hash + (location == null ? 0 : location.hashCode());
    }

    public String getFactory() {
        return this.factory;
    }

    public String getLocation() {
        return this.location;
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UniverseSpec other = (UniverseSpec)obj;
        if (this.factory == null ? other.factory != null : !this.factory.equals(other.factory)) {
            return false;
        }
        return !(this.location == null ? other.location != null : !this.location.equals(other.location));
    }

    public String toString() {
        return this.location == null ? this.factory : this.factory + '(' + this.location + ')';
    }
}

