/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.universe.galleon1;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.universe.Producer;
import org.jboss.galleon.universe.galleon1.LegacyGalleon1Channel;
import org.jboss.galleon.universe.galleon1.LegacyGalleon1Universe;
import org.jboss.galleon.util.CollectionUtils;

class LegacyGalleon1Producer
implements Producer<LegacyGalleon1Channel> {
    private final LegacyGalleon1Universe universe;
    private final String name;
    private Map<String, LegacyGalleon1Channel> channels = Collections.emptyMap();

    LegacyGalleon1Producer(LegacyGalleon1Universe universe, String name) {
        this.universe = universe;
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean hasFrequencies() {
        return false;
    }

    @Override
    public Collection<String> getFrequencies() {
        return Collections.emptySet();
    }

    @Override
    public boolean hasChannel(String name) throws ProvisioningException {
        return true;
    }

    @Override
    public LegacyGalleon1Channel getChannel(String name) throws ProvisioningException {
        LegacyGalleon1Channel channel = this.channels.get(name);
        if (channel == null) {
            channel = new LegacyGalleon1Channel(this.universe, name);
            this.channels = CollectionUtils.put(this.channels, name, channel);
        }
        return channel;
    }

    @Override
    public Collection<LegacyGalleon1Channel> getChannels() throws ProvisioningException {
        return this.channels.values();
    }
}

