/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.universe.maven;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import org.jboss.galleon.universe.maven.MavenArtifact;
import org.jboss.galleon.universe.maven.MavenErrors;
import org.jboss.galleon.universe.maven.MavenProducer;
import org.jboss.galleon.universe.maven.MavenUniverseBase;
import org.jboss.galleon.universe.maven.MavenUniverseException;
import org.jboss.galleon.universe.maven.repo.MavenRepoManager;
import org.jboss.galleon.universe.maven.xml.MavenProducerSpecXmlParser;
import org.jboss.galleon.universe.maven.xml.ParsedCallbackHandler;
import org.jboss.galleon.util.CollectionUtils;
import org.jboss.galleon.util.ZipUtils;

public class MavenUniverse
extends MavenUniverseBase {
    private static final String DEFAULT_RANGE = "[0.0,)";
    private Map<String, MavenProducer> producers = Collections.emptyMap();
    private boolean fullyLoaded;
    private final ParsedCallbackHandler<MavenUniverseBase, MavenProducer> parsedProducerHandler = new ParsedCallbackHandler<MavenUniverseBase, MavenProducer>(){

        @Override
        public MavenUniverseBase getParent() {
            return MavenUniverse.this;
        }

        @Override
        public void parsed(MavenProducer producer) throws XMLStreamException {
            MavenUniverse.this.producers = CollectionUtils.put(MavenUniverse.this.producers, producer.getName(), producer);
        }
    };

    public MavenUniverse(MavenRepoManager repoManager, MavenArtifact artifact) throws MavenUniverseException {
        super(repoManager, artifact);
        if (!artifact.isResolved()) {
            if (artifact.getVersionRange() != null) {
                repoManager.resolveLatestVersion(artifact);
            } else if (artifact.getVersion() != null) {
                repoManager.resolve(artifact);
            } else {
                artifact.setVersionRange(DEFAULT_RANGE);
                repoManager.resolveLatestVersion(artifact);
            }
        }
    }

    public void resetCache() {
        this.fullyLoaded = false;
        this.producers = Collections.emptyMap();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean hasProducer(String producerName) throws MavenUniverseException {
        if (this.producers.containsKey(producerName)) {
            return true;
        }
        if (this.fullyLoaded) {
            return false;
        }
        try (FileSystem zipfs = FileSystems.newFileSystem(ZipUtils.toZipUri(this.artifact.getPath()), Collections.emptyMap());){
            Path producerXml = MavenUniverse.getProducerXml(zipfs, producerName);
            if (!Files.exists(producerXml, new LinkOption[0])) {
                boolean bl = false;
                return bl;
            }
            try (BufferedReader reader = Files.newBufferedReader(producerXml);){
                MavenProducerSpecXmlParser.getInstance().parse(reader, this.parsedProducerHandler);
                return true;
            }
            catch (IOException | XMLStreamException e) {
                throw new MavenUniverseException("Failed to read " + producerXml, e);
            }
        }
        catch (IOException e) {
            throw new MavenUniverseException("Failed to read " + this.artifact.getPath(), e);
        }
    }

    @Override
    public MavenProducer getProducer(String producerName) throws MavenUniverseException {
        if (!this.hasProducer(producerName)) {
            throw MavenErrors.producerNotFound(producerName);
        }
        return this.producers.get(producerName);
    }

    /*
     * Exception decompiling
     */
    @Override
    public Collection<MavenProducer> getProducers() throws MavenUniverseException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

