/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.universe.maven;

import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.repo.RepositoryArtifactResolver;
import org.jboss.galleon.universe.Universe;
import org.jboss.galleon.universe.UniverseFactory;
import org.jboss.galleon.universe.maven.MavenArtifact;
import org.jboss.galleon.universe.maven.MavenUniverse;
import org.jboss.galleon.universe.maven.MavenUniverseException;
import org.jboss.galleon.universe.maven.repo.MavenRepoManager;
import org.jboss.galleon.universe.maven.repo.SimplisticMavenRepoManager;

public class MavenUniverseFactory
implements UniverseFactory {
    public static final String DEFAULT_REPO_ID = "repository.maven";
    public static final String ID = "maven";

    @Override
    public String getFactoryId() {
        return ID;
    }

    @Override
    public String getRepositoryId() {
        return DEFAULT_REPO_ID;
    }

    @Override
    public Universe<?> getUniverse(RepositoryArtifactResolver artifactResolver, String location) throws ProvisioningException {
        MavenRepoManager repo;
        if (artifactResolver != null) {
            if (!(artifactResolver instanceof MavenRepoManager)) {
                throw new MavenUniverseException(artifactResolver.getClass().getName() + " is not an instance of " + MavenRepoManager.class.getName());
            }
            repo = (MavenRepoManager)artifactResolver;
        } else {
            repo = SimplisticMavenRepoManager.getInstance();
        }
        return new MavenUniverse(repo, MavenArtifact.fromString(location));
    }
}

