/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.universe.maven.repo;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.jboss.galleon.ArtifactCoords;
import org.jboss.galleon.ArtifactException;
import org.jboss.galleon.ArtifactRepositoryManager;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.universe.maven.MavenArtifact;
import org.jboss.galleon.universe.maven.MavenErrors;
import org.jboss.galleon.universe.maven.MavenUniverseException;
import org.jboss.galleon.universe.maven.repo.MavenArtifactVersion;
import org.jboss.galleon.universe.maven.repo.MavenArtifactVersionRange;
import org.jboss.galleon.universe.maven.repo.MavenArtifactVersionRangeParser;
import org.jboss.galleon.universe.maven.repo.MavenRepoManager;
import org.jboss.galleon.util.IoUtils;

public class SimplisticMavenRepoManager
implements ArtifactRepositoryManager,
MavenRepoManager {
    public static final String REPOSITORY_ID = "repository.maven";
    public static final String SIMPLISTIC_MAVEN_REPO_HOME = "simplistic.maven.repo.home";
    private static final MavenArtifactVersionRangeParser versionRangeParser = new MavenArtifactVersionRangeParser();
    private final Path repoHome;
    private final MavenRepoManager fallback;

    public static SimplisticMavenRepoManager getInstance() {
        String prop = System.getProperty(SIMPLISTIC_MAVEN_REPO_HOME);
        return SimplisticMavenRepoManager.getInstance(prop == null ? Paths.get(System.getProperty("user.home"), new String[0]).resolve(".m2") : Paths.get(prop, new String[0]));
    }

    public static SimplisticMavenRepoManager getInstance(Path repoHome) {
        return new SimplisticMavenRepoManager(repoHome, null);
    }

    public static SimplisticMavenRepoManager getInstance(Path repoHome, MavenRepoManager fallback) {
        return new SimplisticMavenRepoManager(repoHome, fallback);
    }

    private SimplisticMavenRepoManager(Path repoHome, MavenRepoManager fallback) {
        this.repoHome = repoHome;
        this.fallback = fallback;
    }

    @Override
    public String getRepositoryId() {
        return REPOSITORY_ID;
    }

    @Override
    public Path resolve(String location) throws ProvisioningException {
        return MavenRepoManager.super.resolve(location);
    }

    @Override
    public Path resolve(ArtifactCoords coords) throws ArtifactException {
        MavenArtifact artifact = this.toMavenArtifact(coords);
        try {
            this.resolve(artifact);
        }
        catch (MavenUniverseException e) {
            throw new ArtifactException("Failed to resolve " + coords, e);
        }
        return artifact.getPath();
    }

    @Override
    public void install(ArtifactCoords coords, Path artifact) throws ArtifactException {
        try {
            this.install(this.toMavenArtifact(coords), artifact);
        }
        catch (MavenUniverseException e) {
            throw new ArtifactException("Failed to install " + coords, e);
        }
    }

    @Override
    public void deploy(ArtifactCoords coords, Path artifact) throws ArtifactException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getHighestVersion(ArtifactCoords coords, String range) throws ArtifactException {
        try {
            return this.getLatestVersion(this.toMavenArtifact(coords).setVersionRange(range));
        }
        catch (MavenUniverseException e) {
            throw new ArtifactException("Failed to resolve the latest version for " + coords, e);
        }
    }

    private MavenArtifact toMavenArtifact(ArtifactCoords coords) {
        return new MavenArtifact().setGroupId(coords.getGroupId()).setArtifactId(coords.getArtifactId()).setVersion(coords.getVersion()).setClassifier(coords.getClassifier()).setExtension(coords.getExtension());
    }

    @Override
    public void resolve(MavenArtifact artifact) throws MavenUniverseException {
        if (artifact.isResolved()) {
            throw new MavenUniverseException("Artifact is already resolved");
        }
        Path path = null;
        try {
            path = this.getArtifactPath(artifact);
            if (!Files.exists(path, new LinkOption[0])) {
                throw new MavenUniverseException(this.pathDoesNotExist(artifact, path));
            }
            artifact.setPath(path);
            return;
        }
        catch (MavenUniverseException e) {
            if (this.fallback == null) {
                throw e;
            }
            try {
                this.fallback.resolve(artifact);
            }
            catch (MavenUniverseException e2) {
                throw new MavenUniverseException(this.pathDoesNotExist(artifact, path), e2);
            }
            return;
        }
    }

    @Override
    public void resolveLatestVersion(MavenArtifact artifact, String lowestQualifier) throws MavenUniverseException {
        if (artifact.isResolved()) {
            throw new MavenUniverseException("Artifact is already resolved");
        }
        Path path = null;
        try {
            path = this.resolveLatestVersionDir(artifact, lowestQualifier);
            artifact.setVersion(path.getFileName().toString());
            path = path.resolve(artifact.getArtifactFileName());
            if (!Files.exists(path, new LinkOption[0])) {
                throw new MavenUniverseException(this.pathDoesNotExist(artifact, path));
            }
            artifact.setPath(path);
            return;
        }
        catch (MavenUniverseException e) {
            if (this.fallback == null) {
                throw e;
            }
            this.fallback.resolveLatestVersion(artifact, lowestQualifier);
            return;
        }
    }

    private String pathDoesNotExist(MavenArtifact artifact, Path path) throws MavenUniverseException {
        return "Failed to resolve " + artifact.getCoordsAsString() + ": " + path + " does not exist";
    }

    @Override
    public String getLatestVersion(MavenArtifact artifact, String lowestQualifier) throws MavenUniverseException {
        return this.resolveLatestVersionDir(artifact, lowestQualifier).getFileName().toString();
    }

    @Override
    public void install(MavenArtifact artifact, Path path) throws MavenUniverseException {
        if (artifact.isResolved()) {
            throw new MavenUniverseException("Artifact is already associated with a path " + path);
        }
        Path targetPath = this.getArtifactPath(artifact);
        try {
            IoUtils.copy(path, targetPath);
        }
        catch (IOException e) {
            throw new MavenUniverseException("Failed to install " + artifact.getCoordsAsString(), e);
        }
        artifact.setPath(targetPath);
    }

    private Path resolveLatestVersionDir(MavenArtifact artifact, String lowestQualifier) throws MavenUniverseException {
        String[] groupParts;
        if (artifact.getGroupId() == null) {
            MavenErrors.missingGroupId();
        }
        if (artifact.getArtifactId() == null) {
            MavenErrors.missingArtifactId();
        }
        if (artifact.getVersionRange() == null) {
            throw new MavenUniverseException("Version range is missing for " + artifact.getCoordsAsString());
        }
        Path artifactDir = this.repoHome;
        for (String part : groupParts = artifact.getGroupId().split("\\.")) {
            artifactDir = artifactDir.resolve(part);
        }
        if (!Files.exists(artifactDir = artifactDir.resolve(artifact.getArtifactId()), new LinkOption[0])) {
            throw MavenErrors.artifactNotFound(artifact, this.repoHome);
        }
        MavenArtifactVersionRange range = versionRangeParser.parseRange(artifact.getVersionRange());
        if (lowestQualifier == null) {
            lowestQualifier = "";
        }
        Path latestDir = null;
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(artifactDir);){
            MavenArtifactVersion latest = null;
            for (Path versionDir : stream) {
                MavenArtifactVersion next = new MavenArtifactVersion(versionDir.getFileName().toString());
                if (!range.includesVersion(next) || !next.isQualifierHigher(lowestQualifier, true) || latest != null && latest.compareTo(next) > 0) continue;
                latest = next;
                latestDir = versionDir;
            }
        }
        catch (Exception e) {
            throw new MavenUniverseException("Failed to determine the latest version of " + artifact.getCoordsAsString(), e);
        }
        if (latestDir == null) {
            throw new MavenUniverseException("Failed to determine the latest version of " + artifact.getCoordsAsString());
        }
        return latestDir;
    }

    private Path getArtifactPath(MavenArtifact artifact) throws MavenUniverseException {
        String[] groupParts;
        if (artifact.getGroupId() == null) {
            MavenErrors.missingGroupId();
        }
        Path p = this.repoHome;
        for (String part : groupParts = artifact.getGroupId().split("\\.")) {
            p = p.resolve(part);
        }
        String artifactFileName = artifact.getArtifactFileName();
        return p.resolve(artifact.getArtifactId()).resolve(artifact.getVersion()).resolve(artifactFileName);
    }

    @Override
    public boolean isResolved(MavenArtifact artifact) throws MavenUniverseException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isLatestVersionResolved(MavenArtifact artifact, String lowestQualifier) throws MavenUniverseException {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

