/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.universe.maven.xml;

import java.util.Collection;
import javax.xml.stream.XMLStreamException;
import org.jboss.galleon.universe.maven.MavenProducerDescription;
import org.jboss.galleon.universe.maven.xml.MavenProducerXmlParser10;
import org.jboss.galleon.xml.BaseXmlWriter;
import org.jboss.galleon.xml.util.ElementNode;
import org.jboss.galleon.xml.util.TextNode;

public class MavenProducerXmlWriter
extends BaseXmlWriter<MavenProducerDescription<?>> {
    private static final MavenProducerXmlWriter INSTANCE = new MavenProducerXmlWriter();

    public static MavenProducerXmlWriter getInstance() {
        return INSTANCE;
    }

    @Override
    protected ElementNode toElement(MavenProducerDescription<?> producer) throws XMLStreamException {
        ElementNode producerEl = MavenProducerXmlWriter.addElement(null, MavenProducerXmlParser10.Element.PRODUCER);
        MavenProducerXmlWriter.addAttribute(producerEl, MavenProducerXmlParser10.Attribute.NAME, producer.getName());
        if (producer.getFeaturePackGroupId() != null) {
            MavenProducerXmlWriter.addElement(producerEl, MavenProducerXmlParser10.Element.FP_GROUP_ID).addChild(new TextNode(producer.getFeaturePackGroupId()));
        }
        if (producer.getFeaturePackArtifactId() != null) {
            MavenProducerXmlWriter.addElement(producerEl, MavenProducerXmlParser10.Element.FP_ARTIFACT_ID).addChild(new TextNode(producer.getFeaturePackArtifactId()));
        }
        ElementNode frequenciesEl = MavenProducerXmlWriter.addElement(producerEl, MavenProducerXmlParser10.Element.FREQUENCIES);
        Collection<String> frequencies = producer.getFrequencies();
        for (String frequency : frequencies) {
            MavenProducerXmlWriter.addElement(frequenciesEl, MavenProducerXmlParser10.Element.FREQUENCY).addChild(new TextNode(frequency));
        }
        return producerEl;
    }
}

