/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.xml;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.jboss.galleon.ProvisioningDescriptionException;
import org.jboss.galleon.config.ConfigCustomizationsBuilder;
import org.jboss.galleon.config.ConfigId;
import org.jboss.galleon.config.ConfigModel;
import org.jboss.galleon.config.FeaturePackConfig;
import org.jboss.galleon.config.FeaturePackDepsConfigBuilder;
import org.jboss.galleon.config.ProvisioningConfig;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.jboss.galleon.universe.UniverseSpec;
import org.jboss.galleon.util.ParsingUtils;
import org.jboss.galleon.xml.ConfigXml;
import org.jboss.galleon.xml.FeaturePackPackagesConfigParser10;
import org.jboss.galleon.xml.PlugableXmlParser;
import org.jboss.galleon.xml.XmlNameProvider;
import org.jboss.staxmapper.XMLExtendedStreamReader;

public class ProvisioningXmlParser20
implements PlugableXmlParser<ProvisioningConfig.Builder> {
    public static final String NAMESPACE_2_0 = "urn:jboss:galleon:provisioning:2.0";
    public static final QName ROOT_2_0 = new QName("urn:jboss:galleon:provisioning:2.0", Element.INSTALLATION.getLocalName());

    @Override
    public QName getRoot() {
        return ROOT_2_0;
    }

    @Override
    public void readElement(XMLExtendedStreamReader reader, ProvisioningConfig.Builder builder) throws XMLStreamException {
        ParsingUtils.parseNoAttributes(reader);
        block12: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getLocalName());
                    switch (element) {
                        case UNIVERSES: {
                            ProvisioningXmlParser20.readUniverses(reader, builder);
                            continue block12;
                        }
                        case FEATURE_PACK: {
                            ProvisioningXmlParser20.readFeaturePackDep(reader, builder);
                            continue block12;
                        }
                        case DEFAULT_CONFIGS: {
                            ProvisioningXmlParser20.parseDefaultConfigs(reader, builder);
                            continue block12;
                        }
                        case CONFIG: {
                            ConfigModel.Builder config = ConfigModel.builder();
                            ConfigXml.readConfig(reader, config);
                            try {
                                builder.addConfig(config.build());
                                continue block12;
                            }
                            catch (ProvisioningDescriptionException e) {
                                throw new XMLStreamException("Failed to parse " + Element.CONFIG, reader.getLocation(), e);
                            }
                        }
                    }
                    throw ParsingUtils.unexpectedContent(reader);
                }
            }
            throw ParsingUtils.unexpectedContent(reader);
        }
        throw ParsingUtils.endOfDocument(reader.getLocation());
    }

    static void readUniverses(XMLExtendedStreamReader reader, FeaturePackDepsConfigBuilder<?> fpBuilder) throws XMLStreamException {
        ParsingUtils.parseNoAttributes(reader);
        block7: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName().getLocalPart());
                    switch (element) {
                        case UNIVERSE: {
                            ProvisioningXmlParser20.readUniverse(reader, fpBuilder);
                            continue block7;
                        }
                    }
                    throw ParsingUtils.unexpectedContent(reader);
                }
            }
            throw ParsingUtils.unexpectedContent(reader);
        }
    }

    private static void readUniverse(XMLExtendedStreamReader reader, FeaturePackDepsConfigBuilder<?> fpBuilder) throws XMLStreamException {
        String name = null;
        String factory = null;
        String location = null;
        int count = reader.getAttributeCount();
        block7: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i).getLocalPart());
            switch (attribute) {
                case FACTORY: {
                    factory = reader.getAttributeValue(i);
                    continue block7;
                }
                case NAME: {
                    name = reader.getAttributeValue(i);
                    continue block7;
                }
                case LOCATION: {
                    location = reader.getAttributeValue(i);
                    continue block7;
                }
                default: {
                    throw ParsingUtils.unexpectedContent(reader);
                }
            }
        }
        ParsingUtils.parseNoContent(reader);
        try {
            fpBuilder.addUniverse(name, factory, location);
        }
        catch (ProvisioningDescriptionException e) {
            throw new XMLStreamException("Failed to parse universe declaration", e);
        }
    }

    static void readFeaturePackDep(XMLExtendedStreamReader reader, FeaturePackDepsConfigBuilder<?> fpBuilder) throws XMLStreamException {
        FeaturePackLocation location = null;
        int count = reader.getAttributeCount();
        block21: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i).getLocalPart());
            switch (attribute) {
                case LOCATION: {
                    try {
                        location = FeaturePackLocation.fromString(reader.getAttributeValue(i));
                        continue block21;
                    }
                    catch (IllegalArgumentException e) {
                        throw ParsingUtils.error("Failed to parse feature-pack location " + reader.getAttributeValue(i), reader.getLocation(), e);
                    }
                }
                default: {
                    throw ParsingUtils.unexpectedContent(reader);
                }
            }
        }
        if (location == null) {
            throw ParsingUtils.missingAttributes(reader.getLocation(), Collections.singleton(Attribute.LOCATION));
        }
        if (location.getUniverse() == null) {
            if (!fpBuilder.hasDefaultUniverse()) {
                throw new XMLStreamException("Failed to parse feature-pack configuration for " + location + ": default universe was not configured");
            }
            location = new FeaturePackLocation(fpBuilder.getDefaultUniverse(), location.getProducerName(), location.getChannelName(), location.getFrequency(), location.getBuild());
        } else {
            UniverseSpec resolvedConfig = fpBuilder.getUniverseSpec(location.getUniverse().toString());
            if (resolvedConfig != null) {
                location = new FeaturePackLocation(resolvedConfig, location.getProducerName(), location.getChannelName(), location.getFrequency(), location.getBuild());
            }
        }
        String origin = null;
        FeaturePackConfig.Builder depBuilder = FeaturePackConfig.builder(location);
        block22: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    try {
                        fpBuilder.addFeaturePackDep(origin, depBuilder.build());
                    }
                    catch (ProvisioningDescriptionException e) {
                        throw new XMLStreamException("Failed to add feature-pack configuration dependency", e);
                    }
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName().getLocalPart());
                    switch (element) {
                        case PACKAGES: {
                            try {
                                FeaturePackPackagesConfigParser10.readPackages(reader, depBuilder);
                                continue block22;
                            }
                            catch (ProvisioningDescriptionException e) {
                                throw new XMLStreamException("Failed to parse " + Element.PACKAGES.getLocalName() + ": " + e.getLocalizedMessage(), reader.getLocation(), e);
                            }
                        }
                        case ORIGIN: {
                            origin = reader.getElementText();
                            continue block22;
                        }
                        case DEFAULT_CONFIGS: {
                            ProvisioningXmlParser20.parseDefaultConfigs(reader, depBuilder);
                            continue block22;
                        }
                        case CONFIG: {
                            ConfigModel.Builder config = ConfigModel.builder();
                            ConfigXml.readConfig(reader, config);
                            try {
                                depBuilder.addConfig(config.build());
                                continue block22;
                            }
                            catch (ProvisioningDescriptionException e) {
                                throw new XMLStreamException("Failed to parse " + Element.CONFIG, reader.getLocation(), e);
                            }
                        }
                    }
                    throw ParsingUtils.unexpectedContent(reader);
                }
            }
            throw ParsingUtils.unexpectedContent(reader);
        }
    }

    public static void parseDefaultConfigs(XMLExtendedStreamReader reader, ConfigCustomizationsBuilder<?> fpBuilder) throws XMLStreamException {
        block12: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i).getLocalPart());
            switch (attribute) {
                case INHERIT: {
                    fpBuilder.setInheritConfigs(Boolean.parseBoolean(reader.getAttributeValue(i)));
                    continue block12;
                }
                case INHERIT_UNNAMED_MODELS: {
                    fpBuilder.setInheritModelOnlyConfigs(Boolean.parseBoolean(reader.getAttributeValue(i)));
                    continue block12;
                }
                default: {
                    throw ParsingUtils.unexpectedContent(reader);
                }
            }
        }
        block13: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getLocalName());
                    switch (element) {
                        case INCLUDE: {
                            ProvisioningXmlParser20.parseConfigModelRef(reader, fpBuilder, true);
                            continue block13;
                        }
                        case EXCLUDE: {
                            ProvisioningXmlParser20.parseConfigModelRef(reader, fpBuilder, false);
                            continue block13;
                        }
                    }
                    throw ParsingUtils.unexpectedContent(reader);
                }
            }
            throw ParsingUtils.unexpectedContent(reader);
        }
        throw ParsingUtils.endOfDocument(reader.getLocation());
    }

    private static void parseConfigModelRef(XMLExtendedStreamReader reader, ConfigCustomizationsBuilder<?> fpBuilder, boolean include) throws XMLStreamException {
        String name = null;
        String model = null;
        Boolean namedConfigsOnly = null;
        block7: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i).getLocalPart());
            switch (attribute) {
                case NAME: {
                    name = reader.getAttributeValue(i);
                    continue block7;
                }
                case MODEL: {
                    model = reader.getAttributeValue(i);
                    continue block7;
                }
                case NAMED_MODELS_ONLY: {
                    namedConfigsOnly = Boolean.parseBoolean(reader.getAttributeValue(i));
                    continue block7;
                }
                default: {
                    throw ParsingUtils.unexpectedContent(reader);
                }
            }
        }
        try {
            if (include) {
                if (name == null) {
                    fpBuilder.includeConfigModel(model);
                } else {
                    fpBuilder.includeDefaultConfig(new ConfigId(model, name));
                }
            } else if (name == null) {
                if (namedConfigsOnly != null) {
                    fpBuilder.excludeConfigModel(model, namedConfigsOnly);
                } else {
                    fpBuilder.excludeConfigModel(model);
                }
            } else {
                fpBuilder.excludeDefaultConfig(model, name);
            }
        }
        catch (ProvisioningDescriptionException e) {
            throw new XMLStreamException(e);
        }
        ParsingUtils.parseNoContent(reader);
    }

    static enum Attribute implements XmlNameProvider
    {
        FACTORY("factory"),
        INHERIT("inherit"),
        INHERIT_UNNAMED_MODELS("inherit-unnamed-models"),
        LOCATION("location"),
        MODEL("model"),
        NAME("name"),
        NAMED_MODELS_ONLY("named-models-only"),
        UNKNOWN(null);

        private static final Map<String, Attribute> attributes;
        private final String name;

        static Attribute of(String name) {
            Attribute attribute = attributes.get(name);
            return attribute == null ? UNKNOWN : attribute;
        }

        private Attribute(String name) {
            this.name = name;
        }

        @Override
        public String getLocalName() {
            return this.name;
        }

        @Override
        public String getNamespace() {
            return null;
        }

        public String toString() {
            return this.name;
        }

        static {
            attributes = new HashMap<String, Attribute>(8);
            attributes.put(Attribute.FACTORY.name, FACTORY);
            attributes.put(Attribute.INHERIT.name, INHERIT);
            attributes.put(Attribute.INHERIT_UNNAMED_MODELS.name, INHERIT_UNNAMED_MODELS);
            attributes.put(Attribute.MODEL.name, MODEL);
            attributes.put(Attribute.NAME.name, NAME);
            attributes.put(Attribute.NAMED_MODELS_ONLY.name, NAMED_MODELS_ONLY);
            attributes.put(Attribute.LOCATION.name, LOCATION);
            attributes.put(null, UNKNOWN);
        }
    }

    static enum Element implements XmlNameProvider
    {
        CONFIG("config"),
        DEFAULT_CONFIGS("default-configs"),
        EXCLUDE("exclude"),
        FEATURE_PACK("feature-pack"),
        INCLUDE("include"),
        INSTALLATION("installation"),
        ORIGIN("origin"),
        PACKAGES("packages"),
        UNIVERSES("universes"),
        UNIVERSE("universe"),
        UNKNOWN(null);

        private static final Map<String, Element> elementsByLocal;
        private final String name;
        private final String namespace = "urn:jboss:galleon:provisioning:2.0";

        static Element of(String localName) {
            Element element = elementsByLocal.get(localName);
            return element == null ? UNKNOWN : element;
        }

        private Element(String name) {
            this.name = name;
        }

        @Override
        public String getLocalName() {
            return this.name;
        }

        @Override
        public String getNamespace() {
            return ProvisioningXmlParser20.NAMESPACE_2_0;
        }

        public String toString() {
            return this.name;
        }

        static {
            elementsByLocal = new HashMap<String, Element>(11);
            elementsByLocal.put(Element.CONFIG.name, CONFIG);
            elementsByLocal.put(Element.DEFAULT_CONFIGS.name, DEFAULT_CONFIGS);
            elementsByLocal.put(Element.EXCLUDE.name, EXCLUDE);
            elementsByLocal.put(Element.FEATURE_PACK.name, FEATURE_PACK);
            elementsByLocal.put(Element.INCLUDE.name, INCLUDE);
            elementsByLocal.put(Element.INSTALLATION.name, INSTALLATION);
            elementsByLocal.put(Element.ORIGIN.name, ORIGIN);
            elementsByLocal.put(Element.PACKAGES.name, PACKAGES);
            elementsByLocal.put(Element.UNIVERSE.name, UNIVERSE);
            elementsByLocal.put(Element.UNIVERSES.name, UNIVERSES);
            elementsByLocal.put(null, UNKNOWN);
        }
    }
}

