/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.xml;

import java.util.Arrays;
import java.util.Map;
import org.jboss.galleon.config.ConfigCustomizations;
import org.jboss.galleon.config.ConfigId;
import org.jboss.galleon.config.ConfigModel;
import org.jboss.galleon.config.FeaturePackConfig;
import org.jboss.galleon.config.FeaturePackDepsConfig;
import org.jboss.galleon.config.PackageConfig;
import org.jboss.galleon.config.ProvisioningConfig;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.jboss.galleon.universe.UniverseSpec;
import org.jboss.galleon.xml.BaseXmlWriter;
import org.jboss.galleon.xml.ConfigXmlWriter;
import org.jboss.galleon.xml.ProvisioningXmlParser20;
import org.jboss.galleon.xml.util.ElementNode;
import org.jboss.galleon.xml.util.TextNode;

public class ProvisioningXmlWriter
extends BaseXmlWriter<ProvisioningConfig> {
    private static final ProvisioningXmlWriter INSTANCE = new ProvisioningXmlWriter();
    private static final String FALSE = "false";

    public static ProvisioningXmlWriter getInstance() {
        return INSTANCE;
    }

    private ProvisioningXmlWriter() {
    }

    @Override
    protected ElementNode toElement(ProvisioningConfig config) {
        ElementNode install = ProvisioningXmlWriter.addElement(null, ProvisioningXmlParser20.Element.INSTALLATION);
        ProvisioningXmlWriter.writeUniverseSpecs(config, install);
        if (config.hasFeaturePackDeps()) {
            for (FeaturePackConfig fp : config.getFeaturePackDeps()) {
                ElementNode fpElement = ProvisioningXmlWriter.addElement(install, ProvisioningXmlParser20.Element.FEATURE_PACK);
                ProvisioningXmlWriter.writeFeaturePackConfig(fpElement, fpElement.getNamespace(), config.getUserConfiguredSource(fp.getLocation()), fp, config.originOf(fp.getLocation().getProducer()));
            }
        }
        ProvisioningXmlWriter.writeConfigCustomizations(install, ProvisioningXmlParser20.Element.INSTALLATION.getNamespace(), config);
        return install;
    }

    static void writeUniverseSpecs(FeaturePackDepsConfig fpDeps, ElementNode parent) {
        ElementNode universesEl = null;
        UniverseSpec universeSpec = fpDeps.getDefaultUniverse();
        if (universeSpec != null) {
            universesEl = ProvisioningXmlWriter.addElement(parent, ProvisioningXmlParser20.Element.UNIVERSES.getLocalName(), parent.getNamespace());
            ProvisioningXmlWriter.writeUniverseConfig(universesEl, null, universeSpec.getFactory(), universeSpec.getLocation());
        }
        if (fpDeps.hasUniverseNamedSpecs()) {
            if (universesEl == null) {
                universesEl = ProvisioningXmlWriter.addElement(parent, ProvisioningXmlParser20.Element.UNIVERSES.getLocalName(), parent.getNamespace());
            }
            for (Map.Entry<String, UniverseSpec> universe : fpDeps.getUniverseNamedSpecs().entrySet()) {
                ProvisioningXmlWriter.writeUniverseConfig(universesEl, universe.getKey(), universe.getValue().getFactory(), universe.getValue().getLocation());
            }
        }
    }

    private static void writeUniverseConfig(ElementNode universesEl, String name, String factory, String location) {
        ElementNode universeEl = ProvisioningXmlWriter.addElement(universesEl, ProvisioningXmlParser20.Element.UNIVERSE.getLocalName(), universesEl.getNamespace());
        if (name != null) {
            ProvisioningXmlWriter.addAttribute(universeEl, ProvisioningXmlParser20.Attribute.NAME, name);
        }
        ProvisioningXmlWriter.addAttribute(universeEl, ProvisioningXmlParser20.Attribute.FACTORY, factory);
        if (location != null) {
            ProvisioningXmlWriter.addAttribute(universeEl, ProvisioningXmlParser20.Attribute.LOCATION, location);
        }
    }

    static void writeFeaturePackConfig(ElementNode fp, String ns, FeaturePackLocation source, FeaturePackConfig featurePack, String origin) {
        ProvisioningXmlWriter.addAttribute(fp, ProvisioningXmlParser20.Attribute.LOCATION, source.toString());
        if (origin != null) {
            ProvisioningXmlWriter.addElement(fp, ProvisioningXmlParser20.Element.ORIGIN.getLocalName(), ns).addChild(new TextNode(origin));
        }
        ProvisioningXmlWriter.writeConfigCustomizations(fp, ns, featurePack);
        ElementNode packages = null;
        if (!featurePack.isInheritPackages()) {
            packages = ProvisioningXmlWriter.addElement(fp, ProvisioningXmlParser20.Element.PACKAGES.getLocalName(), ns);
            ProvisioningXmlWriter.addAttribute(packages, ProvisioningXmlParser20.Attribute.INHERIT, FALSE);
        }
        if (featurePack.hasExcludedPackages()) {
            if (packages == null) {
                packages = ProvisioningXmlWriter.addElement(fp, ProvisioningXmlParser20.Element.PACKAGES.getLocalName(), ns);
            }
            for (String excluded : featurePack.getExcludedPackages()) {
                ElementNode exclude = ProvisioningXmlWriter.addElement(packages, ProvisioningXmlParser20.Element.EXCLUDE.getLocalName(), ns);
                ProvisioningXmlWriter.addAttribute(exclude, ProvisioningXmlParser20.Attribute.NAME, excluded);
            }
        }
        if (featurePack.hasIncludedPackages()) {
            if (packages == null) {
                packages = ProvisioningXmlWriter.addElement(fp, ProvisioningXmlParser20.Element.PACKAGES.getLocalName(), ns);
            }
            for (PackageConfig included : featurePack.getIncludedPackages()) {
                ElementNode include = ProvisioningXmlWriter.addElement(packages, ProvisioningXmlParser20.Element.INCLUDE.getLocalName(), ns);
                ProvisioningXmlWriter.addAttribute(include, ProvisioningXmlParser20.Attribute.NAME, included.getName());
            }
        }
    }

    static void writeConfigCustomizations(ElementNode parent, String ns, ConfigCustomizations configCustoms) {
        ElementNode defConfigsE = null;
        if (!configCustoms.isInheritConfigs()) {
            defConfigsE = ProvisioningXmlWriter.addElement(parent, ProvisioningXmlParser20.Element.DEFAULT_CONFIGS.getLocalName(), ns);
            ProvisioningXmlWriter.addAttribute(defConfigsE, ProvisioningXmlParser20.Attribute.INHERIT, FALSE);
        }
        if (!configCustoms.isInheritModelOnlyConfigs()) {
            if (defConfigsE == null) {
                defConfigsE = ProvisioningXmlWriter.addElement(parent, ProvisioningXmlParser20.Element.DEFAULT_CONFIGS.getLocalName(), ns);
            }
            ProvisioningXmlWriter.addAttribute(defConfigsE, ProvisioningXmlParser20.Attribute.INHERIT_UNNAMED_MODELS, FALSE);
        }
        if (configCustoms.hasFullModelsExcluded()) {
            if (defConfigsE == null) {
                defConfigsE = ProvisioningXmlWriter.addElement(parent, ProvisioningXmlParser20.Element.DEFAULT_CONFIGS.getLocalName(), ns);
            }
            for (Map.Entry<String, Boolean> entry : configCustoms.getFullModelsExcluded().entrySet()) {
                ElementNode exclude = ProvisioningXmlWriter.addElement(defConfigsE, ProvisioningXmlParser20.Element.EXCLUDE.getLocalName(), ns);
                ProvisioningXmlWriter.addAttribute(exclude, ProvisioningXmlParser20.Attribute.MODEL, entry.getKey());
                if (entry.getValue().booleanValue()) continue;
                ProvisioningXmlWriter.addAttribute(exclude, ProvisioningXmlParser20.Attribute.NAMED_MODELS_ONLY, FALSE);
            }
        }
        if (configCustoms.hasFullModelsIncluded()) {
            if (defConfigsE == null) {
                defConfigsE = ProvisioningXmlWriter.addElement(parent, ProvisioningXmlParser20.Element.DEFAULT_CONFIGS.getLocalName(), ns);
            }
            Object[] array = configCustoms.getFullModelsIncluded().toArray(new String[configCustoms.getFullModelsIncluded().size()]);
            Arrays.sort(array);
            for (Object modelName : array) {
                ElementNode included = ProvisioningXmlWriter.addElement(defConfigsE, ProvisioningXmlParser20.Element.INCLUDE.getLocalName(), ns);
                ProvisioningXmlWriter.addAttribute(included, ProvisioningXmlParser20.Attribute.MODEL, (String)modelName);
            }
        }
        if (configCustoms.hasExcludedConfigs()) {
            if (defConfigsE == null) {
                defConfigsE = ProvisioningXmlWriter.addElement(parent, ProvisioningXmlParser20.Element.DEFAULT_CONFIGS.getLocalName(), ns);
            }
            for (ConfigId configId : configCustoms.getExcludedConfigs()) {
                ElementNode excluded = ProvisioningXmlWriter.addElement(defConfigsE, ProvisioningXmlParser20.Element.EXCLUDE.getLocalName(), ns);
                if (configId.getModel() != null) {
                    ProvisioningXmlWriter.addAttribute(excluded, ProvisioningXmlParser20.Attribute.MODEL, configId.getModel());
                }
                if (configId.getName() == null) continue;
                ProvisioningXmlWriter.addAttribute(excluded, ProvisioningXmlParser20.Attribute.NAME, configId.getName());
            }
        }
        if (configCustoms.hasIncludedConfigs()) {
            if (defConfigsE == null) {
                defConfigsE = ProvisioningXmlWriter.addElement(parent, ProvisioningXmlParser20.Element.DEFAULT_CONFIGS.getLocalName(), ns);
            }
            for (ConfigId configId : configCustoms.getIncludedConfigs()) {
                ElementNode includeElement = ProvisioningXmlWriter.addElement(defConfigsE, ProvisioningXmlParser20.Element.INCLUDE.getLocalName(), ns);
                if (configId.getModel() != null) {
                    ProvisioningXmlWriter.addAttribute(includeElement, ProvisioningXmlParser20.Attribute.MODEL, configId.getModel());
                }
                if (configId.getName() == null) continue;
                ProvisioningXmlWriter.addAttribute(includeElement, ProvisioningXmlParser20.Attribute.NAME, configId.getName());
            }
        }
        if (configCustoms.hasDefinedConfigs()) {
            for (ConfigModel configModel : configCustoms.getDefinedConfigs()) {
                parent.addChild(ConfigXmlWriter.getInstance().toElement(configModel, ns));
            }
        }
    }
}

