/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import org.jboss.galleon.ArtifactCoords;
import org.jboss.galleon.ArtifactRepositoryManager;
import org.jboss.galleon.DefaultMessageWriter;
import org.jboss.galleon.Errors;
import org.jboss.galleon.MessageWriter;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.config.FeaturePackConfig;
import org.jboss.galleon.config.ProvisioningConfig;
import org.jboss.galleon.layout.ProvisioningLayout;
import org.jboss.galleon.layout.ProvisioningLayoutFactory;
import org.jboss.galleon.runtime.ProvisioningRuntime;
import org.jboss.galleon.runtime.ProvisioningRuntimeBuilder;
import org.jboss.galleon.state.ProvisionedFeaturePack;
import org.jboss.galleon.state.ProvisionedState;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.jboss.galleon.universe.UniverseFactoryLoader;
import org.jboss.galleon.universe.UniverseResolver;
import org.jboss.galleon.universe.UniverseResolverBuilder;
import org.jboss.galleon.universe.UniverseSpec;
import org.jboss.galleon.universe.galleon1.LegacyGalleon1Universe;
import org.jboss.galleon.util.IoUtils;
import org.jboss.galleon.util.PathsUtils;
import org.jboss.galleon.xml.ProvisionedStateXmlParser;
import org.jboss.galleon.xml.ProvisioningXmlParser;
import org.jboss.galleon.xml.ProvisioningXmlWriter;

public class ProvisioningManager
implements AutoCloseable {
    private final String encoding;
    private final Path installationHome;
    private final MessageWriter messageWriter;
    private final UniverseResolver universeResolver;
    private ProvisioningLayoutFactory layoutFactory;
    private boolean closeLayoutFactory;
    private ProvisioningConfig provisioningConfig;

    public static Builder builder() {
        return new Builder();
    }

    public static void checkInstallationDir(Path installationHome) throws ProvisioningException {
        if (!Files.exists(installationHome, new LinkOption[0])) {
            return;
        }
        if (!Files.isDirectory(installationHome, new LinkOption[0])) {
            throw new ProvisioningException(Errors.notADir(installationHome));
        }
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(installationHome);){
            boolean usableDir = true;
            Iterator<Path> i = stream.iterator();
            while (i.hasNext()) {
                if (i.next().getFileName().toString().equals(".galleon")) {
                    usableDir = true;
                    break;
                }
                usableDir = false;
            }
            if (!usableDir) {
                throw new ProvisioningException(Errors.homeDirNotUsable(installationHome));
            }
        }
        catch (IOException e) {
            throw new ProvisioningException(Errors.readDirectory(installationHome));
        }
    }

    private ProvisioningManager(Builder builder) throws ProvisioningException {
        this.encoding = builder.encoding;
        this.installationHome = builder.installationHome;
        MessageWriter messageWriter = this.messageWriter = builder.messageWriter == null ? DefaultMessageWriter.getDefaultInstance() : builder.messageWriter;
        if (builder.layoutFactory != null) {
            this.layoutFactory = builder.layoutFactory;
            this.closeLayoutFactory = false;
            this.universeResolver = this.layoutFactory.getUniverseResolver();
        } else {
            this.universeResolver = builder.getUniverseResolver();
        }
    }

    public ProvisioningLayoutFactory getLayoutFactory() {
        if (this.layoutFactory == null) {
            this.closeLayoutFactory = true;
            this.layoutFactory = ProvisioningLayoutFactory.getInstance(this.universeResolver);
        }
        return this.layoutFactory;
    }

    public Path getInstallationHome() {
        return this.installationHome;
    }

    public void addUniverse(String name, UniverseSpec universeSpec) throws ProvisioningException {
        ProvisioningConfig config = ((ProvisioningConfig.Builder)this.getInstallationBuilder().addUniverse(name, universeSpec)).build();
        try {
            ProvisioningXmlWriter.getInstance().write(config, PathsUtils.getProvisioningXml(this.installationHome));
        }
        catch (Exception e) {
            throw new ProvisioningException(Errors.writeFile(PathsUtils.getProvisioningXml(this.installationHome)), e);
        }
        this.provisioningConfig = config;
    }

    public void removeUniverse(String name) throws ProvisioningException {
        ProvisioningConfig config = this.getProvisioningConfig();
        if (config == null || !config.hasUniverse(name)) {
            return;
        }
        config = ((ProvisioningConfig.Builder)ProvisioningConfig.builder(config).removeUniverse(name)).build();
        try {
            ProvisioningXmlWriter.getInstance().write(config, PathsUtils.getProvisioningXml(this.installationHome));
        }
        catch (Exception e) {
            throw new ProvisioningException(Errors.writeFile(PathsUtils.getProvisioningXml(this.installationHome)), e);
        }
        this.provisioningConfig = config;
    }

    public void setDefaultUniverse(UniverseSpec universeSpec) throws ProvisioningException {
        this.addUniverse(null, universeSpec);
    }

    public ProvisioningConfig getProvisioningConfig() throws ProvisioningException {
        if (this.provisioningConfig == null) {
            this.provisioningConfig = ProvisioningXmlParser.parse(PathsUtils.getProvisioningXml(this.installationHome));
        }
        return this.provisioningConfig;
    }

    public ProvisionedState getProvisionedState() throws ProvisioningException {
        return ProvisionedStateXmlParser.parse(PathsUtils.getProvisionedStateXml(this.installationHome));
    }

    public void install(FeaturePackLocation fpl) throws ProvisioningException {
        this.install(FeaturePackConfig.forLocation(fpl));
    }

    public void install(FeaturePackLocation fpl, Map<String, String> options) throws ProvisioningException {
        this.install(FeaturePackConfig.forLocation(fpl), options);
    }

    public void install(FeaturePackConfig fpConfig) throws ProvisioningException {
        this.install(fpConfig, false);
    }

    public void install(FeaturePackConfig fpConfig, Map<String, String> options) throws ProvisioningException {
        this.install(fpConfig, false, options);
    }

    public void install(FeaturePackConfig fpConfig, boolean replaceInstalledVersion) throws ProvisioningException {
        this.install(fpConfig, replaceInstalledVersion, Collections.emptyMap());
    }

    public void install(FeaturePackConfig fpConfig, boolean replaceInstalledVersion, Map<String, String> options) throws ProvisioningException {
        ProvisionedFeaturePack installedFp;
        ProvisioningConfig.Builder configBuilder = this.getInstallationBuilder();
        ProvisionedState state = this.getProvisionedState();
        if (state != null && (installedFp = state.getFeaturePack(configBuilder.resolveUniverseSpec(fpConfig.getLocation()).getProducer())) != null && !installedFp.getFPID().getChannel().getName().equals(fpConfig.getLocation().getChannelName()) && !replaceInstalledVersion) {
            throw new ProvisioningException(Errors.featurePackVersionConflict(fpConfig.getLocation().getFPID(), installedFp.getFPID()));
        }
        if (replaceInstalledVersion) {
            configBuilder.updateFeaturePackDep(fpConfig);
        } else {
            configBuilder.addFeaturePackDep(fpConfig);
        }
        try (ProvisioningRuntime runtime = this.getRuntime(configBuilder.build(), null, options);){
            this.doProvision(runtime);
        }
    }

    public void uninstall(FeaturePackLocation.FPID fpid) throws ProvisioningException {
        String universeName;
        ProvisioningConfig provisionedConfig = this.getProvisioningConfig();
        if (provisionedConfig == null) {
            throw new ProvisioningException(Errors.unknownFeaturePack(fpid));
        }
        String string = universeName = fpid.getLocation().getUniverse() == null ? null : fpid.getLocation().getUniverse().toString();
        if (provisionedConfig.hasUniverse(universeName)) {
            fpid = fpid.getLocation().replaceUniverse(provisionedConfig.getUniverseSpec(universeName)).getFPID();
        }
        if (!provisionedConfig.hasFeaturePackDep(fpid.getProducer())) {
            if (this.getProvisionedState().hasFeaturePack(fpid.getProducer())) {
                throw new ProvisioningException(Errors.unsatisfiedFeaturePackDep(fpid.getProducer()));
            }
            throw new ProvisioningException(Errors.unknownFeaturePack(fpid));
        }
        try (ProvisioningRuntime runtime = this.getRuntime(this.provisioningConfig, fpid, Collections.emptyMap());){
            this.doProvision(runtime);
        }
    }

    public void provision(ProvisioningConfig provisioningConfig) throws ProvisioningException {
        this.provision(provisioningConfig, Collections.emptyMap());
    }

    public void provision(ProvisioningConfig provisioningConfig, Map<String, String> options) throws ProvisioningException {
        try (ProvisioningRuntime runtime = this.getRuntime(provisioningConfig, null, options);){
            this.doProvision(runtime);
        }
    }

    public void provision(ProvisioningLayout<?> provisioningLayout, Map<String, String> options) throws ProvisioningException {
        try (ProvisioningRuntime runtime = this.getRuntime(provisioningLayout, null, options);){
            this.doProvision(runtime);
        }
    }

    public void provision(Path provisioningXml) throws ProvisioningException {
        this.provision(provisioningXml, Collections.emptyMap());
    }

    public void provision(Path provisioningXml, Map<String, String> options) throws ProvisioningException {
        try (ProvisioningRuntime runtime = this.getRuntime(ProvisioningXmlParser.parse(provisioningXml), null, options);){
            this.doProvision(runtime);
        }
    }

    public void exportProvisioningConfig(Path location) throws ProvisioningException, IOException {
        Path exportPath = location;
        Path userProvisionedXml = PathsUtils.getProvisioningXml(this.installationHome);
        if (!Files.exists(userProvisionedXml, new LinkOption[0])) {
            throw new ProvisioningException("Provisioned state record is missing for " + this.installationHome);
        }
        if (Files.isDirectory(exportPath, new LinkOption[0])) {
            exportPath = exportPath.resolve(userProvisionedXml.getFileName());
        }
        IoUtils.copy(userProvisionedXml, exportPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportConfigurationChanges(Path location, FeaturePackLocation.FPID fpid, Map<String, String> options) throws ProvisioningException, IOException {
        ProvisioningConfig configuration = this.getProvisioningConfig();
        if (configuration == null) {
            Path userProvisionedXml = PathsUtils.getProvisioningXml(this.installationHome);
            if (!Files.exists(userProvisionedXml, new LinkOption[0])) {
                throw new ProvisioningException("Provisioned state record is missing for " + this.installationHome);
            }
            Path xmlTarget = location;
            if (Files.isDirectory(xmlTarget, new LinkOption[0])) {
                xmlTarget = xmlTarget.resolve(userProvisionedXml.getFileName());
            }
            Files.copy(userProvisionedXml, xmlTarget, StandardCopyOption.REPLACE_EXISTING);
        }
        Path tempInstallationDir = IoUtils.createRandomTmpDir();
        try (ProvisioningManager reference = new ProvisioningManager(ProvisioningManager.builder().setLayoutFactory(this.getLayoutFactory()).setEncoding(this.encoding).setInstallationHome(tempInstallationDir).setMessageWriter(new MessageWriter(){

            @Override
            public void verbose(Throwable cause, CharSequence message) {
            }

            @Override
            public void print(Throwable cause, CharSequence message) {
                ProvisioningManager.this.messageWriter.print(cause, message);
            }

            @Override
            public void error(Throwable cause, CharSequence message) {
                ProvisioningManager.this.messageWriter.error(cause, message);
            }

            @Override
            public boolean isVerboseEnabled() {
                return false;
            }

            @Override
            public void close() throws Exception {
            }
        }));){
            reference.provision(configuration);
            try (ProvisioningRuntime runtime = ProvisioningRuntimeBuilder.newInstance(this.messageWriter).initLayout(this.getLayoutFactory(), configuration).setEncoding(this.encoding).setInstallDir(tempInstallationDir).addOptions(options).setOperation(fpid != null ? "diff-to-feature-pack" : "diff").build();){
                if (fpid != null) {
                    ProvisioningRuntime.exportToFeaturePack(runtime, fpid, location, this.installationHome);
                } else {
                    ProvisioningRuntime.diff(runtime, location, this.installationHome);
                    runtime.getDiff().toXML(location, this.installationHome);
                }
            }
            catch (IOException | XMLStreamException e) {
                this.messageWriter.error(e, e.getMessage());
            }
        }
        finally {
            IoUtils.recursiveDelete(tempInstallationDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void upgrade(ArtifactCoords.Gav fpGav, Map<String, String> options) throws ProvisioningException, IOException {
        ProvisioningConfig configuration = this.getProvisioningConfig();
        Path tempInstallationDir = IoUtils.createRandomTmpDir();
        Path stagedDir = IoUtils.createRandomTmpDir();
        try (ProvisioningManager reference = new ProvisioningManager(ProvisioningManager.builder().setLayoutFactory(this.getLayoutFactory()).setEncoding(this.encoding).setInstallationHome(tempInstallationDir).setMessageWriter(new MessageWriter(){

            @Override
            public void verbose(Throwable cause, CharSequence message) {
            }

            @Override
            public void print(Throwable cause, CharSequence message) {
                ProvisioningManager.this.messageWriter.print(cause, message);
            }

            @Override
            public void error(Throwable cause, CharSequence message) {
                ProvisioningManager.this.messageWriter.error(cause, message);
            }

            @Override
            public boolean isVerboseEnabled() {
                return false;
            }

            @Override
            public void close() throws Exception {
            }
        }));){
            reference.provision(configuration);
        }
        Files.createDirectories(stagedDir, new FileAttribute[0]);
        reference = new ProvisioningManager(ProvisioningManager.builder().setLayoutFactory(this.getLayoutFactory()).setEncoding(this.encoding).setInstallationHome(stagedDir).setMessageWriter(new MessageWriter(){

            @Override
            public void verbose(Throwable cause, CharSequence message) {
            }

            @Override
            public void print(Throwable cause, CharSequence message) {
                ProvisioningManager.this.messageWriter.print(cause, message);
            }

            @Override
            public void error(Throwable cause, CharSequence message) {
                ProvisioningManager.this.messageWriter.error(cause, message);
            }

            @Override
            public boolean isVerboseEnabled() {
                return false;
            }

            @Override
            public void close() throws Exception {
            }
        }));
        var7_7 = null;
        try {
            reference.provision(((ProvisioningConfig.Builder)ProvisioningConfig.builder().addFeaturePackDep(FeaturePackConfig.forLocation(LegacyGalleon1Universe.toFpl(fpGav)))).build());
        }
        catch (Throwable throwable) {
            var7_7 = throwable;
            throw throwable;
        }
        finally {
            if (reference != null) {
                if (var7_7 != null) {
                    try {
                        reference.close();
                    }
                    catch (Throwable throwable) {
                        var7_7.addSuppressed(throwable);
                    }
                } else {
                    reference.close();
                }
            }
        }
        try {
            var7_7 = null;
            try (ProvisioningRuntime runtime = ProvisioningRuntimeBuilder.newInstance(this.messageWriter).initLayout(this.getLayoutFactory(), configuration).setEncoding(this.encoding).setInstallDir(tempInstallationDir).addOptions(options).setOperation("upgrade").build();){
                Files.createDirectories(tempInstallationDir.resolve("model_diff"), new FileAttribute[0]);
                ProvisioningRuntime.diff(runtime, tempInstallationDir.resolve("model_diff"), this.installationHome);
                runtime.setInstallDir(stagedDir);
                ProvisioningRuntime.upgrade(runtime, this.installationHome);
            }
            catch (Throwable throwable) {
                var7_7 = throwable;
                throw throwable;
            }
        }
        finally {
            IoUtils.recursiveDelete(tempInstallationDir);
            IoUtils.recursiveDelete(stagedDir);
        }
    }

    public ProvisioningRuntime getRuntime(ProvisioningConfig provisioningConfig, FeaturePackLocation.FPID uninstallFpid, Map<String, String> options) throws ProvisioningException {
        ProvisioningRuntimeBuilder builder = ProvisioningRuntimeBuilder.newInstance(this.messageWriter).initLayout(this.getLayoutFactory(), provisioningConfig).setEncoding(this.encoding).setInstallDir(this.installationHome).addOptions(options);
        if (uninstallFpid != null) {
            builder.uninstall(uninstallFpid);
        }
        return builder.build();
    }

    public ProvisioningRuntime getRuntime(ProvisioningLayout<?> provisioningLayout, FeaturePackLocation.FPID uninstallFpid, Map<String, String> options) throws ProvisioningException {
        ProvisioningRuntimeBuilder builder = ProvisioningRuntimeBuilder.newInstance(this.messageWriter).initLayout(provisioningLayout).setEncoding(this.encoding).setInstallDir(this.installationHome).addOptions(options);
        if (uninstallFpid != null) {
            builder.uninstall(uninstallFpid);
        }
        return builder.build();
    }

    private ProvisioningConfig.Builder getInstallationBuilder() throws ProvisioningException {
        return ProvisioningConfig.builder(this.getProvisioningConfig());
    }

    private void doProvision(ProvisioningRuntime runtime) throws ProvisioningException {
        ProvisioningManager.checkInstallationDir(this.installationHome);
        if (runtime == null || !runtime.getProvisioningConfig().hasFeaturePackDeps()) {
            this.emptyHomeDir();
            this.provisioningConfig = null;
            return;
        }
        try {
            ProvisioningRuntime.install(runtime);
        }
        finally {
            this.provisioningConfig = null;
        }
    }

    private void emptyHomeDir() throws ProvisioningException {
        if (!Files.exists(this.installationHome, new LinkOption[0])) {
            return;
        }
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(this.installationHome);){
            for (Path p : stream) {
                IoUtils.recursiveDelete(p);
            }
        }
        catch (IOException e) {
            throw new ProvisioningException(Errors.readDirectory(this.installationHome));
        }
    }

    @Override
    public void close() {
        if (this.closeLayoutFactory) {
            this.layoutFactory.close();
        }
    }

    public static class Builder
    extends UniverseResolverBuilder<Builder> {
        private String encoding = "UTF-8";
        private Path installationHome;
        private ProvisioningLayoutFactory layoutFactory;
        private MessageWriter messageWriter;
        private UniverseResolver resolver;

        private Builder() {
        }

        public Builder setArtifactResolver(ArtifactRepositoryManager arm) {
            try {
                return (Builder)this.addArtifactResolver(arm);
            }
            catch (ProvisioningException e) {
                throw new IllegalStateException("Failed to set artifact resolver", e);
            }
        }

        public Builder setEncoding(String encoding) {
            this.encoding = encoding;
            return this;
        }

        public Builder setInstallationHome(Path installationHome) {
            this.installationHome = installationHome;
            return this;
        }

        public Builder setLayoutFactory(ProvisioningLayoutFactory layoutFactory) throws ProvisioningException {
            if (this.ufl != null) {
                throw new ProvisioningException("Universe factory loader has already been initialized which conflicts with the initialization of provisioning layout factory");
            }
            if (this.resolver != null) {
                throw new ProvisioningException("Universe resolver has already been initialized which conflicts with the initialization of provisioning layout factory");
            }
            this.layoutFactory = layoutFactory;
            return this;
        }

        @Override
        protected UniverseFactoryLoader getUfl() throws ProvisioningException {
            if (this.layoutFactory != null) {
                throw new ProvisioningException("Provisioning layout factory has already been initialized which conflicts with the initialization of universe factory loader");
            }
            if (this.resolver != null) {
                throw new ProvisioningException("Universe resolver has already been initialized which conflicts with the initialization of universe factory loader");
            }
            return super.getUfl();
        }

        public Builder setMessageWriter(MessageWriter messageWriter) {
            this.messageWriter = messageWriter;
            return this;
        }

        public Builder setUniverseResolver(UniverseResolver resolver) throws ProvisioningException {
            if (this.ufl != null) {
                throw new ProvisioningException("Universe factory loader has already been initialized which conflicts with the initialization of universe resolver");
            }
            if (this.layoutFactory != null) {
                throw new ProvisioningException("Provisioning layout factory has already been initialized which conflicts with the initialization of universe resolver");
            }
            this.resolver = resolver;
            return this;
        }

        public ProvisioningManager build() throws ProvisioningException {
            return new ProvisioningManager(this);
        }

        protected UniverseResolver getUniverseResolver() throws ProvisioningException {
            return this.resolver == null ? this.buildUniverseResolver() : this.resolver;
        }
    }
}

