/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.galleon.ProvisioningManager;
import org.jboss.galleon.cli.AbstractCompleter;
import org.jboss.galleon.cli.PmCompleterInvocation;
import org.jboss.galleon.cli.ProvisioningCommand;
import org.jboss.galleon.config.FeaturePackConfig;

public class InstalledStreamCompleter
extends AbstractCompleter {
    @Override
    protected List<String> getItems(PmCompleterInvocation completerInvocation) {
        ProvisioningCommand cmd = (ProvisioningCommand)completerInvocation.getCommand();
        Path currentDir = cmd.getTargetDir(completerInvocation.getAeshContext());
        ArrayList<String> items = new ArrayList<String>();
        try {
            ProvisioningManager.checkInstallationDir(currentDir);
            ProvisioningManager mgr = completerInvocation.getPmSession().newProvisioningManager(currentDir, false);
            for (FeaturePackConfig fp : mgr.getProvisioningConfig().getFeaturePackDeps()) {
                if (fp.getLocation().getBuild() == null) continue;
                items.add(fp.getLocation().toString());
            }
        }
        catch (Exception ex) {
            Logger.getLogger(InstalledStreamCompleter.class.getName()).log(Level.FINEST, "Exception while completing: {0}", ex.getLocalizedMessage());
        }
        return items;
    }
}

