/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli;

import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import org.eclipse.aether.RepositoryListener;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.installation.InstallRequest;
import org.eclipse.aether.installation.InstallationException;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.VersionRangeRequest;
import org.eclipse.aether.resolution.VersionRangeResolutionException;
import org.eclipse.aether.resolution.VersionRangeResult;
import org.jboss.galleon.ArtifactException;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.cli.Util;
import org.jboss.galleon.cli.config.mvn.MavenConfig;
import org.jboss.galleon.cli.config.mvn.MavenSettings;
import org.jboss.galleon.maven.plugin.FpMavenErrors;
import org.jboss.galleon.universe.maven.MavenArtifact;
import org.jboss.galleon.universe.maven.MavenErrors;
import org.jboss.galleon.universe.maven.MavenUniverseException;
import org.jboss.galleon.universe.maven.repo.MavenArtifactVersion;
import org.jboss.galleon.universe.maven.repo.MavenArtifactVersionRange;
import org.jboss.galleon.universe.maven.repo.MavenArtifactVersionRangeParser;
import org.jboss.galleon.universe.maven.repo.MavenRepoManager;

public class MavenArtifactRepositoryManager
implements MavenRepoManager {
    private static final MavenArtifactVersionRangeParser versionRangeParser = new MavenArtifactVersionRangeParser();
    public static final String DEFAULT_REPOSITORY_TYPE = "default";
    private final RepositorySystem repoSystem = Util.newRepositorySystem();
    private final MavenConfig config;
    private final RepositoryListener listener;
    private MavenSettings mavenSettings;
    private boolean commandStarted;

    MavenArtifactRepositoryManager(MavenConfig config, RepositoryListener listener) {
        this.config = config;
        this.listener = listener;
    }

    void commandStart() {
        this.commandStarted = true;
        this.mavenSettings = null;
    }

    void commandEnd() {
        this.commandStarted = false;
    }

    private MavenSettings getSettings() throws ArtifactException {
        if (this.commandStarted) {
            if (this.mavenSettings == null) {
                this.mavenSettings = this.config.buildSettings(this.repoSystem, this.listener);
            }
        } else {
            this.mavenSettings = this.config.buildSettings(this.repoSystem, this.listener);
        }
        return this.mavenSettings;
    }

    private Path doResolve(ArtifactRequest request, String coords) throws ArtifactException {
        ArtifactResult result;
        request.setRepositories(this.getSettings().getRepositories());
        try {
            result = this.repoSystem.resolveArtifact(this.getSettings().getSession(), request);
        }
        catch (ArtifactResolutionException e) {
            throw new ArtifactException(FpMavenErrors.artifactResolution(coords), e);
        }
        if (!result.isResolved()) {
            throw new ArtifactException(FpMavenErrors.artifactResolution(coords));
        }
        if (result.isMissing()) {
            throw new ArtifactException(FpMavenErrors.artifactMissing(coords));
        }
        return Paths.get(result.getArtifact().getFile().toURI());
    }

    private void doInstall(InstallRequest request) throws InstallationException, ArtifactException {
        this.repoSystem.install(this.getSettings().getSession(), request);
    }

    private String doGetHighestVersion(Artifact artifact, String coords) throws ArtifactException {
        VersionRangeResult rangeResult;
        VersionRangeRequest rangeRequest = new VersionRangeRequest();
        rangeRequest.setArtifact(artifact);
        rangeRequest.setRepositories(this.getSettings().getRepositories());
        try {
            rangeResult = this.repoSystem.resolveVersionRange(this.getSettings().getSession(), rangeRequest);
        }
        catch (VersionRangeResolutionException ex) {
            throw new ArtifactException(ex.getLocalizedMessage(), ex);
        }
        String version = null;
        if (rangeResult != null && rangeResult.getHighestVersion() != null) {
            version = rangeResult.getHighestVersion().toString();
        }
        if (version == null) {
            throw new ArtifactException("No version retrieved for " + coords);
        }
        return version;
    }

    @Override
    public String getRepositoryId() {
        return "repository.maven";
    }

    @Override
    public Path resolve(String location) throws ProvisioningException {
        return MavenRepoManager.super.resolve(location);
    }

    @Override
    public void resolve(MavenArtifact artifact) throws MavenUniverseException {
        if (artifact.isResolved()) {
            throw new MavenUniverseException("Artifact is already resolved");
        }
        ArtifactRequest request = new ArtifactRequest();
        request.setArtifact(new DefaultArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getClassifier(), artifact.getExtension(), artifact.getVersion()));
        try {
            Path path = this.doResolve(request, artifact.getCoordsAsString());
            artifact.setPath(path);
        }
        catch (ArtifactException ex) {
            throw new MavenUniverseException(ex.getLocalizedMessage());
        }
    }

    @Override
    public void resolveLatestVersion(MavenArtifact mavenArtifact, String lowestQualifier) throws MavenUniverseException {
        DefaultArtifact artifact = new DefaultArtifact(mavenArtifact.getGroupId(), mavenArtifact.getArtifactId(), mavenArtifact.getExtension(), mavenArtifact.getVersionRange());
        try {
            String version = this.doGetHighestVersion(artifact, mavenArtifact.getCoordsAsString());
            mavenArtifact.setVersion(version);
            this.resolve(mavenArtifact);
        }
        catch (ArtifactException ex) {
            throw new MavenUniverseException(ex.getLocalizedMessage());
        }
    }

    @Override
    public String getLatestVersion(MavenArtifact artifact, String lowestQualifier) throws MavenUniverseException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void install(MavenArtifact artifact, Path path) throws MavenUniverseException {
        if (artifact.isResolved()) {
            throw new MavenUniverseException("Artifact is already associated with a path " + path);
        }
        InstallRequest request = new InstallRequest();
        request.addArtifact(new DefaultArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getClassifier(), artifact.getExtension(), artifact.getVersion(), Collections.emptyMap(), path.toFile()));
        try {
            this.doInstall(request);
            artifact.setPath(this.getArtifactPath(artifact));
        }
        catch (InstallationException | ArtifactException ex) {
            throw new MavenUniverseException(ex.getLocalizedMessage());
        }
    }

    private Path getArtifactPath(MavenArtifact artifact) throws MavenUniverseException, ArtifactException {
        String[] groupParts;
        if (artifact.getGroupId() == null) {
            MavenErrors.missingGroupId();
        }
        Path p = this.getSettings().getSession().getLocalRepository().getBasedir().toPath();
        for (String part : groupParts = artifact.getGroupId().split("\\.")) {
            p = p.resolve(part);
        }
        String artifactFileName = artifact.getArtifactFileName();
        return p.resolve(artifact.getArtifactId()).resolve(artifact.getVersion()).resolve(artifactFileName);
    }

    @Override
    public boolean isResolved(MavenArtifact artifact) throws MavenUniverseException {
        if (artifact.isResolved()) {
            return true;
        }
        try {
            Path path = this.getArtifactPath(artifact);
            return Files.exists(path, new LinkOption[0]);
        }
        catch (ArtifactException e) {
            throw new MavenUniverseException(e.getLocalizedMessage());
        }
    }

    @Override
    public boolean isLatestVersionResolved(MavenArtifact artifact, String lowestQualifier) throws MavenUniverseException {
        if (artifact.isResolved()) {
            return true;
        }
        try {
            Path path = this.resolveLatestVersionDir(artifact, lowestQualifier);
            return Files.exists(path, new LinkOption[0]);
        }
        catch (ArtifactException e) {
            throw new MavenUniverseException(e.getLocalizedMessage(), e);
        }
    }

    private Path resolveLatestVersionDir(MavenArtifact artifact, String lowestQualifier) throws MavenUniverseException, ArtifactException {
        String[] groupParts;
        Path repoHome;
        if (artifact.getGroupId() == null) {
            MavenErrors.missingGroupId();
        }
        if (artifact.getArtifactId() == null) {
            MavenErrors.missingArtifactId();
        }
        if (artifact.getVersionRange() == null) {
            throw new MavenUniverseException("Version range is missing for " + artifact.getCoordsAsString());
        }
        Path artifactDir = repoHome = this.getSettings().getSession().getLocalRepository().getBasedir().toPath();
        for (String part : groupParts = artifact.getGroupId().split("\\.")) {
            artifactDir = artifactDir.resolve(part);
        }
        if (!Files.exists(artifactDir = artifactDir.resolve(artifact.getArtifactId()), new LinkOption[0])) {
            throw MavenErrors.artifactNotFound(artifact, repoHome);
        }
        MavenArtifactVersionRange range = versionRangeParser.parseRange(artifact.getVersionRange());
        if (lowestQualifier == null) {
            lowestQualifier = "";
        }
        Path latestDir = null;
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(artifactDir);){
            MavenArtifactVersion latest = null;
            for (Path versionDir : stream) {
                MavenArtifactVersion next = new MavenArtifactVersion(versionDir.getFileName().toString());
                if (!range.includesVersion(next) || !next.isQualifierHigher(lowestQualifier, true) || latest != null && latest.compareTo(next) > 0) continue;
                latest = next;
                latestDir = versionDir;
            }
        }
        catch (Exception e) {
            throw new MavenUniverseException("Failed to determine the latest version of " + artifact.getCoordsAsString(), e);
        }
        if (latestDir == null) {
            throw new MavenUniverseException("Failed to determine the latest version of " + artifact.getCoordsAsString());
        }
        return latestDir;
    }
}

