/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli;

import org.aesh.command.CommandDefinition;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.cli.CommandExecutionException;
import org.jboss.galleon.cli.PmCommandInvocation;
import org.jboss.galleon.cli.ProvisioningCommand;
import org.jboss.galleon.config.FeaturePackConfig;
import org.jboss.galleon.config.ProvisioningConfig;
import org.jboss.galleon.state.ProvisionedFeaturePack;
import org.jboss.galleon.state.ProvisionedState;

@CommandDefinition(name="display", description="Prints provisioned spec for the specified installation.")
public class ProvisionedSpecDisplayCommand
extends ProvisioningCommand {
    @Override
    protected void runCommand(PmCommandInvocation session) throws CommandExecutionException {
        if (this.verbose) {
            ProvisionedState provisionedState;
            try {
                provisionedState = this.getManager(session).getProvisionedState();
            }
            catch (ProvisioningException e) {
                throw new CommandExecutionException("Failed to read provisioned state", e);
            }
            if (provisionedState == null || !provisionedState.hasFeaturePacks()) {
                return;
            }
            for (ProvisionedFeaturePack fp : provisionedState.getFeaturePacks()) {
                session.println(fp.getFPID().toString());
            }
        } else {
            ProvisioningConfig provisionedState;
            try {
                provisionedState = this.getManager(session).getProvisioningConfig();
            }
            catch (ProvisioningException e) {
                throw new CommandExecutionException("Failed to read provisioned state", e);
            }
            if (provisionedState == null || !provisionedState.hasFeaturePackDeps()) {
                return;
            }
            for (FeaturePackConfig fp : provisionedState.getFeaturePackDeps()) {
                session.println(fp.getLocation().toString());
            }
        }
    }
}

