/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import org.aesh.readline.AeshContext;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.ProvisioningManager;
import org.jboss.galleon.cli.MavenArtifactRepositoryManager;
import org.jboss.galleon.cli.PmSession;
import org.jboss.galleon.cli.config.Configuration;
import org.jboss.galleon.cli.config.mvn.MavenConfig;
import org.jboss.galleon.cli.resolver.PluginResolver;
import org.jboss.galleon.config.ProvisioningConfig;
import org.jboss.galleon.universe.Channel;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.jboss.galleon.universe.Producer;
import org.jboss.galleon.universe.Universe;
import org.jboss.galleon.universe.UniverseFactoryLoader;
import org.jboss.galleon.universe.UniverseResolver;
import org.jboss.galleon.universe.UniverseSpec;
import org.jboss.galleon.universe.maven.MavenUniverse;
import org.jboss.galleon.util.PathsUtils;

public class UniverseManager
implements MavenConfig.MavenChangeListener {
    public static final String JBOSS_UNIVERSE_GROUP_ID = "org.jboss.universe";
    public static final String JBOSS_UNIVERSE_ARTIFACT_ID = "community-universe";
    private final ExecutorService executorService = Executors.newCachedThreadPool(new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread thr = new Thread(r, "Galleon CLI universe initializer");
            thr.setDaemon(true);
            return thr;
        }
    });
    private static final Logger LOGGER = Logger.getLogger(UniverseManager.class.getName());
    private MavenUniverse builtinUniverse;
    private final UniverseSpec builtinUniverseSpec;
    private final UniverseResolver universeResolver;
    private AeshContext aeshContext;
    private final PmSession pmSession;
    private final List<Future<?>> submited = new ArrayList();
    private volatile boolean closed;

    UniverseManager(PmSession pmSession, Configuration config, MavenArtifactRepositoryManager maven) throws ProvisioningException {
        this.pmSession = pmSession;
        config.getMavenConfig().addListener(this);
        UniverseFactoryLoader.getInstance().addArtifactResolver(maven);
        this.universeResolver = ((UniverseResolver.Builder)UniverseResolver.builder().addArtifactResolver(maven)).build();
        this.builtinUniverseSpec = new UniverseSpec("maven", "org.jboss.universe:community-universe");
    }

    synchronized void resolveBuiltinUniverse() {
        if (this.closed) {
            return;
        }
        Future<?> f = this.executorService.submit(() -> {
            UniverseManager universeManager = this;
            synchronized (universeManager) {
                if (this.closed) {
                    return;
                }
                try {
                    ArrayList<FeaturePackLocation> deps = new ArrayList<FeaturePackLocation>();
                    this.builtinUniverse = (MavenUniverse)this.universeResolver.getUniverse(this.builtinUniverseSpec);
                    if (this.closed) {
                        return;
                    }
                    for (Producer producer : this.builtinUniverse.getProducers()) {
                        if (this.closed) {
                            return;
                        }
                        for (Channel c : producer.getChannels()) {
                            if (this.closed) {
                                return;
                            }
                            FeaturePackLocation ploc = new FeaturePackLocation(this.builtinUniverseSpec, producer.getName(), c.getName(), null, null);
                            deps.add(ploc);
                        }
                    }
                    Future<?> f2 = this.executorService.submit(() -> {
                        try {
                            for (FeaturePackLocation loc : deps) {
                                if (this.closed) {
                                    return;
                                }
                                this.pmSession.getResolver().resolveSync(loc.toString(), PluginResolver.newResolver(this.pmSession, loc));
                            }
                        }
                        catch (Exception ex) {
                            LOGGER.log(Level.SEVERE, "Can't resolve builtin universe", ex);
                        }
                    });
                    this.submited.add(f2);
                    LOGGER.log(Level.FINE, "Successfully resolved builtin universe.");
                }
                catch (Exception ex) {
                    LOGGER.log(Level.SEVERE, "Can't resolve builtin universe", ex);
                }
            }
        });
        this.submited.add(f);
    }

    synchronized void close() {
        this.closed = true;
        this.executorService.shutdownNow();
        boolean terminated = true;
        for (Future<?> f : this.submited) {
            if (f.isDone()) continue;
            terminated = false;
            break;
        }
        if (!terminated) {
            this.pmSession.println("Awaiting termination of background resolution...");
            try {
                this.executorService.awaitTermination(20L, TimeUnit.SECONDS);
            }
            catch (InterruptedException ex) {
                Thread.interrupted();
                this.pmSession.println("Interrupted");
            }
        }
    }

    void setAeshContext(AeshContext aeshContext) {
        this.aeshContext = aeshContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MavenUniverse getBuiltinUniverse() {
        UniverseManager universeManager = this;
        synchronized (universeManager) {
            return this.builtinUniverse;
        }
    }

    public UniverseSpec getBuiltinUniverseSpec() {
        return this.builtinUniverseSpec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UniverseResolver getUniverseResolver() {
        UniverseManager universeManager = this;
        synchronized (universeManager) {
            return this.universeResolver;
        }
    }

    private ProvisioningManager getProvisioningManager() throws ProvisioningException {
        Path workDir = PmSession.getWorkDir(this.aeshContext);
        if (!Files.exists(PathsUtils.getProvisioningXml(workDir), new LinkOption[0])) {
            throw new ProvisioningException("Local directory is not an installation directory");
        }
        ProvisioningManager mgr = this.pmSession.newProvisioningManager(workDir, false);
        return mgr;
    }

    public void addUniverse(String name, String factory, String location) throws ProvisioningException, IOException {
        UniverseSpec u = new UniverseSpec(factory, location);
        if (this.pmSession.getState() != null) {
            this.pmSession.getState().addUniverse(this.pmSession, name, factory, location);
            this.resolveUniverse(u);
            return;
        }
        Path workDir = PmSession.getWorkDir(this.aeshContext);
        if (!Files.exists(PathsUtils.getProvisioningXml(workDir), new LinkOption[0])) {
            throw new ProvisioningException("Local directory is not an installation directory");
        }
        ProvisioningManager mgr = this.getProvisioningManager();
        if (name != null) {
            mgr.addUniverse(name, u);
        } else {
            mgr.setDefaultUniverse(u);
        }
        this.resolveUniverse(u);
    }

    private void resolveUniverse(UniverseSpec u) throws ProvisioningException {
        Universe<?> universe = this.universeResolver.getUniverse(u);
        for (Producer p : universe.getProducers()) {
            for (Channel channel : p.getChannels()) {
            }
        }
    }

    public void removeUniverse(String name) throws ProvisioningException, IOException {
        if (this.pmSession.getState() != null) {
            this.pmSession.getState().removeUniverse(this.pmSession, name);
            return;
        }
        Path workDir = PmSession.getWorkDir(this.aeshContext);
        if (!Files.exists(PathsUtils.getProvisioningXml(workDir), new LinkOption[0])) {
            throw new ProvisioningException("Local directory is not an installation directory");
        }
        ProvisioningManager mgr = this.getProvisioningManager();
        mgr.removeUniverse(name);
    }

    public Set<String> getUniverseNames() {
        if (this.pmSession.getState() != null) {
            return this.pmSession.getState().getConfig().getUniverseNamedSpecs().keySet();
        }
        try {
            ProvisioningManager mgr = this.getProvisioningManager();
            return mgr.getProvisioningConfig().getUniverseNamedSpecs().keySet();
        }
        catch (ProvisioningException ex) {
            return Collections.emptySet();
        }
    }

    public UniverseSpec getDefaultUniverseSpec() {
        UniverseSpec defaultUniverse = null;
        if (this.pmSession.getState() != null) {
            defaultUniverse = this.pmSession.getState().getConfig().getDefaultUniverse();
        } else {
            Path workDir = PmSession.getWorkDir(this.aeshContext);
            if (!Files.exists(PathsUtils.getProvisioningXml(workDir), new LinkOption[0])) {
                return this.builtinUniverseSpec;
            }
            try {
                ProvisioningManager mgr = this.getProvisioningManager();
                defaultUniverse = mgr.getProvisioningConfig().getDefaultUniverse();
            }
            catch (ProvisioningException provisioningException) {
                // empty catch block
            }
        }
        return defaultUniverse == null ? this.builtinUniverseSpec : defaultUniverse;
    }

    public String getUniverseName(UniverseSpec u) {
        ProvisioningConfig config = null;
        if (this.pmSession.getState() != null) {
            config = this.pmSession.getState().getConfig();
        } else {
            try {
                config = this.getProvisioningManager().getProvisioningConfig();
            }
            catch (ProvisioningException ex) {
                return null;
            }
        }
        for (Map.Entry<String, UniverseSpec> entry : config.getUniverseNamedSpecs().entrySet()) {
            if (!entry.getValue().equals(u)) continue;
            return entry.getKey();
        }
        return null;
    }

    public UniverseSpec getUniverseSpec(String name) {
        ProvisioningConfig config = null;
        if (this.pmSession.getState() != null) {
            config = this.pmSession.getState().getConfig();
        } else {
            try {
                config = this.getProvisioningManager().getProvisioningConfig();
            }
            catch (ProvisioningException ex) {
                return null;
            }
        }
        return config.getUniverseNamedSpecs().get(name);
    }

    @Override
    public void configurationChanged(MavenConfig config) throws XMLStreamException, IOException {
        this.resolveBuiltinUniverse();
    }
}

