/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli.cmd;

import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.cli.cmd.FPLocationParserException;

public class FPLocationParser {
    public static ParsedFPLocation parse(String location, FPLocationCompletionConsumer consumer) throws FPLocationParserException, ProvisioningException {
        State state = State.PRODUCER;
        char[] arr = location.toCharArray();
        int offset = 0;
        ParsedFPLocation parsedLocation = new ParsedFPLocation();
        StringBuilder builder = new StringBuilder();
        while (offset < arr.length) {
            char c = arr[offset];
            ++offset;
            switch (state) {
                case PRODUCER: {
                    if (c == '@') {
                        parsedLocation.marker = offset - 1;
                        parsedLocation.producer = builder.toString();
                        builder = new StringBuilder();
                        state = State.UNIVERSE;
                        break;
                    }
                    if (c == ':') {
                        parsedLocation.marker = offset - 1;
                        parsedLocation.producer = builder.toString();
                        builder = new StringBuilder();
                        state = State.CHANNEL;
                        break;
                    }
                    builder.append(c);
                    break;
                }
                case UNIVERSE: {
                    if (c == '(') {
                        parsedLocation.marker = offset - 1;
                        parsedLocation.universeFactory = builder.toString();
                        builder = new StringBuilder();
                        state = State.UNIVERSE_LOCATION;
                        break;
                    }
                    if (c == ':') {
                        parsedLocation.marker = offset - 1;
                        parsedLocation.universeName = builder.toString();
                        builder = new StringBuilder();
                        state = State.CHANNEL;
                        break;
                    }
                    builder.append(c);
                    break;
                }
                case UNIVERSE_LOCATION: {
                    if (c == ')') {
                        parsedLocation.marker = offset - 1;
                        parsedLocation.universeLocation = builder.toString();
                        builder = new StringBuilder();
                        state = State.CHANNEL_SEPARATOR;
                        break;
                    }
                    builder.append(c);
                    break;
                }
                case CHANNEL_SEPARATOR: {
                    if (c != ':') {
                        throw new RuntimeException("Invalid syntax, no channel separator");
                    }
                    parsedLocation.marker = offset - 1;
                    state = State.CHANNEL;
                    break;
                }
                case CHANNEL: {
                    if (c == '/') {
                        parsedLocation.marker = offset - 1;
                        parsedLocation.channel = builder.toString();
                        builder = new StringBuilder();
                        state = State.FREQUENCY;
                        break;
                    }
                    builder.append(c);
                    break;
                }
                case FREQUENCY: {
                    if (c == '#') {
                        parsedLocation.marker = offset - 1;
                        parsedLocation.frequency = builder.toString();
                        builder = new StringBuilder();
                        state = State.BUILD;
                        break;
                    }
                    builder.append(c);
                }
            }
        }
        switch (state) {
            case PRODUCER: {
                parsedLocation.producer = builder.toString();
                consumer.completeProducer(parsedLocation.producer);
                break;
            }
            case UNIVERSE: {
                parsedLocation.universeFactory = builder.toString();
                consumer.completeUniverse(parsedLocation, parsedLocation.universeFactory);
                break;
            }
            case UNIVERSE_LOCATION: {
                parsedLocation.universeLocation = builder.toString();
                consumer.completeUniverseLocation(parsedLocation, parsedLocation.universeLocation);
                break;
            }
            case CHANNEL_SEPARATOR: {
                consumer.completeChannelSeparator(parsedLocation);
                break;
            }
            case CHANNEL: {
                parsedLocation.channel = builder.toString();
                consumer.completeChannel(parsedLocation, parsedLocation.channel);
                break;
            }
            case FREQUENCY: {
                parsedLocation.frequency = builder.toString();
                consumer.completeFrequency(parsedLocation, parsedLocation.frequency);
                break;
            }
            case BUILD: {
                parsedLocation.build = builder.toString();
                consumer.completeBuild(parsedLocation, parsedLocation.build);
            }
        }
        return parsedLocation;
    }

    static enum State {
        PRODUCER,
        UNIVERSE,
        UNIVERSE_LOCATION,
        CHANNEL_SEPARATOR,
        CHANNEL,
        FREQUENCY,
        BUILD;

    }

    public static class ParsedFPLocation {
        private String producer;
        private String universeName;
        private String universeFactory;
        private String universeLocation;
        private String channel;
        private String frequency;
        private String build;
        private int marker = -1;

        public String getProducer() {
            return this.producer;
        }

        public int getMarker() {
            return this.marker;
        }

        public String getUniverseName() {
            return this.universeName;
        }

        public String getUniverseFactory() {
            return this.universeFactory;
        }

        public String getUniverseLocation() {
            return this.universeLocation;
        }

        public String getChannel() {
            return this.channel;
        }

        public String getFrequency() {
            return this.frequency;
        }

        public String getBuild() {
            return this.build;
        }
    }

    public static interface FPLocationCompletionConsumer {
        public void completeProducer(String var1) throws FPLocationParserException, ProvisioningException;

        public void completeUniverse(ParsedFPLocation var1, String var2) throws FPLocationParserException, ProvisioningException;

        public void completeUniverseLocation(ParsedFPLocation var1, String var2) throws FPLocationParserException, ProvisioningException;

        public void completeChannel(ParsedFPLocation var1, String var2) throws FPLocationParserException, ProvisioningException;

        public void completeFrequency(ParsedFPLocation var1, String var2) throws FPLocationParserException, ProvisioningException;

        public void completeChannelSeparator(ParsedFPLocation var1) throws FPLocationParserException, ProvisioningException;

        public void completeBuild(ParsedFPLocation var1, String var2) throws FPLocationParserException, ProvisioningException;
    }
}

