/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli.cmd.state.configuration;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.aesh.command.option.Argument;
import org.aesh.command.option.Option;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.cli.AbstractCompleter;
import org.jboss.galleon.cli.CommandExecutionException;
import org.jboss.galleon.cli.PmCompleterInvocation;
import org.jboss.galleon.cli.PmSession;
import org.jboss.galleon.cli.cmd.state.AbstractFPProvisionedCommand;
import org.jboss.galleon.cli.model.Identity;
import org.jboss.galleon.cli.model.state.State;
import org.jboss.galleon.config.ConfigId;
import org.jboss.galleon.config.FeaturePackConfig;
import org.jboss.galleon.universe.FeaturePackLocation;

public abstract class AbstractProvisionedDefaultConfigCommand
extends AbstractFPProvisionedCommand {
    @Argument(required=false, description="Configuration name", completer=ProvisionedConfigCompleter.class)
    private String configuration;
    @Option(completer=TargetedFPCompleter.class)
    protected String origin;

    @Override
    public FeaturePackLocation.ProducerSpec getProducer(PmSession session) throws CommandExecutionException {
        if (this.origin == null) {
            return null;
        }
        try {
            return session.getResolvedLocation(this.origin).getProducer();
        }
        catch (ProvisioningException ex) {
            throw new CommandExecutionException(ex.getLocalizedMessage(), ex);
        }
    }

    protected String getConfiguration() {
        return this.configuration;
    }

    protected abstract Set<ConfigId> getTargetedConfigs(FeaturePackConfig var1);

    public static class TargetedFPCompleter
    extends AbstractCompleter {
        @Override
        protected List<String> getItems(PmCompleterInvocation completerInvocation) {
            try {
                State session = completerInvocation.getPmSession().getState();
                ArrayList<String> lst = new ArrayList<String>();
                if (session != null) {
                    AbstractProvisionedDefaultConfigCommand cmd = (AbstractProvisionedDefaultConfigCommand)completerInvocation.getCommand();
                    String config = cmd.getConfiguration();
                    for (FeaturePackConfig fc : session.getConfig().getFeaturePackDeps()) {
                        String[] split = config.split("/");
                        String model = split[0];
                        String name = split[1];
                        ConfigId cid = new ConfigId(model, name);
                        if (!cmd.getTargetedConfigs(fc).contains(cid)) continue;
                        lst.add(Identity.buildOrigin(fc.getLocation().getProducer()));
                    }
                }
                return lst;
            }
            catch (Exception ex) {
                Logger.getLogger(TargetedFPCompleter.class.getName()).log(Level.FINEST, "Exception while completing: {0}", ex.getLocalizedMessage());
                return Collections.emptyList();
            }
        }
    }

    public static class ProvisionedConfigCompleter
    extends AbstractCompleter {
        @Override
        protected List<String> getItems(PmCompleterInvocation completerInvocation) {
            try {
                ArrayList<String> configs = new ArrayList<String>();
                AbstractProvisionedDefaultConfigCommand cmd = (AbstractProvisionedDefaultConfigCommand)completerInvocation.getCommand();
                FeaturePackConfig fp = cmd.getProvisionedFP(completerInvocation.getPmSession());
                if (fp == null) {
                    for (FeaturePackConfig fc : completerInvocation.getPmSession().getState().getConfig().getFeaturePackDeps()) {
                        for (ConfigId cid : cmd.getTargetedConfigs(fc)) {
                            String name = cid.getModel() + '/' + cid.getName();
                            if (configs.contains(name)) continue;
                            configs.add(name);
                        }
                    }
                } else {
                    for (ConfigId cid : cmd.getTargetedConfigs(fp)) {
                        String name = cid.getModel() + '/' + cid.getName();
                        if (configs.contains(name)) continue;
                        configs.add(name);
                    }
                }
                return configs;
            }
            catch (Exception ex) {
                Logger.getLogger(AbstractProvisionedDefaultConfigCommand.class.getName()).log(Level.FINEST, "Exception while completing: {0}", ex.getLocalizedMessage());
                return Collections.emptyList();
            }
        }
    }
}

