/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli.cmd.state.pkg;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.aesh.command.option.Argument;
import org.aesh.command.option.Option;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.cli.AbstractCompleter;
import org.jboss.galleon.cli.CommandExecutionException;
import org.jboss.galleon.cli.PmCompleterInvocation;
import org.jboss.galleon.cli.PmSession;
import org.jboss.galleon.cli.cmd.state.AbstractFPProvisionedCommand;
import org.jboss.galleon.cli.model.Identity;
import org.jboss.galleon.cli.model.state.State;
import org.jboss.galleon.config.FeaturePackConfig;
import org.jboss.galleon.universe.FeaturePackLocation;

public abstract class AbstractProvisionedPackageCommand
extends AbstractFPProvisionedCommand {
    @Argument(required=true, description="Package name", completer=ProvisionedPackageCompleter.class)
    private String pkg;
    @Option(completer=TargetedFPCompleter.class)
    protected String origin;

    @Override
    public FeaturePackLocation.ProducerSpec getProducer(PmSession session) throws CommandExecutionException {
        if (this.origin == null) {
            return null;
        }
        try {
            return session.getResolvedLocation(this.origin).getProducer();
        }
        catch (ProvisioningException ex) {
            throw new CommandExecutionException(ex);
        }
    }

    protected String getPackage() {
        return this.pkg;
    }

    protected String getPackage(PmSession session) throws CommandExecutionException {
        FeaturePackConfig cf = this.getProvisionedFP(session);
        Set<String> ids = this.getTargetedPackages(cf);
        if (ids.contains(this.pkg)) {
            return this.pkg;
        }
        return null;
    }

    protected abstract Set<String> getTargetedPackages(FeaturePackConfig var1);

    public static class TargetedFPCompleter
    extends AbstractCompleter {
        @Override
        protected List<String> getItems(PmCompleterInvocation completerInvocation) {
            try {
                State session = completerInvocation.getPmSession().getState();
                ArrayList<String> lst = new ArrayList<String>();
                if (session != null) {
                    AbstractProvisionedPackageCommand cmd = (AbstractProvisionedPackageCommand)completerInvocation.getCommand();
                    String pkg = cmd.getPackage();
                    for (FeaturePackConfig fc : session.getConfig().getFeaturePackDeps()) {
                        if (!cmd.getTargetedPackages(fc).contains(pkg)) continue;
                        lst.add(Identity.buildOrigin(fc.getLocation().getProducer()));
                    }
                }
                return lst;
            }
            catch (Exception ex) {
                Logger.getLogger(TargetedFPCompleter.class.getName()).log(Level.FINEST, "Exception while completing: {0}", ex.getLocalizedMessage());
                return Collections.emptyList();
            }
        }
    }

    public static class ProvisionedPackageCompleter
    extends AbstractCompleter {
        @Override
        protected List<String> getItems(PmCompleterInvocation completerInvocation) {
            try {
                ArrayList<String> packages = new ArrayList<String>();
                AbstractProvisionedPackageCommand cmd = (AbstractProvisionedPackageCommand)completerInvocation.getCommand();
                FeaturePackConfig fp = cmd.getProvisionedFP(completerInvocation.getPmSession());
                if (fp == null) {
                    for (FeaturePackConfig fc : completerInvocation.getPmSession().getState().getConfig().getFeaturePackDeps()) {
                        for (String pkg : cmd.getTargetedPackages(fc)) {
                            if (packages.contains(pkg)) continue;
                            packages.add(pkg);
                        }
                    }
                } else {
                    for (String pkg : cmd.getTargetedPackages(fp)) {
                        if (packages.contains(pkg)) continue;
                        packages.add(pkg);
                    }
                }
                return packages;
            }
            catch (Exception ex) {
                Logger.getLogger(ProvisionedPackageCompleter.class.getName()).log(Level.FINEST, "Exception while completing: {0}", ex.getLocalizedMessage());
                return Collections.emptyList();
            }
        }
    }
}

