/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli.cmd.universe;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.aesh.command.Command;
import org.aesh.command.CommandDefinition;
import org.aesh.command.CommandException;
import org.aesh.command.CommandResult;
import org.aesh.command.option.Option;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.cli.AbstractCompleter;
import org.jboss.galleon.cli.PmCommandInvocation;
import org.jboss.galleon.cli.PmCompleterInvocation;
import org.jboss.galleon.universe.UniverseFactoryLoader;

@CommandDefinition(name="add", description="Add a universe, without a name, set the default universe.")
public class UniverseAddCommand
implements Command<PmCommandInvocation> {
    @Option(completer=UniverseFactoryCompleter.class, required=true)
    private String factory;
    @Option(required=false)
    private String name;
    @Option(required=true)
    private String location;

    @Override
    public CommandResult execute(PmCommandInvocation commandInvocation) throws CommandException, InterruptedException {
        try {
            commandInvocation.getPmSession().getUniverse().addUniverse(this.name, this.factory, this.location);
        }
        catch (IOException | ProvisioningException ex) {
            throw new CommandException(ex);
        }
        return CommandResult.SUCCESS;
    }

    public static class UniverseFactoryCompleter
    extends AbstractCompleter {
        @Override
        protected List<String> getItems(PmCompleterInvocation completerInvocation) {
            ArrayList<String> names = new ArrayList<String>();
            names.addAll(UniverseFactoryLoader.getInstance().getFactories());
            return names;
        }
    }
}

