/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli.cmd.universe;

import java.util.Collection;
import java.util.Set;
import org.aesh.command.Command;
import org.aesh.command.CommandDefinition;
import org.aesh.command.CommandException;
import org.aesh.command.CommandResult;
import org.aesh.utils.Config;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.cli.PmCommandInvocation;
import org.jboss.galleon.universe.Channel;
import org.jboss.galleon.universe.Producer;
import org.jboss.galleon.universe.Universe;
import org.jboss.galleon.universe.UniverseResolver;
import org.jboss.galleon.universe.UniverseSpec;
import org.jboss.galleon.universe.maven.MavenChannel;
import org.jboss.galleon.universe.maven.MavenProducer;
import org.jboss.galleon.universe.maven.MavenUniverse;
import org.jboss.galleon.universe.maven.MavenUniverseException;

@CommandDefinition(name="list", description="List universes and products")
public class UniverseListCommand
implements Command<PmCommandInvocation> {
    @Override
    public CommandResult execute(PmCommandInvocation commandInvocation) throws CommandException, InterruptedException {
        UniverseSpec defaultUniverse = commandInvocation.getPmSession().getUniverse().getDefaultUniverseSpec();
        try {
            UniverseSpec builtinUniverse = commandInvocation.getPmSession().getUniverse().getBuiltinUniverseSpec();
            if (builtinUniverse.equals(defaultUniverse)) {
                commandInvocation.println("Default universe (builtin maven universe)");
                this.printUniverse(builtinUniverse, commandInvocation);
            } else if (defaultUniverse != null) {
                commandInvocation.println("Default universe");
                this.printUniverse(defaultUniverse, commandInvocation);
            }
        }
        catch (ProvisioningException ex) {
            commandInvocation.println("Exception retrieving default universe " + ex);
        }
        Set<String> universes = commandInvocation.getPmSession().getUniverse().getUniverseNames();
        if (!universes.isEmpty()) {
            commandInvocation.println(Config.getLineSeparator() + "Universes local to this provisioning state");
        }
        for (String u : universes) {
            UniverseSpec universe = null;
            try {
                universe = commandInvocation.getPmSession().getUniverse().getUniverseSpec(u);
                if (universe.getFactory().equals("galleon1")) continue;
                this.printUniverse(universe, commandInvocation);
            }
            catch (ProvisioningException ex) {
                commandInvocation.println("Exception " + ex.getLocalizedMessage() + " retrieving universe " + u);
            }
        }
        return CommandResult.SUCCESS;
    }

    private void printUniverse(UniverseSpec spec, PmCommandInvocation invoc) throws ProvisioningException {
        UniverseResolver resolver = invoc.getPmSession().getUniverse().getUniverseResolver();
        Universe<?> universe = resolver.getUniverse(spec);
        invoc.println(spec.toString() + (spec.getLocation().equals(universe.getLocation()) ? "" : ", actual location " + universe.getLocation()));
        Collection<?> producers = universe.getProducers();
        if (producers.isEmpty()) {
            invoc.println(" No product available");
        } else if (universe instanceof MavenUniverse) {
            this.printMavenUniverse(spec, (MavenUniverse)universe, invoc);
        } else {
            this.printGenericUniverse(spec, universe, invoc);
        }
    }

    private void printMavenUniverse(UniverseSpec spec, MavenUniverse universe, PmCommandInvocation invoc) throws MavenUniverseException {
        for (MavenProducer producer : universe.getProducers()) {
            invoc.println(" Product: " + producer.getName() + ", artifact " + producer.getFeaturePackGroupId() + ":" + producer.getFeaturePackArtifactId());
            invoc.println("   Releases ");
            for (MavenChannel channel : producer.getChannels()) {
                for (String freq : channel.getFrequencies()) {
                    invoc.println("    " + producer.getName() + ":" + channel.getName() + "/" + freq + ", version range " + channel.getVersionRange());
                }
            }
        }
    }

    private void printGenericUniverse(UniverseSpec spec, Universe<?> universe, PmCommandInvocation invoc) throws ProvisioningException {
        for (Producer producer : universe.getProducers()) {
            invoc.println("  Product: " + producer.getName());
            invoc.println("    Releases ");
            for (Channel channel : producer.getChannels()) {
                invoc.println("    " + producer.getName() + ":" + channel.getName());
            }
        }
    }
}

