/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli.cmd.universe;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.aesh.command.Command;
import org.aesh.command.CommandDefinition;
import org.aesh.command.CommandException;
import org.aesh.command.CommandResult;
import org.aesh.command.option.Argument;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.cli.PmCommandInvocation;
import org.jboss.galleon.cli.UniverseManager;
import org.jboss.galleon.universe.Channel;
import org.jboss.galleon.universe.Producer;
import org.jboss.galleon.universe.Universe;
import org.jboss.galleon.universe.UniverseSpec;

@CommandDefinition(name="search", description="Search the universe for products. e.g.: wildfly*")
public class UniverseSearchCommand
implements Command<PmCommandInvocation> {
    private static final String DEFAULT = "";
    @Argument(required=true)
    private String pattern;

    @Override
    public CommandResult execute(PmCommandInvocation commandInvocation) throws CommandException, InterruptedException {
        ArrayList<UniverseSpec> specs = new ArrayList<UniverseSpec>();
        UniverseManager mgr = commandInvocation.getPmSession().getUniverse();
        specs.add(mgr.getDefaultUniverseSpec());
        for (String name : mgr.getUniverseNames()) {
            specs.add(mgr.getUniverseSpec(name));
        }
        this.pattern = this.pattern.replaceAll("\\*", ".*");
        Pattern cPattern = Pattern.compile(this.pattern);
        HashMap producers = new HashMap();
        for (UniverseSpec universeSpec : specs) {
            try {
                if (universeSpec.getFactory().equals("galleon1")) continue;
                ArrayList<String> products = new ArrayList<String>();
                Universe<?> u = mgr.getUniverseResolver().getUniverse(universeSpec);
                for (Producer p : u.getProducers()) {
                    if (!p.getName().contains(this.pattern) && !cPattern.matcher(p.getName()).matches()) continue;
                    StringBuilder builder = new StringBuilder();
                    builder.append(p.getName()).append(":");
                    if (p.getChannels().size() > 1) {
                        builder.append("[");
                    }
                    Iterator it = p.getChannels().iterator();
                    while (it.hasNext()) {
                        Channel c = (Channel)it.next();
                        builder.append(c.getName());
                        if (!it.hasNext()) continue;
                        builder.append(", ");
                    }
                    if (p.getChannels().size() > 1) {
                        builder.append("]");
                    }
                    if (!p.getFrequencies().isEmpty()) {
                        builder.append("/");
                    }
                    if (p.getFrequencies().size() > 1) {
                        builder.append("[");
                    }
                    Iterator<String> it2 = p.getFrequencies().iterator();
                    while (it2.hasNext()) {
                        builder.append(it2.next());
                        if (!it2.hasNext()) continue;
                        builder.append(", ");
                    }
                    if (p.getFrequencies().size() > 1) {
                        builder.append("]");
                    }
                    products.add(builder.toString());
                }
                if (products.isEmpty()) continue;
                String name = universeSpec.equals(mgr.getDefaultUniverseSpec()) ? (!producers.containsKey(DEFAULT) ? DEFAULT : mgr.getUniverseName(universeSpec)) : mgr.getUniverseName(universeSpec);
                producers.put(name, products);
            }
            catch (ProvisioningException products) {}
        }
        if (producers.isEmpty()) {
            commandInvocation.println("No product found for pattern " + this.pattern);
        } else {
            for (Map.Entry entry : producers.entrySet()) {
                String name = (String)entry.getKey();
                if (name.equals(DEFAULT)) {
                    commandInvocation.println("Products found in default universe");
                } else {
                    commandInvocation.println("Products found in " + name + " universe");
                }
                for (String p : (List)entry.getValue()) {
                    commandInvocation.println(" " + p);
                }
            }
        }
        return CommandResult.SUCCESS;
    }
}

