/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.galleon.cli.model.ConfigInfo;
import org.jboss.galleon.cli.model.FeatureInfo;
import org.jboss.galleon.cli.model.FeatureSpecInfo;
import org.jboss.galleon.cli.model.Group;
import org.jboss.galleon.cli.model.Identity;
import org.jboss.galleon.runtime.ResolvedSpecId;
import org.jboss.galleon.universe.FeaturePackLocation;

public abstract class FeatureContainer {
    public static final String ROOT = "###ROOT";
    private final Map<String, List<ConfigInfo>> finalConfigs = new HashMap<String, List<ConfigInfo>>();
    private final Map<String, Group> packagesRoots = new HashMap<String, Group>();
    private final Map<String, Group> featuresSpecRoots = new HashMap<String, Group>();
    private final Set<FeaturePackLocation.FPID> dependencies = new HashSet<FeaturePackLocation.FPID>();
    private Map<String, FeatureContainer> fullDependencies = new HashMap<String, FeatureContainer>();
    private final String name;
    private final FeaturePackLocation.FPID fpid;
    private boolean edit;
    private Map<ResolvedSpecId, FeatureSpecInfo> allSpecs;
    private Map<Identity, Group> allPackages;
    private Map<ResolvedSpecId, List<FeatureInfo>> allFeatures;

    protected FeatureContainer(String name, FeaturePackLocation.FPID fpid) {
        this.name = name;
        this.fpid = fpid;
    }

    void addDependency(FeaturePackLocation.FPID fpid) {
        this.dependencies.add(fpid);
    }

    public Set<FeaturePackLocation.FPID> getDependencies() {
        return Collections.unmodifiableSet(this.dependencies);
    }

    public FeaturePackLocation.FPID getFPID() {
        return this.fpid;
    }

    public String getName() {
        return this.name;
    }

    public void setFullDependencies(Map<String, FeatureContainer> fullDependencies) {
        this.fullDependencies = Collections.unmodifiableMap(fullDependencies);
    }

    public void setEdit(boolean edit) {
        this.edit = edit;
    }

    public boolean isEdit() {
        return this.edit;
    }

    public Map<String, FeatureContainer> getFullDependencies() {
        return this.fullDependencies;
    }

    protected void addFinalConfig(ConfigInfo info) {
        List<ConfigInfo> lst = this.finalConfigs.get(info.getModel());
        if (lst == null) {
            lst = new ArrayList<ConfigInfo>();
            this.finalConfigs.put(info.getModel(), lst);
        }
        lst.add(info);
    }

    public Map<String, List<ConfigInfo>> getFinalConfigs() {
        return Collections.unmodifiableMap(this.finalConfigs);
    }

    protected void setFeatureSpecRoot(String origin, Group featuresSpecRoot) {
        this.featuresSpecRoots.put(origin, featuresSpecRoot);
    }

    protected void setPackagesRoot(String origin, Group packagesRoot) {
        this.packagesRoots.put(origin, packagesRoot);
    }

    public Map<String, Group> getFeatureSpecs() {
        return this.featuresSpecRoots;
    }

    public Map<String, Group> getPackages() {
        return this.packagesRoots;
    }

    public Map<ResolvedSpecId, FeatureSpecInfo> getAllSpecs() {
        return Collections.unmodifiableMap(this.allSpecs);
    }

    void seAllFeatureSpecs(Map<ResolvedSpecId, FeatureSpecInfo> allSpecs) {
        this.allSpecs = allSpecs;
    }

    public Map<Identity, Group> getAllPackages() {
        return Collections.unmodifiableMap(this.allPackages);
    }

    void setAllPackages(Map<Identity, Group> allPackages) {
        this.allPackages = allPackages;
    }

    public Map<ResolvedSpecId, List<FeatureInfo>> getAllFeatures() {
        return Collections.unmodifiableMap(this.allFeatures);
    }

    void setAllFeatures(Map<ResolvedSpecId, List<FeatureInfo>> allFeatures) {
        this.allFeatures = allFeatures;
    }
}

