/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.config;

import java.util.Collections;
import java.util.Map;
import org.jboss.galleon.Errors;
import org.jboss.galleon.ProvisioningDescriptionException;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.config.ConfigCustomizationsBuilder;
import org.jboss.galleon.config.FeaturePackConfig;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.jboss.galleon.universe.UniverseSpec;
import org.jboss.galleon.util.CollectionUtils;

public abstract class FeaturePackDepsConfigBuilder<B extends FeaturePackDepsConfigBuilder<B>>
extends ConfigCustomizationsBuilder<B> {
    protected UniverseSpec defaultUniverse;
    Map<String, UniverseSpec> universeSpecs = Collections.emptyMap();
    Map<FeaturePackLocation.ProducerSpec, FeaturePackConfig> fpDeps = Collections.emptyMap();
    Map<String, FeaturePackConfig> fpDepsByOrigin = Collections.emptyMap();
    Map<FeaturePackLocation.ProducerSpec, String> producerOrigins = Collections.emptyMap();
    Map<FeaturePackLocation.ProducerSpec, FeaturePackConfig> transitiveDeps = Collections.emptyMap();

    protected UniverseSpec getConfiguredUniverse(FeaturePackLocation source) {
        return source.hasUniverse() ? this.universeSpecs.get(source.getUniverse().toString()) : this.defaultUniverse;
    }

    public FeaturePackLocation resolveUniverseSpec(FeaturePackLocation fpl) {
        UniverseSpec resolved = this.getConfiguredUniverse(fpl);
        return resolved == null ? fpl : fpl.replaceUniverse(resolved);
    }

    public B addFeaturePackDep(FeaturePackLocation fpl) throws ProvisioningDescriptionException {
        return this.addFeaturePackDepResolved(null, FeaturePackConfig.forLocation(this.resolveUniverseSpec(fpl)), false);
    }

    public B updateFeaturePackDep(FeaturePackLocation fpl) throws ProvisioningDescriptionException {
        return this.addFeaturePackDepResolved(null, FeaturePackConfig.forLocation(this.resolveUniverseSpec(fpl)), true);
    }

    public B addTransitiveDep(FeaturePackLocation fpl) throws ProvisioningDescriptionException {
        return this.addTransitiveDepResolved(null, FeaturePackConfig.forTransitiveDep(this.resolveUniverseSpec(fpl)));
    }

    public B addFeaturePackDep(FeaturePackConfig dependency) throws ProvisioningDescriptionException {
        if (dependency.isTransitive()) {
            return this.addTransitiveDepResolved(null, dependency);
        }
        return this.addFeaturePackDep(null, dependency);
    }

    public B updateFeaturePackDep(FeaturePackConfig dependency) throws ProvisioningDescriptionException {
        if (dependency.isTransitive()) {
            throw new ProvisioningDescriptionException("Transitive dependency can not be updated");
        }
        return this.updateFeaturePackDep(null, dependency);
    }

    public B addFeaturePackDep(String origin, FeaturePackConfig dependency) throws ProvisioningDescriptionException {
        UniverseSpec configuredUniverse = this.getConfiguredUniverse(dependency.getLocation());
        if (dependency.isTransitive()) {
            return this.addTransitiveDepResolved(origin, configuredUniverse == null ? dependency : FeaturePackConfig.builder(dependency.getLocation().replaceUniverse(configuredUniverse)).init(dependency).build());
        }
        return this.addFeaturePackDepResolved(origin, configuredUniverse == null ? dependency : FeaturePackConfig.builder(dependency.getLocation().replaceUniverse(configuredUniverse)).init(dependency).build(), false);
    }

    public B updateFeaturePackDep(String origin, FeaturePackConfig dependency) throws ProvisioningDescriptionException {
        UniverseSpec configuredUniverse = this.getConfiguredUniverse(dependency.getLocation());
        return this.addFeaturePackDepResolved(origin, configuredUniverse == null ? dependency : FeaturePackConfig.builder(dependency.getLocation().replaceUniverse(configuredUniverse)).init(dependency).build(), true);
    }

    private B addFeaturePackDepResolved(String origin, FeaturePackConfig dependency, boolean replaceExistingVersion) throws ProvisioningDescriptionException {
        String existingOrigin = null;
        FeaturePackLocation.ProducerSpec producer = dependency.getLocation().getProducer();
        if (this.transitiveDeps.containsKey(producer)) {
            throw new ProvisioningDescriptionException(producer + " has been already added as a transitive dependency");
        }
        if (this.fpDeps.containsKey(producer)) {
            if (!replaceExistingVersion) {
                throw new ProvisioningDescriptionException(Errors.featurePackAlreadyConfigured(producer));
            }
            existingOrigin = this.producerOrigins.get(producer);
        }
        if (origin != null) {
            if (existingOrigin != null) {
                if (!existingOrigin.equals(origin)) {
                    this.fpDepsByOrigin = CollectionUtils.remove(this.fpDepsByOrigin, existingOrigin);
                    this.producerOrigins = CollectionUtils.put(this.producerOrigins, producer, origin);
                }
            } else {
                if (this.fpDepsByOrigin.containsKey(origin)) {
                    throw new ProvisioningDescriptionException(Errors.duplicateDependencyName(origin));
                }
                this.producerOrigins = CollectionUtils.put(this.producerOrigins, producer, origin);
            }
            this.fpDepsByOrigin = CollectionUtils.put(this.fpDepsByOrigin, origin, dependency);
        }
        this.fpDeps = CollectionUtils.putLinked(this.fpDeps, producer, dependency);
        return (B)this;
    }

    private B addTransitiveDepResolved(String origin, FeaturePackConfig dependency) throws ProvisioningDescriptionException {
        FeaturePackLocation.ProducerSpec producer = dependency.getLocation().getProducer();
        if (this.transitiveDeps.containsKey(producer) || this.fpDeps.containsKey(producer)) {
            throw new ProvisioningDescriptionException(Errors.featurePackAlreadyConfigured(producer));
        }
        if (origin != null) {
            String existingOrigin = this.producerOrigins.get(producer);
            if (existingOrigin != null) {
                if (!existingOrigin.equals(origin)) {
                    this.fpDepsByOrigin = CollectionUtils.remove(this.fpDepsByOrigin, existingOrigin);
                    this.producerOrigins = CollectionUtils.put(this.producerOrigins, producer, origin);
                }
            } else {
                if (this.fpDepsByOrigin.containsKey(origin)) {
                    throw new ProvisioningDescriptionException(Errors.duplicateDependencyName(origin));
                }
                this.producerOrigins = CollectionUtils.put(this.producerOrigins, producer, origin);
            }
            this.fpDepsByOrigin = CollectionUtils.put(this.fpDepsByOrigin, origin, dependency);
        }
        this.transitiveDeps = CollectionUtils.putLinked(this.transitiveDeps, producer, dependency);
        return (B)this;
    }

    public boolean hasFeaturePackDep(FeaturePackLocation.ProducerSpec producer) {
        return this.fpDeps.containsKey(producer);
    }

    public B removeFeaturePackDep(FeaturePackLocation fpl) throws ProvisioningException {
        String origin;
        FeaturePackLocation.ProducerSpec producer = (fpl = this.resolveUniverseSpec(fpl)).getProducer();
        FeaturePackConfig fpDep = this.fpDeps.get(producer);
        if (fpDep == null) {
            throw new ProvisioningException(Errors.unknownFeaturePack(fpl.getFPID()));
        }
        if (!fpDep.getLocation().equals(fpl)) {
            throw new ProvisioningException(Errors.unknownFeaturePack(fpl.getFPID()));
        }
        if (this.fpDeps.size() == 1) {
            this.fpDeps = Collections.emptyMap();
            this.fpDepsByOrigin = Collections.emptyMap();
            this.producerOrigins = Collections.emptyMap();
            return (B)this;
        }
        this.fpDeps = CollectionUtils.remove(this.fpDeps, producer);
        if (!this.producerOrigins.isEmpty() && (origin = this.producerOrigins.get(producer)) != null) {
            if (this.fpDepsByOrigin.size() == 1) {
                this.fpDepsByOrigin = Collections.emptyMap();
                this.producerOrigins = Collections.emptyMap();
            } else {
                this.fpDepsByOrigin.remove(origin);
                this.producerOrigins.remove(producer);
            }
        }
        return (B)this;
    }

    public int getFeaturePackDepIndex(FeaturePackLocation fpl) throws ProvisioningException {
        FeaturePackLocation.ProducerSpec producer = (fpl = this.resolveUniverseSpec(fpl)).getProducer();
        FeaturePackConfig fpDep = this.fpDeps.get(producer);
        if (fpDep == null) {
            throw new ProvisioningException(Errors.unknownFeaturePack(fpl.getFPID()));
        }
        if (!fpDep.getLocation().equals(fpl)) {
            throw new ProvisioningException(Errors.unknownFeaturePack(fpl.getFPID()));
        }
        int i = 0;
        for (FeaturePackLocation.ProducerSpec depProducer : this.fpDeps.keySet()) {
            if (depProducer.equals(producer)) break;
            ++i;
        }
        return i;
    }

    public B addFeaturePackDep(int index, FeaturePackConfig dependency) throws ProvisioningDescriptionException {
        if (index >= this.fpDeps.size()) {
            this.addFeaturePackDep(dependency);
            return (B)this;
        }
        FeaturePackLocation fpl = dependency.getLocation();
        UniverseSpec resolvedUniverse = this.getConfiguredUniverse(fpl);
        if (resolvedUniverse != null) {
            fpl = fpl.replaceUniverse(resolvedUniverse);
            dependency = FeaturePackConfig.builder(fpl).init(dependency).build();
        }
        if (this.fpDeps.containsKey(fpl.getProducer())) {
            throw new ProvisioningDescriptionException(Errors.featurePackAlreadyConfigured(fpl.getProducer()));
        }
        Map<Object, Object> tmp = Collections.emptyMap();
        int i = 0;
        for (Map.Entry<FeaturePackLocation.ProducerSpec, FeaturePackConfig> entry : this.fpDeps.entrySet()) {
            if (i == index) {
                tmp = CollectionUtils.putLinked(tmp, fpl.getProducer(), dependency);
            }
            tmp = CollectionUtils.putLinked(tmp, entry.getKey(), entry.getValue());
            ++i;
        }
        this.fpDeps = tmp;
        return (B)this;
    }

    public String originOf(FeaturePackLocation.ProducerSpec producer) {
        return this.producerOrigins.get(producer);
    }

    public B setDefaultUniverse(String factory, String location) throws ProvisioningDescriptionException {
        return this.setDefaultUniverse(new UniverseSpec(factory, location));
    }

    public B setDefaultUniverse(UniverseSpec universeSpec) throws ProvisioningDescriptionException {
        return this.addUniverse(null, universeSpec);
    }

    public B addUniverse(String name, String factory, String location) throws ProvisioningDescriptionException {
        return this.addUniverse(name, new UniverseSpec(factory, location));
    }

    public B addUniverse(String name, UniverseSpec universe) throws ProvisioningDescriptionException {
        if (name == null) {
            this.defaultUniverse = universe;
            return (B)this;
        }
        this.universeSpecs = CollectionUtils.put(this.universeSpecs, name, universe);
        return (B)this;
    }

    public B removeUniverse(String name) throws ProvisioningDescriptionException {
        if (name == null) {
            this.defaultUniverse = null;
            return (B)this;
        }
        this.universeSpecs = CollectionUtils.remove(this.universeSpecs, name);
        return (B)this;
    }

    public boolean hasUniverse(String name) {
        if (name == null) {
            return this.hasDefaultUniverse();
        }
        return this.universeSpecs.containsKey(name);
    }

    public UniverseSpec getUniverseSpec(String name) {
        return this.universeSpecs.get(name);
    }

    public boolean hasDefaultUniverse() {
        return this.defaultUniverse != null;
    }

    public UniverseSpec getDefaultUniverse() {
        return this.defaultUniverse;
    }
}

