/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.config;

import java.util.Map;
import org.jboss.galleon.ProvisioningDescriptionException;
import org.jboss.galleon.config.FeaturePackConfig;
import org.jboss.galleon.config.FeaturePackDepsConfig;
import org.jboss.galleon.config.FeaturePackDepsConfigBuilder;
import org.jboss.galleon.universe.UniverseSpec;
import org.jboss.galleon.util.StringUtils;

public class ProvisioningConfig
extends FeaturePackDepsConfig {
    private final Builder builder;

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ProvisioningConfig provisioningConfig) throws ProvisioningDescriptionException {
        return new Builder(provisioningConfig);
    }

    private ProvisioningConfig(Builder builder) throws ProvisioningDescriptionException {
        super(builder);
        this.builder = builder;
    }

    public Builder getBuilder() {
        return this.builder;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder().append('[');
        if (this.defaultUniverse != null) {
            buf.append("default-universe=").append(this.defaultUniverse);
        }
        if (!this.universeSpecs.isEmpty()) {
            if (this.defaultUniverse != null) {
                buf.append(' ');
            }
            buf.append("universes=[");
            StringUtils.append(buf, this.universeSpecs.entrySet());
            buf.append("] ");
        }
        if (!this.transitiveDeps.isEmpty()) {
            buf.append("transitive=");
            StringUtils.append(buf, this.transitiveDeps.values());
            buf.append(' ');
        }
        StringUtils.append(buf, this.fpDeps.values());
        this.append(buf);
        return buf.append(']').toString();
    }

    public static class Builder
    extends FeaturePackDepsConfigBuilder<Builder> {
        private Builder() {
        }

        private Builder(ProvisioningConfig provisioningConfig) throws ProvisioningDescriptionException {
            if (provisioningConfig != null) {
                for (FeaturePackConfig featurePackConfig : provisioningConfig.getFeaturePackDeps()) {
                    this.addFeaturePackDep(provisioningConfig.originOf(featurePackConfig.getLocation().getProducer()), featurePackConfig);
                }
                if (provisioningConfig.defaultUniverse != null) {
                    this.setDefaultUniverse(provisioningConfig.defaultUniverse);
                }
                for (Map.Entry entry : provisioningConfig.universeSpecs.entrySet()) {
                    this.addUniverse((String)entry.getKey(), (UniverseSpec)entry.getValue());
                }
                this.initConfigs(provisioningConfig);
            }
        }

        public ProvisioningConfig build() throws ProvisioningDescriptionException {
            return new ProvisioningConfig(this);
        }
    }
}

