/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.creator;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.creator.FeaturePackBuilder;
import org.jboss.galleon.creator.UniverseFeaturePackCreator;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.jboss.galleon.universe.Universe;
import org.jboss.galleon.universe.UniverseResolver;
import org.jboss.galleon.universe.UniverseResolverBuilder;
import org.jboss.galleon.util.CollectionUtils;
import org.jboss.galleon.util.IoUtils;
import org.jboss.galleon.util.StringUtils;

public class FeaturePackCreator
extends UniverseResolverBuilder<FeaturePackCreator> {
    private Map<String, UniverseFeaturePackCreator> ufpCreators;
    private List<FeaturePackBuilder> fps = Collections.emptyList();
    private Path workDir;
    private UniverseResolver universeResolver;

    public static FeaturePackCreator getInstance() {
        return new FeaturePackCreator();
    }

    private static Map<String, UniverseFeaturePackCreator> loadUniverseFpCreators() throws ProvisioningException {
        ServiceLoader<UniverseFeaturePackCreator> loader = ServiceLoader.load(UniverseFeaturePackCreator.class);
        Map<Object, Object> universeCreators = Collections.emptyMap();
        for (UniverseFeaturePackCreator uCreator : loader) {
            if (universeCreators.isEmpty()) {
                universeCreators = Collections.singletonMap(uCreator.getUniverseFactoryId(), uCreator);
                continue;
            }
            if (universeCreators.containsKey(uCreator.getUniverseFactoryId())) {
                throw new IllegalStateException("Only one universe feature-pack creator is allowed per repository type " + uCreator.getUniverseFactoryId() + " but found " + uCreator + " and " + universeCreators.get(uCreator.getUniverseFactoryId()));
            }
            if (universeCreators.size() == 1) {
                HashMap<Object, Object> tmp = new HashMap<Object, Object>(2);
                tmp.putAll(universeCreators);
                universeCreators = tmp;
            }
            universeCreators.put(uCreator.getUniverseFactoryId(), uCreator);
        }
        return CollectionUtils.unmodifiable(universeCreators);
    }

    public FeaturePackBuilder newFeaturePack() {
        FeaturePackBuilder fp = new FeaturePackBuilder(this);
        this.addFeaturePack(fp);
        return fp;
    }

    public FeaturePackBuilder newFeaturePack(FeaturePackLocation.FPID fpid) {
        FeaturePackBuilder fp = new FeaturePackBuilder(this);
        if (fpid != null) {
            fp.setFPID(fpid);
        }
        this.addFeaturePack(fp);
        return fp;
    }

    public FeaturePackCreator addFeaturePack(FeaturePackBuilder fp) {
        this.fps = CollectionUtils.add(this.fps, fp);
        return this;
    }

    public void install() throws ProvisioningException {
        this.ufpCreators = FeaturePackCreator.loadUniverseFpCreators();
        this.universeResolver = this.buildUniverseResolver();
        try {
            for (FeaturePackBuilder fp : this.fps) {
                fp.build();
            }
        }
        finally {
            if (this.workDir != null) {
                IoUtils.recursiveDelete(this.workDir);
            }
        }
    }

    void install(FeaturePackLocation.FPID fpid, Path fpContentDir) throws ProvisioningException {
        Universe<?> universe = this.universeResolver.getUniverse(fpid.getLocation().getUniverse());
        UniverseFeaturePackCreator ufpCreator = this.ufpCreators.get(universe.getFactoryId());
        if (ufpCreator == null) {
            StringBuilder buf = new StringBuilder();
            buf.append("Failed to locate an implementation of ").append(UniverseFeaturePackCreator.class.getName()).append(" for universe repository ").append(universe.getFactoryId()).append(" on the classpath. Available universe repositories include ");
            StringUtils.append(buf, this.ufpCreators.keySet());
            throw new ProvisioningException(buf.toString());
        }
        ufpCreator.install(universe, fpid, fpContentDir);
    }

    Path getWorkDir() throws ProvisioningException {
        if (this.workDir == null) {
            try {
                this.workDir = Files.createTempDirectory("gln-fp-installer", new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new ProvisioningException("Failed to create a tmp dir");
            }
        }
        return this.workDir;
    }
}

