/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.layout;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Iterator;
import javax.xml.stream.XMLStreamException;
import org.jboss.galleon.Errors;
import org.jboss.galleon.ProvisioningDescriptionException;
import org.jboss.galleon.layout.FeaturePackLayout;
import org.jboss.galleon.spec.FeaturePackSpec;
import org.jboss.galleon.spec.PackageSpec;
import org.jboss.galleon.xml.PackageXmlParser;
import org.jboss.galleon.xml.XmlParsers;

public class FeaturePackLayoutDescriber {
    public static FeaturePackLayout describeFeaturePackZip(Path artifactZip) throws IOException, ProvisioningDescriptionException {
        try (FileSystem zipfs = FileSystems.newFileSystem(artifactZip, null);){
            Iterator<Path> iterator = zipfs.getRootDirectories().iterator();
            if (iterator.hasNext()) {
                Path zipRoot = iterator.next();
                FeaturePackLayout featurePackLayout = FeaturePackLayoutDescriber.describeFeaturePack(zipRoot, "UTF-8");
                return featurePackLayout;
            }
        }
        return null;
    }

    public static FeaturePackLayout describeFeaturePack(Path fpDir, String encoding) throws ProvisioningDescriptionException {
        FeaturePackLayout.Builder layoutBuilder;
        FeaturePackLayoutDescriber.assertDirectory(fpDir);
        Path fpXml = fpDir.resolve("feature-pack.xml");
        if (!Files.exists(fpXml, new LinkOption[0])) {
            throw new ProvisioningDescriptionException(Errors.pathDoesNotExist(fpXml));
        }
        try (BufferedReader is = Files.newBufferedReader(fpXml, Charset.forName(encoding));){
            FeaturePackSpec.Builder specBuilder = FeaturePackSpec.builder();
            XmlParsers.parse(is, specBuilder);
            layoutBuilder = FeaturePackLayout.builder(specBuilder);
        }
        catch (IOException e) {
            throw new ProvisioningDescriptionException(Errors.openFile(fpXml));
        }
        catch (XMLStreamException e) {
            throw new ProvisioningDescriptionException(Errors.parseXml(fpXml), e);
        }
        Path packagesDir = fpDir.resolve("packages");
        if (Files.exists(packagesDir, new LinkOption[0])) {
            FeaturePackLayoutDescriber.processPackages(layoutBuilder, packagesDir, encoding);
        }
        return layoutBuilder.build();
    }

    private static void processPackages(FeaturePackLayout.Builder fpBuilder, Path packagesDir, String encoding) throws ProvisioningDescriptionException {
        FeaturePackLayoutDescriber.assertDirectory(packagesDir);
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(packagesDir);){
            for (Path path : stream) {
                fpBuilder.addPackage(FeaturePackLayoutDescriber.processPackage(path, encoding));
            }
        }
        catch (IOException e) {
            FeaturePackLayoutDescriber.failedToReadDirectory(packagesDir, e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static PackageSpec processPackage(Path pkgDir, String encoding) throws ProvisioningDescriptionException {
        FeaturePackLayoutDescriber.assertDirectory(pkgDir);
        Path pkgXml = pkgDir.resolve("package.xml");
        if (!Files.exists(pkgXml, new LinkOption[0])) {
            throw new ProvisioningDescriptionException(Errors.pathDoesNotExist(pkgXml));
        }
        try (BufferedReader in = Files.newBufferedReader(pkgXml, Charset.forName(encoding));){
            PackageSpec packageSpec = PackageXmlParser.getInstance().parse(in);
            return packageSpec;
        }
        catch (IOException e) {
            throw new ProvisioningDescriptionException(Errors.openFile(pkgXml), e);
        }
        catch (XMLStreamException e) {
            throw new ProvisioningDescriptionException(Errors.parseXml(pkgXml), e);
        }
    }

    private static void assertDirectory(Path dir) throws ProvisioningDescriptionException {
        if (!Files.isDirectory(dir, new LinkOption[0])) {
            throw new ProvisioningDescriptionException(Errors.notADir(dir));
        }
    }

    private static void failedToReadDirectory(Path p, IOException e) throws ProvisioningDescriptionException {
        throw new ProvisioningDescriptionException(Errors.readDirectory(p), e);
    }
}

