/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.runtime;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import org.jboss.galleon.ArtifactCoords;
import org.jboss.galleon.ArtifactException;
import org.jboss.galleon.Errors;
import org.jboss.galleon.MessageWriter;
import org.jboss.galleon.ProvisioningDescriptionException;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.config.ConfigId;
import org.jboss.galleon.config.ConfigModel;
import org.jboss.galleon.config.FeaturePackConfig;
import org.jboss.galleon.config.ProvisioningConfig;
import org.jboss.galleon.creator.FeaturePackBuilder;
import org.jboss.galleon.creator.FeaturePackCreator;
import org.jboss.galleon.diff.FileSystemDiffResult;
import org.jboss.galleon.layout.FeaturePackLayoutTransformer;
import org.jboss.galleon.layout.FeaturePackPluginVisitor;
import org.jboss.galleon.layout.ProvisioningLayout;
import org.jboss.galleon.layout.ProvisioningLayoutFactory;
import org.jboss.galleon.plugin.DiffPlugin;
import org.jboss.galleon.plugin.InstallPlugin;
import org.jboss.galleon.plugin.PluginOption;
import org.jboss.galleon.plugin.ProvisioningPlugin;
import org.jboss.galleon.plugin.UpgradePlugin;
import org.jboss.galleon.repo.RepositoryArtifactResolver;
import org.jboss.galleon.runtime.FeaturePackRuntime;
import org.jboss.galleon.runtime.FeaturePackRuntimeBuilder;
import org.jboss.galleon.runtime.PackageRuntime;
import org.jboss.galleon.runtime.ProvisioningRuntimeBuilder;
import org.jboss.galleon.state.FeaturePackSet;
import org.jboss.galleon.state.ProvisionedConfig;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.jboss.galleon.util.CollectionUtils;
import org.jboss.galleon.util.FeaturePackInstallException;
import org.jboss.galleon.util.IoUtils;
import org.jboss.galleon.util.PathsUtils;
import org.jboss.galleon.util.StringUtils;
import org.jboss.galleon.xml.ProvisionedStateXmlWriter;
import org.jboss.galleon.xml.ProvisioningXmlWriter;

public class ProvisioningRuntime
implements FeaturePackSet<FeaturePackRuntime>,
AutoCloseable {
    private final long startTime;
    private ProvisioningConfig config;
    private Path installDir;
    private final Path stagedDir;
    private final ProvisioningLayout<FeaturePackRuntime> layout;
    private final Map<String, String> pluginOptions;
    private final MessageWriter messageWriter;
    private List<ProvisionedConfig> configs = Collections.emptyList();
    private FileSystemDiffResult diff = FileSystemDiffResult.empty();
    private final String operation;
    private RepositoryArtifactResolver maven;

    public static void install(ProvisioningRuntime runtime) throws ProvisioningException {
        for (FeaturePackRuntime fp : runtime.layout.getOrderedFeaturePacks()) {
            runtime.messageWriter.verbose("Installing %s", fp.getFPID());
            for (PackageRuntime pkg : fp.getPackages()) {
                Path pkgSrcDir = pkg.getContentDir();
                if (!Files.exists(pkgSrcDir, new LinkOption[0])) continue;
                try {
                    IoUtils.copy(pkgSrcDir, runtime.stagedDir);
                }
                catch (IOException e) {
                    throw new FeaturePackInstallException(Errors.packageContentCopyFailed(pkg.getName()), e);
                }
            }
        }
        runtime.executePlugins();
        try {
            ProvisioningXmlWriter.getInstance().write(runtime.config, PathsUtils.getProvisioningXml(runtime.stagedDir));
        }
        catch (IOException | XMLStreamException e) {
            throw new FeaturePackInstallException(Errors.writeFile(PathsUtils.getProvisioningXml(runtime.stagedDir)), e);
        }
        try {
            ProvisionedStateXmlWriter.getInstance().write(runtime, PathsUtils.getProvisionedStateXml(runtime.stagedDir));
        }
        catch (IOException | XMLStreamException e) {
            throw new FeaturePackInstallException(Errors.writeFile(PathsUtils.getProvisionedStateXml(runtime.stagedDir)), e);
        }
        runtime.messageWriter.verbose("Moving the provisioned installation from the staged directory to %s", runtime.installDir);
        if (Files.exists(runtime.installDir, new LinkOption[0])) {
            IoUtils.recursiveDelete(runtime.installDir);
        }
        try {
            IoUtils.copy(runtime.stagedDir, runtime.installDir);
        }
        catch (IOException e) {
            throw new ProvisioningException(Errors.copyFile(runtime.stagedDir, runtime.installDir));
        }
    }

    public static void exportToFeaturePack(ProvisioningRuntime runtime, FeaturePackLocation.FPID fpid, Path location, Path installationHome) throws ProvisioningDescriptionException, ProvisioningException, IOException {
        ProvisioningRuntime.diff(runtime, location, installationHome);
        FeaturePackCreator creator = FeaturePackCreator.getInstance();
        FeaturePackBuilder fpBuilder = creator.newFeaturePack(fpid);
        HashMap<String, FeaturePackConfig.Builder> builders = new HashMap<String, FeaturePackConfig.Builder>();
        for (FeaturePackConfig featurePackConfig : runtime.getProvisioningConfig().getFeaturePackDeps()) {
            FeaturePackConfig.Builder builder = FeaturePackConfig.builder(featurePackConfig.getLocation());
            for (ConfigModel configModel : featurePackConfig.getDefinedConfigs()) {
                builder.addConfig(configModel);
            }
            builder.excludeAllPackages(featurePackConfig.getExcludedPackages());
            builder.setInheritConfigs(featurePackConfig.isInheritConfigs());
            builder.setInheritModelOnlyConfigs(featurePackConfig.isInheritModelOnlyConfigs());
            builder.setInheritPackages(featurePackConfig.isInheritPackages());
            for (Map.Entry entry : featurePackConfig.getFullModelsExcluded().entrySet()) {
                builder.excludeConfigModel((String)entry.getKey(), (Boolean)entry.getValue());
            }
            for (ConfigId configId : featurePackConfig.getIncludedConfigs()) {
                builder.includeDefaultConfig(configId);
            }
            builders.put(FeaturePackConfig.getDefaultOriginName(featurePackConfig.getLocation()), builder);
        }
        runtime.exportDiffResultToFeaturePack(fpBuilder, builders, installationHome);
        for (Map.Entry entry : builders.entrySet()) {
            fpBuilder.addDependency((String)entry.getKey(), ((FeaturePackConfig.Builder)entry.getValue()).build());
        }
        if (runtime.layout.hasPlugins()) {
            try {
                Throwable throwable = null;
                try (DirectoryStream<Path> stream = Files.newDirectoryStream(runtime.layout.getPluginsDir());){
                    for (Path file : stream) {
                        if (!Files.isRegularFile(file, new LinkOption[0])) continue;
                        fpBuilder.addPlugin(file);
                    }
                }
                catch (Throwable throwable2) {
                    Throwable throwable3 = throwable2;
                    throw throwable2;
                }
            }
            catch (IOException ioex) {
                throw new ProvisioningException(ioex);
            }
        }
        fpBuilder.getCreator().install();
    }

    public static void diff(ProvisioningRuntime runtime, Path target, Path customizedInstallation) throws ProvisioningException, IOException {
        runtime.executeDiffPlugins(target, customizedInstallation);
    }

    public static void upgrade(ProvisioningRuntime runtime, Path customizedInstallation) throws ProvisioningException {
        runtime.executeUpgradePlugins(customizedInstallation);
        if (Files.exists(customizedInstallation, new LinkOption[0])) {
            IoUtils.recursiveDelete(customizedInstallation);
        }
        try {
            IoUtils.copy(runtime.installDir, customizedInstallation);
        }
        catch (IOException e) {
            throw new ProvisioningException(Errors.copyFile(runtime.installDir, customizedInstallation));
        }
    }

    ProvisioningRuntime(ProvisioningRuntimeBuilder builder, MessageWriter messageWriter) throws ProvisioningException {
        this.startTime = builder.startTime;
        this.config = builder.config;
        this.layout = builder.layout.transform(new FeaturePackLayoutTransformer<FeaturePackRuntime, FeaturePackRuntimeBuilder>(){

            @Override
            public FeaturePackRuntime transform(FeaturePackRuntimeBuilder other) throws ProvisioningException {
                return other.build(ProvisioningRuntime.this);
            }
        });
        try {
            this.configs = builder.getResolvedConfigs();
            this.stagedDir = this.layout.newStagedDir();
        }
        catch (Error | RuntimeException | ProvisioningException e) {
            this.layout.close();
            throw e;
        }
        this.pluginOptions = CollectionUtils.unmodifiable(builder.pluginOptions);
        this.operation = builder.operation;
        this.installDir = builder.installDir;
        this.messageWriter = messageWriter;
    }

    public Path getStagedDir() {
        return this.stagedDir;
    }

    public Path getInstallDir() {
        return this.installDir;
    }

    public void setInstallDir(Path installDir) {
        this.installDir = installDir;
    }

    public ProvisioningConfig getProvisioningConfig() {
        return this.config;
    }

    @Override
    public boolean hasFeaturePacks() {
        return this.layout.hasFeaturePacks();
    }

    @Override
    public boolean hasFeaturePack(FeaturePackLocation.ProducerSpec producer) {
        return this.layout.hasFeaturePack(producer);
    }

    @Override
    public Collection<FeaturePackRuntime> getFeaturePacks() {
        return this.layout.getOrderedFeaturePacks();
    }

    @Override
    public FeaturePackRuntime getFeaturePack(FeaturePackLocation.ProducerSpec producer) throws ProvisioningException {
        return this.layout.getFeaturePack(producer);
    }

    public MessageWriter getMessageWriter() {
        return this.messageWriter;
    }

    public void setDiff(FileSystemDiffResult diff) {
        this.diff = diff;
    }

    public FileSystemDiffResult getDiff() {
        return this.diff;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportDiffResultToFeaturePack(FeaturePackBuilder fpBuilder, Map<String, FeaturePackConfig.Builder> builders, Path installationHome) throws ProvisioningException {
        ClassLoader pluginClassLoader = this.layout.getPluginsClassLoader();
        if (pluginClassLoader != null) {
            Thread thread = Thread.currentThread();
            ClassLoader ocl = thread.getContextClassLoader();
            try {
                thread.setContextClassLoader(pluginClassLoader);
                this.diff.toFeaturePack(fpBuilder, builders, this, installationHome);
            }
            finally {
                thread.setContextClassLoader(ocl);
            }
        }
    }

    public String getOperation() {
        return this.operation;
    }

    public ProvisioningLayoutFactory getLayoutFactory() {
        return this.layout.getFactory();
    }

    public Path getResource(String ... path) throws ProvisioningException {
        return this.layout.getResource(path);
    }

    public Path getTmpPath(String ... path) {
        return this.layout.getTmpPath(path);
    }

    public boolean isOptionSet(PluginOption option) throws ProvisioningException {
        if (!this.pluginOptions.containsKey(option.getName())) {
            return false;
        }
        if (option.isAcceptsValue() || this.pluginOptions.get(option.getName()) == null) {
            return true;
        }
        throw new ProvisioningException("Plugin option " + option.getName() + " does expect value but is set to " + this.pluginOptions.get(option.getName()));
    }

    public String getOptionValue(PluginOption option) throws ProvisioningException {
        return this.getOptionValue(option, null);
    }

    public String getOptionValue(PluginOption option, String defaultValue) throws ProvisioningException {
        String value = this.pluginOptions.get(option.getName());
        if (value == null) {
            if (defaultValue != null) {
                return defaultValue;
            }
            defaultValue = option.getDefaultValue();
            if (defaultValue != null) {
                return defaultValue;
            }
            if (option.isRequired()) {
                throw new ProvisioningException("Required plugin option " + option.getName() + " has not been provided");
            }
            return null;
        }
        if (!option.isAcceptsValue()) {
            throw new ProvisioningException("Plugin option " + option.getName() + " is set to " + value + " but does not accept values");
        }
        if (!option.getValueSet().isEmpty() && !option.getValueSet().contains(value)) {
            StringBuilder buf = new StringBuilder();
            buf.append("Plugin option ").append(option.getName()).append(" is set to ").append(value).append(" but expects one of ");
            StringUtils.append(buf, option.getValueSet());
            throw new ProvisioningException(buf.toString());
        }
        return value;
    }

    public Map<String, String> getPluginOptions() {
        return this.pluginOptions;
    }

    public Path resolveArtifact(ArtifactCoords coords) throws ArtifactException {
        try {
            return this.getMaven().resolve(coords.toString());
        }
        catch (ProvisioningException e) {
            throw new ArtifactException("Failed to resolve " + coords, e);
        }
    }

    @Override
    public boolean hasConfigs() {
        return !this.configs.isEmpty();
    }

    @Override
    public List<ProvisionedConfig> getConfigs() {
        return this.configs;
    }

    private void executePlugins() throws ProvisioningException {
        FeaturePackPluginVisitor<InstallPlugin> visitor = new FeaturePackPluginVisitor<InstallPlugin>(){

            @Override
            public void visitPlugin(InstallPlugin plugin) throws ProvisioningException {
                plugin.postInstall(ProvisioningRuntime.this);
            }
        };
        this.visitCheckOptionsPlugins(visitor, InstallPlugin.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends ProvisioningPlugin> void visitCheckOptionsPlugins(FeaturePackPluginVisitor<T> visitor, Class<T> clazz) throws ProvisioningException {
        final ArrayList plugins = new ArrayList();
        final HashSet options = new HashSet();
        Thread thread = Thread.currentThread();
        ClassLoader ocl = thread.getContextClassLoader();
        final ArrayList pluginLoaderHolder = new ArrayList(1);
        FeaturePackPluginVisitor v = new FeaturePackPluginVisitor<T>(){

            @Override
            public void visitPlugin(T plugin) throws ProvisioningException {
                for (PluginOption opt : plugin.getOptions().values()) {
                    if (!opt.isRequired() || ProvisioningRuntime.this.pluginOptions.keySet().contains(opt.getName())) continue;
                    throw new ProvisioningException("Option: " + opt.getName() + " is required for this plugin.");
                }
                if (pluginLoaderHolder.isEmpty()) {
                    pluginLoaderHolder.add(Thread.currentThread().getContextClassLoader());
                }
                options.addAll(plugin.getOptions().keySet());
                plugins.add(plugin);
            }
        };
        this.visitPlugins(v, clazz);
        for (String userOption : this.pluginOptions.keySet()) {
            if (options.contains(userOption)) continue;
            throw new ProvisioningException("Option " + userOption + " is not supported");
        }
        if (!plugins.isEmpty()) {
            ClassLoader pluginsLoader = (ClassLoader)pluginLoaderHolder.get(0);
            try {
                thread.setContextClassLoader(pluginsLoader);
                for (ProvisioningPlugin p : plugins) {
                    visitor.visitPlugin(p);
                }
            }
            finally {
                thread.setContextClassLoader(ocl);
            }
        }
    }

    public <T extends ProvisioningPlugin> void visitPlugins(FeaturePackPluginVisitor<T> visitor, Class<T> clazz) throws ProvisioningException {
        this.layout.visitPlugins(visitor, clazz);
    }

    @Override
    public void close() {
        this.layout.close();
        if (this.messageWriter.isVerboseEnabled()) {
            long time = System.currentTimeMillis() - this.startTime;
            long seconds = time / 1000L;
            this.messageWriter.verbose("Done in %d.%d seconds", seconds, time - seconds * 1000L);
        }
    }

    private void executeDiffPlugins(final Path target, final Path customizedInstallation) throws ProvisioningException, IOException {
        FeaturePackPluginVisitor<DiffPlugin> visitor = new FeaturePackPluginVisitor<DiffPlugin>(){

            @Override
            public void visitPlugin(DiffPlugin plugin) throws ProvisioningException {
                plugin.computeDiff(ProvisioningRuntime.this, customizedInstallation, target);
            }
        };
        this.visitCheckOptionsPlugins(visitor, DiffPlugin.class);
    }

    private void executeUpgradePlugins(final Path customizedInstallation) throws ProvisioningException {
        FeaturePackPluginVisitor<UpgradePlugin> visitor = new FeaturePackPluginVisitor<UpgradePlugin>(){

            @Override
            public void visitPlugin(UpgradePlugin plugin) throws ProvisioningException {
                plugin.upgrade(ProvisioningRuntime.this, customizedInstallation);
            }
        };
        this.visitCheckOptionsPlugins(visitor, UpgradePlugin.class);
    }

    private RepositoryArtifactResolver getMaven() throws ProvisioningException {
        return this.maven == null ? (this.maven = this.layout.getFactory().getUniverseResolver().getArtifactResolver("repository.maven")) : this.maven;
    }
}

