/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.spec;

import java.util.Collections;
import java.util.Set;
import org.jboss.galleon.ArtifactCoords;
import org.jboss.galleon.ProvisioningDescriptionException;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.config.FeaturePackDepsConfig;
import org.jboss.galleon.config.FeaturePackDepsConfigBuilder;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.jboss.galleon.universe.UniverseSpec;
import org.jboss.galleon.universe.galleon1.LegacyGalleon1Universe;
import org.jboss.galleon.util.CollectionUtils;
import org.jboss.galleon.util.StringUtils;

public class FeaturePackSpec
extends FeaturePackDepsConfig {
    private final FeaturePackLocation.FPID fpid;
    private final Set<String> defPackages;
    private ArtifactCoords.Gav legacyGav;

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ArtifactCoords.Gav gav) {
        return new Builder().setFPID(LegacyGalleon1Universe.toFpl(gav).getFPID());
    }

    public static Builder builder(FeaturePackLocation.FPID fpid) {
        return new Builder().setFPID(fpid);
    }

    protected FeaturePackSpec(Builder builder) throws ProvisioningDescriptionException {
        super(builder);
        this.fpid = builder.fpid;
        this.defPackages = CollectionUtils.unmodifiable(builder.defPackages);
    }

    public ArtifactCoords.Gav getGav() {
        if (this.legacyGav == null) {
            try {
                this.legacyGav = LegacyGalleon1Universe.toArtifactCoords(this.fpid.getLocation()).toGav();
            }
            catch (ProvisioningException e) {
                throw new IllegalStateException("Failed to translate fpl to gav", e);
            }
        }
        return this.legacyGav;
    }

    public FeaturePackLocation.FPID getFPID() {
        return this.fpid;
    }

    public boolean hasDefaultPackages() {
        return !this.defPackages.isEmpty();
    }

    public Set<String> getDefaultPackageNames() {
        return this.defPackages;
    }

    public boolean isDefaultPackage(String name) {
        return this.defPackages.contains(name);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.defPackages == null ? 0 : this.defPackages.hashCode());
        result = 31 * result + (this.fpid == null ? 0 : this.fpid.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FeaturePackSpec other = (FeaturePackSpec)obj;
        if (this.defPackages == null ? other.defPackages != null : !this.defPackages.equals(other.defPackages)) {
            return false;
        }
        return !(this.fpid == null ? other.fpid != null : !this.fpid.equals(other.fpid));
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append('[').append(this.fpid);
        if (!this.fpDeps.isEmpty()) {
            buf.append("; dependencies: ");
            StringUtils.append(buf, this.fpDeps.keySet());
        }
        if (!this.definedConfigs.isEmpty()) {
            buf.append("; defaultConfigs: ");
            StringUtils.append(buf, this.definedConfigs);
        }
        if (!this.defPackages.isEmpty()) {
            buf.append("; defaultPackages: ");
            StringUtils.append(buf, this.defPackages);
        }
        return buf.append("]").toString();
    }

    public static class Builder
    extends FeaturePackDepsConfigBuilder<Builder> {
        private FeaturePackLocation.FPID fpid;
        private Set<String> defPackages = Collections.emptySet();

        protected Builder() {
        }

        public Builder setFPID(FeaturePackLocation.FPID fpid) {
            this.fpid = fpid;
            return this;
        }

        public FeaturePackLocation.FPID getFPID() {
            return this.fpid;
        }

        @Override
        public boolean hasDefaultUniverse() {
            return true;
        }

        @Override
        public UniverseSpec getDefaultUniverse() {
            return this.defaultUniverse == null ? this.fpid.getLocation().getUniverse() : this.defaultUniverse;
        }

        public Builder addDefaultPackage(String packageName) {
            assert (packageName != null) : "packageName is null";
            this.defPackages = CollectionUtils.addLinked(this.defPackages, packageName);
            return this;
        }

        public FeaturePackSpec build() throws ProvisioningDescriptionException {
            try {
                return new FeaturePackSpec(this);
            }
            catch (ProvisioningDescriptionException e) {
                throw new ProvisioningDescriptionException("Failed to build feature-pack spec for " + this.fpid, e);
            }
        }
    }
}

