/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.universe.maven;

import java.io.IOException;
import java.nio.file.Path;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.creator.UniverseFeaturePackCreator;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.jboss.galleon.universe.Universe;
import org.jboss.galleon.universe.maven.MavenArtifact;
import org.jboss.galleon.universe.maven.MavenProducer;
import org.jboss.galleon.universe.maven.MavenUniverse;
import org.jboss.galleon.universe.maven.MavenUniverseException;
import org.jboss.galleon.util.IoUtils;
import org.jboss.galleon.util.ZipUtils;

public class MavenFeaturePackCreator
implements UniverseFeaturePackCreator {
    public static final String ZIP = "zip";

    @Override
    public String getUniverseFactoryId() {
        return "maven";
    }

    @Override
    public void install(Universe<?> universe, FeaturePackLocation.FPID fpid, Path fpContentDir) throws ProvisioningException {
        MavenUniverse mvnUni = (MavenUniverse)universe;
        FeaturePackLocation fps = fpid.getLocation();
        MavenProducer producer = mvnUni.getProducer(fps.getProducerName());
        producer.getChannel(fps.getChannelName());
        MavenArtifact artifact = new MavenArtifact();
        artifact.setGroupId(producer.getFeaturePackGroupId());
        artifact.setArtifactId(producer.getFeaturePackArtifactId());
        artifact.setVersion(fpid.getBuild());
        artifact.setExtension(ZIP);
        Path tmpFile = null;
        try {
            tmpFile = fpContentDir.getParent().resolve(artifact.getArtifactFileName());
            ZipUtils.zip(fpContentDir, tmpFile);
            producer.getRepo().install(artifact, tmpFile);
        }
        catch (IOException e) {
            throw new MavenUniverseException("Failed to create a feature-pack archive", e);
        }
        finally {
            if (tmpFile != null) {
                IoUtils.recursiveDelete(tmpFile);
            }
        }
    }
}

