/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.universe.maven;

import java.nio.file.FileSystem;
import java.nio.file.Path;
import org.jboss.galleon.universe.Producer;
import org.jboss.galleon.universe.maven.MavenArtifact;
import org.jboss.galleon.universe.maven.MavenChannel;
import org.jboss.galleon.universe.maven.MavenProducerDescription;
import org.jboss.galleon.universe.maven.MavenUniverseException;
import org.jboss.galleon.universe.maven.repo.MavenRepoManager;

public abstract class MavenProducerBase
implements Producer<MavenChannel>,
MavenProducerDescription<MavenChannel> {
    protected final String name;
    protected final MavenRepoManager repo;
    protected final MavenArtifact artifact;
    protected String fpGroupId;
    protected String fpArtifactId;

    protected MavenProducerBase(String name, MavenRepoManager repoManager, MavenArtifact artifact) throws MavenUniverseException {
        this.name = name;
        this.repo = repoManager;
        this.artifact = artifact;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public MavenArtifact getArtifact() {
        return this.artifact;
    }

    public MavenRepoManager getRepo() {
        return this.repo;
    }

    @Override
    public String getFeaturePackGroupId() {
        return this.fpGroupId;
    }

    @Override
    public String getFeaturePackArtifactId() {
        return this.fpArtifactId;
    }

    protected static Path getProducerDir(FileSystem zipfs, String producerName) {
        return zipfs.getPath("galleon", "universe", "producer", producerName);
    }

    static Path getProducerDir(Path root, String producerName) {
        return root.resolve("galleon").resolve("universe").resolve("producer").resolve(producerName);
    }

    protected static Path getProducerXml(FileSystem zipfs, String producerName) {
        return MavenProducerBase.getProducerDir(zipfs, producerName).resolve("maven-producer.xml");
    }

    protected static Path getChannelsDir(FileSystem zipfs, String producerName) {
        return zipfs.getPath("galleon", "universe", "producer", producerName, "channels");
    }

    protected static Path getChannelXml(FileSystem zipfs, String producerName, String channelName) {
        return MavenProducerBase.getProducerDir(zipfs, producerName).resolve("channels").resolve(channelName).resolve("maven-channel.xml");
    }
}

