/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CollectionUtils {
    public static <K, V> Map<K, V> unmodifiable(Map<K, V> m) {
        return m.size() > 1 ? Collections.unmodifiableMap(m) : m;
    }

    public static <K, V> Map<K, V> clone(Map<K, V> m) {
        return m.size() > 1 ? new HashMap(m) : m;
    }

    public static <K, V> Map<K, V> put(Map<K, V> m, K k, V v) {
        if (m.isEmpty()) {
            return Collections.singletonMap(k, v);
        }
        if (m.size() == 1) {
            if (m.containsKey(k)) {
                return Collections.singletonMap(k, v);
            }
            Map.Entry<K, V> first = m.entrySet().iterator().next();
            m = new HashMap(2);
            m.put(first.getKey(), first.getValue());
        }
        m.put(k, v);
        return m;
    }

    public static <K, V> Map<K, V> putAll(Map<K, V> m, Map<K, V> values) {
        if (values.isEmpty()) {
            return m;
        }
        if (m.isEmpty()) {
            int size = values.size();
            if (size == 1) {
                return values;
            }
            m = new HashMap(size);
            m.putAll(values);
            return m;
        }
        if (m.size() == 1) {
            Map.Entry<K, V> first = m.entrySet().iterator().next();
            m = new HashMap(values.size());
            m.put(first.getKey(), first.getValue());
        }
        m.putAll(values);
        return m;
    }

    public static <K, V> Map<K, V> putLinked(Map<K, V> m, K k, V v) {
        if (m.isEmpty()) {
            return Collections.singletonMap(k, v);
        }
        if (m.size() == 1) {
            if (m.containsKey(k)) {
                return Collections.singletonMap(k, v);
            }
            Map.Entry<K, V> first = m.entrySet().iterator().next();
            m = new LinkedHashMap(2);
            m.put(first.getKey(), first.getValue());
        }
        m.put(k, v);
        return m;
    }

    public static <K, V> Map<K, V> remove(Map<K, V> m, K k) {
        if (!m.containsKey(k)) {
            return m;
        }
        switch (m.size()) {
            case 1: {
                return Collections.emptyMap();
            }
            case 2: {
                for (Map.Entry<K, V> e : m.entrySet()) {
                    if (e.getKey().equals(k)) continue;
                    return Collections.singletonMap(e.getKey(), e.getValue());
                }
                break;
            }
        }
        m.remove(k);
        return m;
    }

    public static <T> List<T> unmodifiable(List<T> l) {
        return l.size() > 1 ? Collections.unmodifiableList(l) : l;
    }

    public static <T> List<T> add(List<T> s, T t) {
        if (s.isEmpty()) {
            return Collections.singletonList(t);
        }
        if (s.size() == 1) {
            T first = s.get(0);
            s = new ArrayList<T>(2);
            s.add(first);
        }
        s.add(t);
        return s;
    }

    public static <T> List<T> add(List<T> s, int index, T t) {
        if (s.isEmpty()) {
            return Collections.singletonList(t);
        }
        if (s.size() == 1) {
            T first = s.get(0);
            s = new ArrayList<T>(2);
            s.add(first);
        }
        if (index >= s.size()) {
            s.add(t);
        } else {
            s.add(index, t);
        }
        return s;
    }

    public static <T> List<T> remove(List<T> s, int index) {
        if (s.isEmpty() || s.size() == 1) {
            return Collections.emptyList();
        }
        s.remove(index);
        if (s.size() == 1) {
            return Collections.singletonList(s.get(0));
        }
        return s;
    }

    public static <T> List<T> addAll(List<T> dest, List<T> src) {
        if (dest.isEmpty()) {
            return src;
        }
        if (src.isEmpty()) {
            return dest;
        }
        if (dest.size() == 1) {
            T first = dest.get(0);
            dest = new ArrayList<T>(src.size() + 1);
            dest.add(first);
        }
        dest.addAll(src);
        return dest;
    }

    public static <T> List<T> clone(List<T> s) {
        return s.size() > 1 ? new ArrayList(s) : s;
    }

    public static <T> Set<T> unmodifiable(Set<T> s) {
        return s.size() > 1 ? Collections.unmodifiableSet(s) : s;
    }

    public static <T> Set<T> add(Set<T> s, T t) {
        if (s.isEmpty()) {
            return Collections.singleton(t);
        }
        if (s.size() == 1) {
            if (s.contains(t)) {
                return s;
            }
            T first = s.iterator().next();
            s = new HashSet<T>(2);
            s.add(first);
        }
        s.add(t);
        return s;
    }

    public static <T> Set<T> remove(Set<T> s, T t) {
        if (!s.contains(t)) {
            return s;
        }
        switch (s.size()) {
            case 1: {
                return Collections.emptySet();
            }
            case 2: {
                for (T i : s) {
                    if (i.equals(t)) continue;
                    return Collections.singleton(i);
                }
                break;
            }
        }
        s.remove(t);
        return s;
    }

    public static <T> Set<T> addLinked(Set<T> s, T t) {
        if (s.isEmpty()) {
            return Collections.singleton(t);
        }
        if (s.size() == 1) {
            if (s.contains(t)) {
                return s;
            }
            T first = s.iterator().next();
            s = new LinkedHashSet<T>(2);
            s.add(first);
        }
        s.add(t);
        return s;
    }

    public static <T> Set<T> clone(Set<T> s) {
        return s.size() > 1 ? new HashSet(s) : s;
    }
}

