/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.xml;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.jboss.galleon.ProvisioningDescriptionException;
import org.jboss.galleon.config.ConfigModel;
import org.jboss.galleon.config.FeaturePackDepsConfigBuilder;
import org.jboss.galleon.spec.FeaturePackSpec;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.jboss.galleon.util.ParsingUtils;
import org.jboss.galleon.xml.ConfigXml;
import org.jboss.galleon.xml.PlugableXmlParser;
import org.jboss.galleon.xml.ProvisioningXmlParser10;
import org.jboss.galleon.xml.ProvisioningXmlParser20;
import org.jboss.galleon.xml.XmlNameProvider;
import org.jboss.staxmapper.XMLExtendedStreamReader;

public class FeaturePackXmlParser20
implements PlugableXmlParser<FeaturePackSpec.Builder> {
    public static final String NAMESPACE_2_0 = "urn:jboss:galleon:feature-pack:2.0";
    public static final QName ROOT_1_0 = new QName("urn:jboss:galleon:feature-pack:2.0", Element.FEATURE_PACK.getLocalName());

    @Override
    public QName getRoot() {
        return ROOT_1_0;
    }

    @Override
    public void readElement(XMLExtendedStreamReader reader, FeaturePackSpec.Builder fpBuilder) throws XMLStreamException {
        fpBuilder.setFPID(this.readSource(reader).getFPID());
        block14: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName().getLocalPart());
                    switch (element) {
                        case UNIVERSES: {
                            ProvisioningXmlParser20.readUniverses(reader, fpBuilder);
                            continue block14;
                        }
                        case DEPENDENCIES: {
                            FeaturePackXmlParser20.readFeaturePackDeps(reader, fpBuilder);
                            continue block14;
                        }
                        case DEFAULT_CONFIGS: {
                            ProvisioningXmlParser10.parseDefaultConfigs(reader, fpBuilder);
                            continue block14;
                        }
                        case CONFIG: {
                            ConfigModel.Builder config = ConfigModel.builder();
                            ConfigXml.readConfig(reader, config);
                            try {
                                fpBuilder.addConfig(config.build());
                                continue block14;
                            }
                            catch (ProvisioningDescriptionException e) {
                                throw new XMLStreamException("Failed to parse " + Element.CONFIG, reader.getLocation(), e);
                            }
                        }
                        case DEFAULT_PACKAGES: {
                            this.readDefaultPackages(reader, fpBuilder);
                            continue block14;
                        }
                        case TRANSITIVE: {
                            FeaturePackXmlParser20.readTransitive(reader, fpBuilder);
                            continue block14;
                        }
                    }
                    throw ParsingUtils.unexpectedContent(reader);
                }
            }
            throw ParsingUtils.unexpectedContent(reader);
        }
        throw ParsingUtils.endOfDocument(reader.getLocation());
    }

    private FeaturePackLocation readSource(XMLExtendedStreamReader reader) throws XMLStreamException {
        FeaturePackLocation location = null;
        int count = reader.getAttributeCount();
        block5: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i).getLocalPart());
            switch (attribute) {
                case LOCATION: {
                    try {
                        location = FeaturePackLocation.fromString(reader.getAttributeValue(i));
                        continue block5;
                    }
                    catch (IllegalArgumentException e) {
                        throw new XMLStreamException(ParsingUtils.error("Failed to parse feature-pack location", reader.getLocation()), e);
                    }
                }
                default: {
                    throw ParsingUtils.unexpectedContent(reader);
                }
            }
        }
        if (location == null) {
            throw ParsingUtils.missingAttributes(reader.getLocation(), Collections.singleton(Attribute.LOCATION));
        }
        return location;
    }

    private static void readFeaturePackDeps(XMLExtendedStreamReader reader, FeaturePackDepsConfigBuilder<?> fpBuilder) throws XMLStreamException {
        ParsingUtils.parseNoAttributes(reader);
        boolean hasChildren = false;
        block7: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    if (!hasChildren) {
                        throw ParsingUtils.expectedAtLeastOneChild(reader, Element.DEPENDENCIES, Element.DEPENDENCY);
                    }
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName().getLocalPart());
                    switch (element) {
                        case DEPENDENCY: {
                            ProvisioningXmlParser20.readFeaturePackDep(reader, fpBuilder);
                            hasChildren = true;
                            continue block7;
                        }
                    }
                    throw ParsingUtils.unexpectedContent(reader);
                }
            }
            throw ParsingUtils.unexpectedContent(reader);
        }
        throw ParsingUtils.endOfDocument(reader.getLocation());
    }

    private static void readTransitive(XMLExtendedStreamReader reader, FeaturePackDepsConfigBuilder<?> builder) throws XMLStreamException {
        ParsingUtils.parseNoAttributes(reader);
        block7: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getLocalName());
                    switch (element) {
                        case DEPENDENCY: {
                            ProvisioningXmlParser20.readTransitiveFeaturePackDep(reader, builder);
                            continue block7;
                        }
                    }
                    throw ParsingUtils.unexpectedContent(reader);
                }
            }
            throw ParsingUtils.unexpectedContent(reader);
        }
        throw ParsingUtils.endOfDocument(reader.getLocation());
    }

    private void readDefaultPackages(XMLExtendedStreamReader reader, FeaturePackSpec.Builder fpBuilder) throws XMLStreamException {
        ParsingUtils.parseNoAttributes(reader);
        boolean hasChildren = false;
        block7: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    if (!hasChildren) {
                        throw ParsingUtils.expectedAtLeastOneChild(reader, Element.DEFAULT_PACKAGES, Element.PACKAGE);
                    }
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName().getLocalPart());
                    switch (element) {
                        case PACKAGE: {
                            fpBuilder.addDefaultPackage(this.parseName(reader));
                            hasChildren = true;
                            continue block7;
                        }
                    }
                    throw ParsingUtils.unexpectedContent(reader);
                }
            }
            throw ParsingUtils.unexpectedContent(reader);
        }
        throw ParsingUtils.endOfDocument(reader.getLocation());
    }

    private String parseName(XMLExtendedStreamReader reader) throws XMLStreamException {
        int count = reader.getAttributeCount();
        String path = null;
        boolean parsedTarget = false;
        block3: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i).getLocalPart());
            switch (attribute) {
                case NAME: {
                    path = reader.getAttributeValue(i);
                    parsedTarget = true;
                    continue block3;
                }
                default: {
                    throw ParsingUtils.unexpectedContent(reader);
                }
            }
        }
        if (!parsedTarget) {
            throw ParsingUtils.missingAttributes(reader.getLocation(), Collections.singleton(Attribute.NAME));
        }
        ParsingUtils.parseNoContent(reader);
        return path;
    }

    static enum Attribute implements XmlNameProvider
    {
        CLASSIFIER("classifier"),
        COORDS("coords"),
        EXTENSION("extension"),
        INHERIT("inherit"),
        LOCATION("location"),
        MODEL("model"),
        NAMED_CONFIGS_ONLY("named-configs-only"),
        NAME("name"),
        UNKNOWN(null);

        private static final Map<String, Attribute> attributes;
        private final String name;

        static Attribute of(String name) {
            Attribute attribute = attributes.get(name);
            return attribute == null ? UNKNOWN : attribute;
        }

        private Attribute(String name) {
            this.name = name;
        }

        @Override
        public String getLocalName() {
            return this.name;
        }

        @Override
        public String getNamespace() {
            return null;
        }

        static {
            attributes = new HashMap<String, Attribute>(9);
            attributes.put(CLASSIFIER.getLocalName(), CLASSIFIER);
            attributes.put(COORDS.getLocalName(), COORDS);
            attributes.put(EXTENSION.getLocalName(), EXTENSION);
            attributes.put(INHERIT.getLocalName(), INHERIT);
            attributes.put(LOCATION.getLocalName(), LOCATION);
            attributes.put(MODEL.getLocalName(), MODEL);
            attributes.put(NAME.getLocalName(), NAME);
            attributes.put(NAMED_CONFIGS_ONLY.getLocalName(), NAMED_CONFIGS_ONLY);
            attributes.put(null, UNKNOWN);
        }
    }

    public static enum Element implements XmlNameProvider
    {
        CONFIG("config"),
        DEFAULT_CONFIGS("default-configs"),
        DEFAULT_PACKAGES("default-packages"),
        DEPENDENCIES("dependencies"),
        DEPENDENCY("dependency"),
        EXCLUDE("exclude"),
        FEATURE_PACK("feature-pack"),
        INCLUDE("include"),
        NAME("name"),
        PACKAGES("packages"),
        PACKAGE("package"),
        TRANSITIVE("transitive"),
        UNIVERSES("universes"),
        UNKNOWN(null);

        private static final Map<String, Element> elements;
        private final String name;
        private final String namespace = "urn:jboss:galleon:feature-pack:2.0";

        static Element of(String name) {
            Element element = elements.get(name);
            return element == null ? UNKNOWN : element;
        }

        private Element(String name) {
            this.name = name;
        }

        @Override
        public String getLocalName() {
            return this.name;
        }

        @Override
        public String getNamespace() {
            return FeaturePackXmlParser20.NAMESPACE_2_0;
        }

        static {
            elements = new HashMap<String, Element>(14);
            elements.put(Element.CONFIG.name, CONFIG);
            elements.put(Element.DEFAULT_CONFIGS.name, DEFAULT_CONFIGS);
            elements.put(Element.DEFAULT_PACKAGES.name, DEFAULT_PACKAGES);
            elements.put(Element.DEPENDENCIES.name, DEPENDENCIES);
            elements.put(Element.DEPENDENCY.name, DEPENDENCY);
            elements.put(Element.EXCLUDE.name, EXCLUDE);
            elements.put(Element.FEATURE_PACK.name, FEATURE_PACK);
            elements.put(Element.INCLUDE.name, INCLUDE);
            elements.put(Element.NAME.name, NAME);
            elements.put(Element.PACKAGES.name, PACKAGES);
            elements.put(Element.PACKAGE.name, PACKAGE);
            elements.put(Element.TRANSITIVE.name, TRANSITIVE);
            elements.put(Element.UNIVERSES.name, UNIVERSES);
            elements.put(null, UNKNOWN);
        }
    }
}

