/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import org.jboss.galleon.ArtifactCoords;
import org.jboss.galleon.ArtifactRepositoryManager;
import org.jboss.galleon.DefaultMessageWriter;
import org.jboss.galleon.Errors;
import org.jboss.galleon.MessageWriter;
import org.jboss.galleon.ProvisioningDescriptionException;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.config.FeaturePackConfig;
import org.jboss.galleon.config.ProvisioningConfig;
import org.jboss.galleon.layout.ProvisioningLayout;
import org.jboss.galleon.layout.ProvisioningLayoutFactory;
import org.jboss.galleon.layout.ProvisioningPlan;
import org.jboss.galleon.runtime.FeaturePackRuntimeBuilder;
import org.jboss.galleon.runtime.ProvisioningRuntime;
import org.jboss.galleon.runtime.ProvisioningRuntimeBuilder;
import org.jboss.galleon.state.ProvisionedState;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.jboss.galleon.universe.UniverseFactoryLoader;
import org.jboss.galleon.universe.UniverseResolver;
import org.jboss.galleon.universe.UniverseResolverBuilder;
import org.jboss.galleon.universe.UniverseSpec;
import org.jboss.galleon.universe.galleon1.LegacyGalleon1Universe;
import org.jboss.galleon.util.IoUtils;
import org.jboss.galleon.util.PathsUtils;
import org.jboss.galleon.util.StateHistoryUtils;
import org.jboss.galleon.xml.ProvisionedStateXmlParser;
import org.jboss.galleon.xml.ProvisioningXmlParser;
import org.jboss.galleon.xml.ProvisioningXmlWriter;

public class ProvisioningManager
implements AutoCloseable {
    private final String encoding;
    private final Path home;
    private final MessageWriter log;
    private final UniverseResolver universeResolver;
    private ProvisioningLayoutFactory layoutFactory;
    private boolean closeLayoutFactory;
    private ProvisioningConfig provisioningConfig;

    public static Builder builder() {
        return new Builder();
    }

    private ProvisioningManager(Builder builder) throws ProvisioningException {
        PathsUtils.assertInstallationDir(builder.installationHome);
        this.home = builder.installationHome;
        this.encoding = builder.encoding;
        MessageWriter messageWriter = this.log = builder.messageWriter == null ? DefaultMessageWriter.getDefaultInstance() : builder.messageWriter;
        if (builder.layoutFactory != null) {
            this.layoutFactory = builder.layoutFactory;
            this.closeLayoutFactory = false;
            this.universeResolver = this.layoutFactory.getUniverseResolver();
        } else {
            this.universeResolver = builder.getUniverseResolver();
        }
    }

    public ProvisioningLayoutFactory getLayoutFactory() {
        if (this.layoutFactory == null) {
            this.closeLayoutFactory = true;
            this.layoutFactory = ProvisioningLayoutFactory.getInstance(this.universeResolver);
        }
        return this.layoutFactory;
    }

    public Path getInstallationHome() {
        return this.home;
    }

    public void addUniverse(String name, UniverseSpec universeSpec) throws ProvisioningException {
        ProvisioningConfig config = ((ProvisioningConfig.Builder)this.getInstallationBuilder().addUniverse(name, universeSpec)).build();
        try {
            ProvisioningXmlWriter.getInstance().write(config, PathsUtils.getProvisioningXml(this.home));
        }
        catch (Exception e) {
            throw new ProvisioningException(Errors.writeFile(PathsUtils.getProvisioningXml(this.home)), e);
        }
        this.provisioningConfig = config;
    }

    public void removeUniverse(String name) throws ProvisioningException {
        ProvisioningConfig config = this.getProvisioningConfig();
        if (config == null || !config.hasUniverse(name)) {
            return;
        }
        config = ((ProvisioningConfig.Builder)ProvisioningConfig.builder(config).removeUniverse(name)).build();
        try {
            ProvisioningXmlWriter.getInstance().write(config, PathsUtils.getProvisioningXml(this.home));
        }
        catch (Exception e) {
            throw new ProvisioningException(Errors.writeFile(PathsUtils.getProvisioningXml(this.home)), e);
        }
        this.provisioningConfig = config;
    }

    public void setDefaultUniverse(UniverseSpec universeSpec) throws ProvisioningException {
        this.addUniverse(null, universeSpec);
    }

    public ProvisioningConfig getProvisioningConfig() throws ProvisioningException {
        if (this.provisioningConfig == null) {
            this.provisioningConfig = ProvisioningXmlParser.parse(PathsUtils.getProvisioningXml(this.home));
        }
        return this.provisioningConfig;
    }

    public ProvisionedState getProvisionedState() throws ProvisioningException {
        return ProvisionedStateXmlParser.parse(PathsUtils.getProvisionedStateXml(this.home));
    }

    public void install(Path featurePack) throws ProvisioningException {
        this.install(featurePack, true);
    }

    public void install(Path featurePack, boolean installInUniverse) throws ProvisioningException {
        this.install(this.getLayoutFactory().addLocal(featurePack, installInUniverse));
    }

    public void install(FeaturePackLocation fpl) throws ProvisioningException {
        this.install(FeaturePackConfig.forLocation(fpl));
    }

    public void install(FeaturePackLocation fpl, Map<String, String> options) throws ProvisioningException {
        this.install(FeaturePackConfig.forLocation(fpl), options);
    }

    public void install(FeaturePackConfig fpConfig) throws ProvisioningException {
        this.install(fpConfig, Collections.emptyMap());
    }

    public void install(FeaturePackConfig fpConfig, Map<String, String> options) throws ProvisioningException {
        boolean empty;
        ProvisioningConfig config = this.getProvisioningConfig();
        boolean bl = empty = config == null || !config.hasFeaturePackDeps();
        if (empty) {
            config = ((ProvisioningConfig.Builder)this.getInstallationBuilder().addFeaturePackDep(fpConfig)).build();
        }
        try (ProvisioningLayout<FeaturePackRuntimeBuilder> layout = this.getLayoutFactory().newConfigLayout(config, ProvisioningRuntimeBuilder.FP_RT_FACTORY);){
            if (!empty) {
                UniverseSpec configuredUniverse = this.getConfiguredUniverse(fpConfig.getLocation());
                layout.install(configuredUniverse == null ? fpConfig : FeaturePackConfig.builder(fpConfig.getLocation().replaceUniverse(configuredUniverse)).init(fpConfig).build());
            }
            try (ProvisioningRuntime runtime = this.getRuntime(layout, options);){
                this.doProvision(runtime);
            }
        }
    }

    public void uninstall(FeaturePackLocation.FPID fpid) throws ProvisioningException {
        boolean empty;
        ProvisioningConfig config = this.getProvisioningConfig();
        boolean bl = empty = config == null || !config.hasFeaturePackDeps();
        if (empty) {
            throw new ProvisioningException(Errors.unknownFeaturePack(fpid));
        }
        try (ProvisioningLayout<FeaturePackRuntimeBuilder> layout = this.getLayoutFactory().newConfigLayout(config, ProvisioningRuntimeBuilder.FP_RT_FACTORY);){
            layout.uninstall(this.resolveUniverseSpec(fpid.getLocation()).getFPID());
            try (ProvisioningRuntime runtime = this.getRuntime(layout, Collections.emptyMap());){
                this.doProvision(runtime);
            }
        }
    }

    public void provision(ProvisioningConfig provisioningConfig) throws ProvisioningException {
        this.provision(provisioningConfig, Collections.emptyMap());
    }

    public void provision(ProvisioningConfig provisioningConfig, Map<String, String> options) throws ProvisioningException {
        try (ProvisioningRuntime runtime = this.getRuntime(provisioningConfig, options);){
            this.doProvision(runtime);
        }
    }

    public void provision(ProvisioningLayout<?> provisioningLayout, Map<String, String> options) throws ProvisioningException {
        try (ProvisioningRuntime runtime = this.getRuntime(provisioningLayout, options);){
            this.doProvision(runtime);
        }
    }

    public void provision(Path provisioningXml) throws ProvisioningException {
        this.provision(provisioningXml, Collections.emptyMap());
    }

    public void provision(Path provisioningXml, Map<String, String> options) throws ProvisioningException {
        try (ProvisioningRuntime runtime = this.getRuntime(ProvisioningXmlParser.parse(provisioningXml), options);){
            this.doProvision(runtime);
        }
    }

    public ProvisioningPlan getUpdates(boolean includeTransitive) throws ProvisioningException {
        ProvisioningPlan plan;
        ProvisioningConfig config = this.getProvisioningConfig();
        if (config == null) {
            plan = ProvisioningPlan.builder();
        } else {
            try (ProvisioningLayout<ProvisioningLayout.FeaturePackLayout> layout = this.getLayoutFactory().newConfigLayout(config);){
                plan = layout.getUpdates(includeTransitive);
            }
        }
        return plan;
    }

    public ProvisioningPlan getUpdates(FeaturePackLocation.ProducerSpec ... producers) throws ProvisioningException {
        ProvisioningPlan plan;
        ProvisioningConfig config = this.getProvisioningConfig();
        if (config == null) {
            plan = ProvisioningPlan.builder();
        } else {
            try (ProvisioningLayout<ProvisioningLayout.FeaturePackLayout> layout = this.getLayoutFactory().newConfigLayout(config);){
                plan = layout.getUpdates(producers);
            }
        }
        return plan;
    }

    public void apply(ProvisioningPlan plan) throws ProvisioningException {
        this.apply(plan, Collections.emptyMap());
    }

    public void apply(ProvisioningPlan plan, Map<String, String> options) throws ProvisioningException {
        ProvisioningConfig config = this.getProvisioningConfig();
        try (ProvisioningLayout<FeaturePackRuntimeBuilder> layout = this.getLayoutFactory().newConfigLayout(config == null ? this.getInstallationBuilder().build() : config, ProvisioningRuntimeBuilder.FP_RT_FACTORY);){
            layout.apply(plan);
            try (ProvisioningRuntime runtime = this.getRuntime(layout, options);){
                this.doProvision(runtime);
            }
        }
    }

    public boolean isUndoAvailable() throws ProvisioningException {
        return StateHistoryUtils.isUndoAvailable(this.home, this.log);
    }

    public int getStateHistoryLimit() throws ProvisioningException {
        return StateHistoryUtils.readStateHistoryLimit(this.home, this.log);
    }

    public void setStateHistoryLimit(int limit) throws ProvisioningException {
        StateHistoryUtils.writeStateHistoryLimit(this.home, limit, this.log);
    }

    public void undo() throws ProvisioningException {
        try (ProvisioningRuntime runtime = this.getRuntime(StateHistoryUtils.readUndoConfig(this.home, this.log), Collections.emptyMap());){
            try {
                runtime.provision();
                PathsUtils.replaceDist(runtime.getStagedDir(), this.home, true, this.log);
            }
            finally {
                this.provisioningConfig = null;
            }
        }
    }

    public void exportProvisioningConfig(Path location) throws ProvisioningException, IOException {
        Path exportPath = location;
        Path userProvisionedXml = PathsUtils.getProvisioningXml(this.home);
        if (!Files.exists(userProvisionedXml, new LinkOption[0])) {
            throw new ProvisioningException("Provisioned state record is missing for " + this.home);
        }
        if (Files.isDirectory(exportPath, new LinkOption[0])) {
            exportPath = exportPath.resolve(userProvisionedXml.getFileName());
        }
        IoUtils.copy(userProvisionedXml, exportPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportConfigurationChanges(Path location, FeaturePackLocation.FPID fpid, Map<String, String> options) throws ProvisioningException, IOException {
        ProvisioningConfig configuration = this.getProvisioningConfig();
        if (configuration == null) {
            Path userProvisionedXml = PathsUtils.getProvisioningXml(this.home);
            if (!Files.exists(userProvisionedXml, new LinkOption[0])) {
                throw new ProvisioningException("Provisioned state record is missing for " + this.home);
            }
            Path xmlTarget = location;
            if (Files.isDirectory(xmlTarget, new LinkOption[0])) {
                xmlTarget = xmlTarget.resolve(userProvisionedXml.getFileName());
            }
            Files.copy(userProvisionedXml, xmlTarget, StandardCopyOption.REPLACE_EXISTING);
        }
        Path tempInstallationDir = IoUtils.createRandomTmpDir();
        try (ProvisioningManager reference = new ProvisioningManager(ProvisioningManager.builder().setLayoutFactory(this.getLayoutFactory()).setEncoding(this.encoding).setInstallationHome(tempInstallationDir).setMessageWriter(new MessageWriter(){

            @Override
            public void verbose(Throwable cause, CharSequence message) {
            }

            @Override
            public void print(Throwable cause, CharSequence message) {
                ProvisioningManager.this.log.print(cause, message);
            }

            @Override
            public void error(Throwable cause, CharSequence message) {
                ProvisioningManager.this.log.error(cause, message);
            }

            @Override
            public boolean isVerboseEnabled() {
                return false;
            }

            @Override
            public void close() throws Exception {
            }
        }));){
            reference.provision(configuration);
            try (ProvisioningRuntime runtime = ProvisioningRuntimeBuilder.newInstance(this.log).initLayout(this.getLayoutFactory(), configuration).setEncoding(this.encoding).addOptions(options).setOperation(fpid != null ? "diff-to-feature-pack" : "diff").build();){
                if (fpid != null) {
                    ProvisioningRuntime.exportToFeaturePack(runtime, fpid, location, this.home);
                } else {
                    ProvisioningRuntime.diff(runtime, location, this.home);
                    runtime.getDiff().toXML(location, this.home);
                }
            }
            catch (IOException | XMLStreamException e) {
                this.log.error(e, e.getMessage());
            }
        }
        finally {
            IoUtils.recursiveDelete(tempInstallationDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void upgrade(ArtifactCoords.Gav fpGav, Map<String, String> options) throws ProvisioningException, IOException {
        ProvisioningConfig configuration = this.getProvisioningConfig();
        Path tempInstallationDir = IoUtils.createRandomTmpDir();
        Path stagedDir = IoUtils.createRandomTmpDir();
        try (ProvisioningManager reference = new ProvisioningManager(ProvisioningManager.builder().setLayoutFactory(this.getLayoutFactory()).setEncoding(this.encoding).setInstallationHome(tempInstallationDir).setMessageWriter(new MessageWriter(){

            @Override
            public void verbose(Throwable cause, CharSequence message) {
            }

            @Override
            public void print(Throwable cause, CharSequence message) {
                ProvisioningManager.this.log.print(cause, message);
            }

            @Override
            public void error(Throwable cause, CharSequence message) {
                ProvisioningManager.this.log.error(cause, message);
            }

            @Override
            public boolean isVerboseEnabled() {
                return false;
            }

            @Override
            public void close() throws Exception {
            }
        }));){
            reference.provision(configuration);
        }
        Files.createDirectories(stagedDir, new FileAttribute[0]);
        reference = new ProvisioningManager(ProvisioningManager.builder().setLayoutFactory(this.getLayoutFactory()).setEncoding(this.encoding).setInstallationHome(stagedDir).setMessageWriter(new MessageWriter(){

            @Override
            public void verbose(Throwable cause, CharSequence message) {
            }

            @Override
            public void print(Throwable cause, CharSequence message) {
                ProvisioningManager.this.log.print(cause, message);
            }

            @Override
            public void error(Throwable cause, CharSequence message) {
                ProvisioningManager.this.log.error(cause, message);
            }

            @Override
            public boolean isVerboseEnabled() {
                return false;
            }

            @Override
            public void close() throws Exception {
            }
        }));
        var7_7 = null;
        try {
            reference.provision(((ProvisioningConfig.Builder)ProvisioningConfig.builder().addFeaturePackDep(FeaturePackConfig.forLocation(LegacyGalleon1Universe.toFpl(fpGav)))).build());
        }
        catch (Throwable throwable) {
            var7_7 = throwable;
            throw throwable;
        }
        finally {
            if (reference != null) {
                if (var7_7 != null) {
                    try {
                        reference.close();
                    }
                    catch (Throwable throwable) {
                        var7_7.addSuppressed(throwable);
                    }
                } else {
                    reference.close();
                }
            }
        }
        try {
            var7_7 = null;
            try (ProvisioningRuntime runtime = ProvisioningRuntimeBuilder.newInstance(this.log).initLayout(this.getLayoutFactory(), configuration).setEncoding(this.encoding).addOptions(options).setOperation("upgrade").build();){
                Files.createDirectories(tempInstallationDir.resolve("model_diff"), new FileAttribute[0]);
                ProvisioningRuntime.diff(runtime, tempInstallationDir.resolve("model_diff"), this.home);
                ProvisioningRuntime.upgrade(runtime, stagedDir, this.home);
            }
            catch (Throwable throwable) {
                var7_7 = throwable;
                throw throwable;
            }
        }
        finally {
            IoUtils.recursiveDelete(tempInstallationDir);
            IoUtils.recursiveDelete(stagedDir);
        }
    }

    public ProvisioningRuntime getRuntime(ProvisioningConfig provisioningConfig, Map<String, String> options) throws ProvisioningException {
        return this.getRuntimeInternal(this.getLayoutFactory().newConfigLayout(provisioningConfig, ProvisioningRuntimeBuilder.FP_RT_FACTORY), options);
    }

    public ProvisioningRuntime getRuntime(ProvisioningLayout<?> provisioningLayout, Map<String, String> options) throws ProvisioningException {
        return this.getRuntimeInternal(provisioningLayout.transform(ProvisioningRuntimeBuilder.FP_RT_FACTORY), options);
    }

    private ProvisioningRuntime getRuntimeInternal(ProvisioningLayout<FeaturePackRuntimeBuilder> layout, Map<String, String> options) throws ProvisioningException {
        return ProvisioningRuntimeBuilder.newInstance(this.log).initRtLayout(layout).setEncoding(this.encoding).addOptions(options).build();
    }

    private ProvisioningConfig.Builder getInstallationBuilder() throws ProvisioningException {
        return ProvisioningConfig.builder(this.getProvisioningConfig());
    }

    private void doProvision(ProvisioningRuntime runtime) throws ProvisioningException {
        try {
            runtime.provision();
            PathsUtils.replaceDist(runtime.getStagedDir(), this.home, false, this.log);
        }
        finally {
            this.provisioningConfig = null;
        }
    }

    private FeaturePackLocation resolveUniverseSpec(FeaturePackLocation fpl) throws ProvisioningException {
        UniverseSpec universeSpec = this.getConfiguredUniverse(fpl);
        return universeSpec == null ? fpl : fpl.replaceUniverse(universeSpec);
    }

    private UniverseSpec getConfiguredUniverse(FeaturePackLocation fpl) throws ProvisioningException, ProvisioningDescriptionException {
        ProvisioningConfig config = this.getProvisioningConfig();
        if (config == null) {
            return null;
        }
        if (fpl.hasUniverse()) {
            String name = fpl.getUniverse().toString();
            if (config.hasUniverse(name)) {
                return config.getUniverseSpec(name);
            }
            return null;
        }
        return config.getDefaultUniverse();
    }

    @Override
    public void close() {
        if (this.closeLayoutFactory) {
            this.layoutFactory.close();
        }
    }

    public static class Builder
    extends UniverseResolverBuilder<Builder> {
        private String encoding = "UTF-8";
        private Path installationHome;
        private ProvisioningLayoutFactory layoutFactory;
        private MessageWriter messageWriter;
        private UniverseResolver resolver;

        private Builder() {
        }

        public Builder setArtifactResolver(ArtifactRepositoryManager arm) {
            try {
                return (Builder)this.addArtifactResolver(arm);
            }
            catch (ProvisioningException e) {
                throw new IllegalStateException("Failed to set artifact resolver", e);
            }
        }

        public Builder setEncoding(String encoding) {
            this.encoding = encoding;
            return this;
        }

        public Builder setInstallationHome(Path installationHome) {
            this.installationHome = installationHome;
            return this;
        }

        public Builder setLayoutFactory(ProvisioningLayoutFactory layoutFactory) throws ProvisioningException {
            if (this.ufl != null) {
                throw new ProvisioningException("Universe factory loader has already been initialized which conflicts with the initialization of provisioning layout factory");
            }
            if (this.resolver != null) {
                throw new ProvisioningException("Universe resolver has already been initialized which conflicts with the initialization of provisioning layout factory");
            }
            this.layoutFactory = layoutFactory;
            return this;
        }

        @Override
        protected UniverseFactoryLoader getUfl() throws ProvisioningException {
            if (this.layoutFactory != null) {
                throw new ProvisioningException("Provisioning layout factory has already been initialized which conflicts with the initialization of universe factory loader");
            }
            if (this.resolver != null) {
                throw new ProvisioningException("Universe resolver has already been initialized which conflicts with the initialization of universe factory loader");
            }
            return super.getUfl();
        }

        public Builder setMessageWriter(MessageWriter messageWriter) {
            this.messageWriter = messageWriter;
            return this;
        }

        public Builder setUniverseResolver(UniverseResolver resolver) throws ProvisioningException {
            if (this.ufl != null) {
                throw new ProvisioningException("Universe factory loader has already been initialized which conflicts with the initialization of universe resolver");
            }
            if (this.layoutFactory != null) {
                throw new ProvisioningException("Provisioning layout factory has already been initialized which conflicts with the initialization of universe resolver");
            }
            this.resolver = resolver;
            return this;
        }

        public ProvisioningManager build() throws ProvisioningException {
            return new ProvisioningManager(this);
        }

        protected UniverseResolver getUniverseResolver() throws ProvisioningException {
            return this.resolver == null ? this.buildUniverseResolver() : this.resolver;
        }
    }
}

