/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import org.aesh.command.impl.completer.FileOptionCompleter;
import org.aesh.command.impl.internal.ParsedCommand;
import org.aesh.command.option.Option;
import org.aesh.readline.AeshContext;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.ProvisioningManager;
import org.jboss.galleon.cli.CommandExecutionException;
import org.jboss.galleon.cli.PmOptionActivator;
import org.jboss.galleon.cli.PmSession;
import org.jboss.galleon.cli.PmSessionCommand;
import org.jboss.galleon.cli.cmd.CommandWithInstallationDirectory;
import org.jboss.galleon.cli.model.FeatureContainer;
import org.jboss.galleon.cli.model.FeatureContainers;
import org.jboss.galleon.config.ProvisioningConfig;
import org.jboss.galleon.runtime.ProvisioningRuntime;

public abstract class AbstractStateCommand
extends PmSessionCommand
implements CommandWithInstallationDirectory {
    public static final String DIR_OPTION_NAME = "dir";
    public static final String VERBOSE_OPTION_NAME = "verbose";
    @Option(name="dir", completer=FileOptionCompleter.class, required=false, activator=DirActivator.class, description="Installation directory.")
    protected String targetDirArg;

    protected String getName() {
        return Paths.get(this.targetDirArg, new String[0]).getFileName().toString();
    }

    protected ProvisioningManager getManager(PmSession session) throws ProvisioningException {
        return session.newProvisioningManager(this.getInstallationDirectory(session.getAeshContext()), false);
    }

    @Override
    public Path getInstallationDirectory(AeshContext context) {
        Path workDir = PmSession.getWorkDir(context);
        return this.targetDirArg == null ? PmSession.getWorkDir(context) : workDir.resolve(this.targetDirArg);
    }

    public FeatureContainer getFeatureContainer(PmSession session) throws ProvisioningException, Exception {
        FeatureContainer container;
        if (session.getContainer() != null) {
            return session.getContainer();
        }
        ProvisioningManager manager = this.getManager(session);
        if (manager.getProvisionedState() == null) {
            throw new CommandExecutionException("Specified directory doesn't contain an installation");
        }
        ProvisioningConfig config = manager.getProvisioningConfig();
        try (ProvisioningRuntime runtime = manager.getRuntime(config, Collections.emptyMap());){
            container = FeatureContainers.fromProvisioningRuntime(session, manager, runtime);
        }
        return container;
    }

    public static class DirActivator
    extends PmOptionActivator {
        @Override
        public boolean isActivated(ParsedCommand parsedCommand) {
            return this.getPmSession().getContainer() == null;
        }
    }
}

