/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import org.aesh.command.CommandDefinition;
import org.aesh.command.option.Option;
import org.aesh.io.Resource;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.cli.CommandExecutionException;
import org.jboss.galleon.cli.FromInstallationCommand;
import org.jboss.galleon.cli.PmCommandInvocation;
import org.jboss.galleon.cli.cmd.CliErrors;
import org.jboss.galleon.cli.cmd.state.NoStateCommandActivator;

@CommandDefinition(name="changes", description="Saves current provisioned configuration changes into the specified directory.", activator=NoStateCommandActivator.class)
public class ChangesCommand
extends FromInstallationCommand {
    @Option(name="username", required=true, description="User to connect to provisionned server.")
    protected String username;
    @Option(name="password", required=true, description="Password to connect to provisionned server.")
    protected String password;
    @Option(name="port", required=false, defaultValue={"9990"}, description="Protocol to connect to provisionned server.")
    protected String port;
    @Option(name="host", required=false, defaultValue={"127.0.0.1"}, description="Protocol to connect to provisionned server.")
    protected String host;
    @Option(name="protocol", required=false, defaultValue={"remote+http"}, description="Protocol to connect to provisionned server.")
    protected String protocol;
    @Option(name="server-config", required=false, defaultValue={"standalone.xml"}, description="Server configuration file to use for the provisionned server.")
    protected String serverConfig;
    @Option(name="target", required=true, description="Directory to export the changes to.")
    protected Resource exportDirArg;

    @Override
    protected void runCommand(PmCommandInvocation session) throws CommandExecutionException {
        HashMap<String, String> options = new HashMap<String, String>(5);
        if (this.host != null) {
            options.put("host", this.host);
        }
        if (this.port != null) {
            options.put("port", this.port);
        }
        if (this.protocol != null) {
            options.put("protocol", this.protocol);
        }
        if (this.username != null) {
            options.put("username", this.username);
        }
        if (this.password != null) {
            options.put("password", this.password);
        }
        if (this.serverConfig != null) {
            options.put("server-config", this.serverConfig);
        }
        Resource specTargetResource = this.exportDirArg.resolve(session.getAeshContext().getCurrentWorkingDirectory()).get(0);
        Path targetFile = Paths.get(specTargetResource.getAbsolutePath(), new String[0]);
        try {
            this.getManager(session).exportConfigurationChanges(targetFile, null, options);
        }
        catch (IOException | ProvisioningException e) {
            throw new CommandExecutionException(session.getPmSession(), CliErrors.exportProvisionedFailed(), e);
        }
    }
}

