/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli;

import org.aesh.command.Command;
import org.aesh.command.CommandException;
import org.aesh.command.CommandResult;
import org.jboss.galleon.cli.CommandExecutionException;
import org.jboss.galleon.cli.PmCommandInvocation;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.jboss.galleon.universe.LatestVersionNotAvailableException;

public abstract class PmSessionCommand
implements Command<PmCommandInvocation> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CommandResult execute(PmCommandInvocation session) throws CommandException {
        try {
            session.getPmSession().commandStart(session);
            this.runCommand(session);
            CommandResult commandResult = CommandResult.SUCCESS;
            return commandResult;
        }
        catch (Throwable t) {
            PmSessionCommand.handleException(session, t);
            CommandResult commandResult = CommandResult.FAILURE;
            return commandResult;
        }
        finally {
            session.getPmSession().commandEnd(session);
        }
    }

    public static void handleException(PmCommandInvocation session, Throwable t) throws CommandException {
        if (session.getPmSession().isExceptionRethrown()) {
            throw new CommandException(t);
        }
        if (t instanceof RuntimeException) {
            t.printStackTrace(session.getErr());
        }
        t = PmSessionCommand.handleCommandExecutionException(t);
        session.print("Error: ");
        PmSessionCommand.println(session, t);
        t = t.getCause();
        int offset = 1;
        while (t != null) {
            for (int i = 0; i < offset; ++i) {
                session.print(" ");
            }
            session.print("* ");
            PmSessionCommand.println(session, t);
            t = t.getCause();
            ++offset;
        }
    }

    private static Throwable handleCommandExecutionException(Throwable t) {
        CommandExecutionException cex;
        if (t instanceof CommandExecutionException && (cex = (CommandExecutionException)t).getPmSession() != null && cex.getCause() instanceof LatestVersionNotAvailableException) {
            LatestVersionNotAvailableException cause = (LatestVersionNotAvailableException)cex.getCause();
            FeaturePackLocation fpl = cex.getPmSession().getExposedLocation(cause.getLocation());
            t = new LatestVersionNotAvailableException(fpl);
        }
        return t;
    }

    private static void println(PmCommandInvocation session, Throwable t) {
        if (t.getLocalizedMessage() == null) {
            session.println(t.getClass().getName());
        } else {
            session.println(t.getLocalizedMessage());
        }
    }

    protected abstract void runCommand(PmCommandInvocation var1) throws CommandExecutionException;
}

