/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli;

import org.aesh.command.CommandDefinition;
import org.aesh.command.option.Argument;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.cli.CommandExecutionException;
import org.jboss.galleon.cli.PmCommandInvocation;
import org.jboss.galleon.cli.PmSession;
import org.jboss.galleon.cli.ProvisioningCommand;
import org.jboss.galleon.cli.cmd.CliErrors;
import org.jboss.galleon.cli.cmd.InstalledFPLCompleter;
import org.jboss.galleon.cli.cmd.state.NoStateCommandActivator;
import org.jboss.galleon.universe.FeaturePackLocation;

@CommandDefinition(name="uninstall", description="Uninstalls specified feature-pack", activator=NoStateCommandActivator.class)
public class UninstallCommand
extends ProvisioningCommand {
    @Argument(completer=InstalledFPLCompleter.class)
    protected String streamName;

    @Override
    protected void runCommand(PmCommandInvocation session) throws CommandExecutionException {
        try {
            this.getManager(session).uninstall(this.getFPID(session.getPmSession()));
        }
        catch (ProvisioningException e) {
            throw new CommandExecutionException(session.getPmSession(), CliErrors.provisioningFailed(), e);
        }
    }

    private FeaturePackLocation.FPID getFPID(PmSession session) throws CommandExecutionException {
        if (this.streamName == null) {
            throw new CommandExecutionException("No feature-pack provided");
        }
        try {
            return session.getResolvedLocation(this.streamName).getFPID();
        }
        catch (Exception e) {
            throw new CommandExecutionException(session, CliErrors.resolveLocationFailed(), e);
        }
    }
}

