/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli;

import java.io.IOException;
import java.util.HashMap;
import org.aesh.command.CommandDefinition;
import org.aesh.command.option.Option;
import org.jboss.galleon.ArtifactCoords;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.cli.CommandExecutionException;
import org.jboss.galleon.cli.FromInstallationCommand;
import org.jboss.galleon.cli.GavCompleter;
import org.jboss.galleon.cli.PmCommandInvocation;
import org.jboss.galleon.cli.cmd.CliErrors;
import org.jboss.galleon.cli.cmd.state.NoStateCommandActivator;

@CommandDefinition(name="upgrade", description="Saves current provisioned configuration into the specified file.", activator=NoStateCommandActivator.class)
public class UpgradeCommand
extends FromInstallationCommand {
    @Option(name="username", required=true, description="User to connect to provisionned server.")
    protected String username;
    @Option(name="password", required=true, description="Password to connect to provisionned server.")
    protected String password;
    @Option(name="port", required=false, defaultValue={"9990"}, description="Protocol to connect to provisionned server.")
    protected String port;
    @Option(name="host", required=false, defaultValue={"127.0.0.1"}, description="Protocol to connect to provisionned server.")
    protected String host;
    @Option(name="protocol", required=false, defaultValue={"remote+http"}, description="Protocol to connect to provisionned server.")
    protected String protocol;
    @Option(name="server-config", required=false, defaultValue={"standalone.xml"}, description="Server configuration file to use for the provisionned server.")
    protected String serverConfig;
    @Option(name="gav", required=true, completer=GavCompleter.class, description="Feature pack GAV coordinates.")
    protected String coord;

    @Override
    protected void runCommand(PmCommandInvocation session) throws CommandExecutionException {
        HashMap<String, String> parameters = new HashMap<String, String>(5);
        if (this.host != null) {
            parameters.put("host", this.host);
        }
        if (this.port != null) {
            parameters.put("port", this.port);
        }
        if (this.protocol != null) {
            parameters.put("protocol", this.protocol);
        }
        if (this.username != null) {
            parameters.put("username", this.username);
        }
        if (this.password != null) {
            parameters.put("password", this.password);
        }
        if (this.serverConfig != null) {
            parameters.put("server-config", this.serverConfig);
        }
        try {
            this.getManager(session).upgrade(ArtifactCoords.newGav(this.coord), parameters);
        }
        catch (IOException | ProvisioningException e) {
            throw new CommandExecutionException(session.getPmSession(), CliErrors.exportProvisionedFailed(), e);
        }
    }
}

