/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli.cmd;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.galleon.ProvisioningManager;
import org.jboss.galleon.cli.PmCompleterInvocation;
import org.jboss.galleon.cli.cmd.AbstractCommaSeparatedCompleter;
import org.jboss.galleon.cli.cmd.CommandWithInstallationDirectory;
import org.jboss.galleon.config.FeaturePackConfig;
import org.jboss.galleon.util.PathsUtils;

public class InstalledProducerCompleter
extends AbstractCommaSeparatedCompleter {
    @Override
    protected List<String> getItems(PmCompleterInvocation completerInvocation) {
        CommandWithInstallationDirectory cmd = (CommandWithInstallationDirectory)((Object)completerInvocation.getCommand());
        Path currentDir = cmd.getInstallationDirectory(completerInvocation.getAeshContext());
        ArrayList<String> items = new ArrayList<String>();
        try {
            PathsUtils.assertInstallationDir(currentDir);
            ProvisioningManager mgr = completerInvocation.getPmSession().newProvisioningManager(currentDir, false);
            for (FeaturePackConfig fp : mgr.getProvisioningConfig().getFeaturePackDeps()) {
                items.add(completerInvocation.getPmSession().getExposedLocation(fp.getLocation()).getProducer().toString());
            }
        }
        catch (Exception ex) {
            Logger.getLogger(InstalledProducerCompleter.class.getName()).log(Level.FINEST, "Exception while completing: {0}", ex.getLocalizedMessage());
        }
        return items;
    }
}

