/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli.cmd.featurepack;

import org.aesh.command.CommandDefinition;
import org.jboss.galleon.cli.CommandExecutionException;
import org.jboss.galleon.cli.PmCommandInvocation;
import org.jboss.galleon.cli.PmSession;
import org.jboss.galleon.cli.cmd.CliErrors;
import org.jboss.galleon.cli.cmd.featurepack.AbstractFeaturePackCommand;
import org.jboss.galleon.cli.cmd.state.NoStateCommandActivator;
import org.jboss.galleon.cli.model.FeatureContainer;
import org.jboss.galleon.cli.model.FeatureContainers;
import org.jboss.galleon.universe.FeaturePackLocation;

@CommandDefinition(name="explore", description="Explore a feature-pack", activator=NoStateCommandActivator.class)
public class ExploreCommand
extends AbstractFeaturePackCommand {
    @Override
    protected void runCommand(PmCommandInvocation commandInvocation) throws CommandExecutionException {
        if (this.fpl != null && this.file != null) {
            throw new CommandExecutionException("File and location can't be both set");
        }
        PmSession session = commandInvocation.getPmSession();
        if (session.getContainer() != null) {
            throw new CommandExecutionException("Already entered, use leave command");
        }
        String prompt = null;
        String name = null;
        FeaturePackLocation loc = null;
        try {
            if (this.fpl != null) {
                name = this.fpl;
                loc = session.getResolvedLocation(this.fpl);
            } else {
                loc = session.getLayoutFactory().addLocal(this.file.toPath(), true);
                name = loc.getProducerName() + ':' + loc.getChannelName() + '#' + loc.getBuild();
            }
            FeatureContainer container = FeatureContainers.fromFeaturePackId(session, session.newProvisioningManager(null, false), loc.getFPID(), name);
            session.setExploredContainer(container);
            prompt = name + '/';
            session.setCurrentPath("/");
        }
        catch (Exception ex) {
            if (ex instanceof CommandExecutionException) {
                throw (CommandExecutionException)ex;
            }
            throw new CommandExecutionException(commandInvocation.getPmSession(), CliErrors.exploreFailed(), ex);
        }
        commandInvocation.setPrompt(PmSession.buildPrompt(prompt));
        commandInvocation.println("Exploring " + name + ". Use 'state leave' to leave exploration.");
    }
}

