/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli.cmd.mvn;

import org.aesh.command.CommandDefinition;
import org.jboss.galleon.cli.CommandExecutionException;
import org.jboss.galleon.cli.PmCommandInvocation;
import org.jboss.galleon.cli.PmSessionCommand;
import org.jboss.galleon.cli.cmd.Table;
import org.jboss.galleon.cli.config.mvn.MavenConfig;
import org.jboss.galleon.cli.config.mvn.MavenRemoteRepository;

@CommandDefinition(name="info", description="Display maven config")
public class MavenInfo
extends PmSessionCommand {
    @Override
    protected void runCommand(PmCommandInvocation session) throws CommandExecutionException {
        Table t = new Table("Configuration Item", "Value");
        MavenConfig config = session.getPmSession().getPmConfiguration().getMavenConfig();
        t.addLine("Maven xml settings", config.getSettings() == null ? "No settings file set" : config.getSettings().normalize().toString());
        t.addLine("Local repository", config.getLocalRepository().normalize().toString());
        Table.Cell repositories = new Table.Cell(new String[0]);
        Table.Cell title = new Table.Cell("Remote repositories");
        if (config.getRemoteRepositories().isEmpty()) {
            repositories.addLine("None");
        } else {
            for (MavenRemoteRepository rep : session.getPmSession().getPmConfiguration().getMavenConfig().getRemoteRepositories()) {
                repositories.addLine(rep.getName());
                repositories.addLine(" url=" + rep.getUrl());
                repositories.addLine(" type=" + rep.getType());
            }
        }
        t.addCellsLine(title, repositories);
        t.sort(Table.SortType.ASCENDANT);
        session.println(t.build());
    }
}

