/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli.cmd.plugin;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.aesh.command.impl.completer.FileOptionCompleter;
import org.aesh.command.impl.internal.OptionType;
import org.aesh.command.impl.internal.ProcessedOption;
import org.aesh.command.impl.internal.ProcessedOptionBuilder;
import org.aesh.command.parser.OptionParserException;
import org.aesh.readline.AeshContext;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.ProvisioningManager;
import org.jboss.galleon.cli.CliMain;
import org.jboss.galleon.cli.CommandExecutionException;
import org.jboss.galleon.cli.PmCommandActivator;
import org.jboss.galleon.cli.PmCommandInvocation;
import org.jboss.galleon.cli.PmSession;
import org.jboss.galleon.cli.cmd.AbstractDynamicCommand;
import org.jboss.galleon.cli.cmd.CommandWithInstallationDirectory;
import org.jboss.galleon.cli.cmd.state.NoStateCommandActivator;

public abstract class AbstractProvisionWithPlugins
extends AbstractDynamicCommand
implements CommandWithInstallationDirectory {
    protected AbstractProvisionWithPlugins(PmSession pmSession) {
        super(pmSession, true, false, CliMain.experimentalFeaturesEnabled());
    }

    @Override
    protected String getId(PmSession session) throws CommandExecutionException {
        return null;
    }

    protected abstract List<ProcessedOption> getOtherOptions() throws OptionParserException;

    @Override
    protected List<ProcessedOption> getStaticOptions() throws OptionParserException {
        ArrayList<ProcessedOption> options = new ArrayList<ProcessedOption>();
        options.add(ProcessedOptionBuilder.builder().name("dir").hasValue(true).type(String.class).optionType(OptionType.NORMAL).description("Target installation directory.").completer(FileOptionCompleter.class).build());
        options.add(ProcessedOptionBuilder.builder().name("verbose").hasValue(false).type(Boolean.class).description("Whether or not the output should be verbose").optionType(OptionType.BOOLEAN).build());
        options.addAll(this.getOtherOptions());
        return options;
    }

    protected boolean isVerbose() {
        return this.contains("verbose");
    }

    protected String getDir() {
        return (String)this.getValue("dir");
    }

    protected ProvisioningManager getManager(PmCommandInvocation session) throws ProvisioningException {
        return session.getPmSession().newProvisioningManager(this.getInstallationDirectory(session.getAeshContext()), this.isVerbose());
    }

    @Override
    public Path getInstallationDirectory(AeshContext context) {
        return this.getDir() == null ? PmSession.getWorkDir(context) : this.getAbsolutePath(this.getDir(), context);
    }

    protected Path getAbsolutePath(String path, AeshContext context) {
        Path workDir = PmSession.getWorkDir(context);
        return path == null ? PmSession.getWorkDir(context) : workDir.resolve(path);
    }

    protected abstract void doRunCommand(PmCommandInvocation var1, Map<String, String> var2) throws CommandExecutionException;

    @Override
    protected void runCommand(PmCommandInvocation session, Map<String, String> options) throws CommandExecutionException {
        if (this.isVerbose()) {
            session.getPmSession().enableMavenTrace(true);
        }
        try {
            this.doRunCommand(session, options);
        }
        finally {
            session.getPmSession().enableMavenTrace(false);
        }
    }

    @Override
    protected PmCommandActivator getActivator() {
        return new NoStateCommandActivator();
    }
}

