/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli.cmd.plugin;

import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.aesh.command.impl.completer.FileOptionCompleter;
import org.aesh.command.impl.internal.OptionType;
import org.aesh.command.impl.internal.ProcessedOption;
import org.aesh.command.impl.internal.ProcessedOptionBuilder;
import org.aesh.command.parser.OptionParserException;
import org.aesh.readline.AeshContext;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.cli.CommandExecutionException;
import org.jboss.galleon.cli.PmCommandActivator;
import org.jboss.galleon.cli.PmCommandInvocation;
import org.jboss.galleon.cli.PmSession;
import org.jboss.galleon.cli.cmd.CliErrors;
import org.jboss.galleon.cli.cmd.plugin.AbstractPluginsCommand;
import org.jboss.galleon.cli.cmd.state.NoStateCommandActivator;
import org.jboss.galleon.cli.resolver.PluginResolver;
import org.jboss.galleon.plugin.PluginOption;
import org.jboss.galleon.universe.FeaturePackLocation;

@Deprecated
public class DiffCommand
extends AbstractPluginsCommand {
    private static final String SRC_NAME = "src";
    private static final String TARGET_NAME = "target";

    public DiffCommand(PmSession pmSession) {
        super(pmSession);
    }

    @Override
    protected void runCommand(PmCommandInvocation session, Map<String, String> options, FeaturePackLocation loc) throws CommandExecutionException {
        try {
            Path targetDirectory = this.toPath((String)this.getValue(TARGET_NAME), session.getAeshContext());
            this.getManager(session).exportConfigurationChanges(targetDirectory, loc.getFPID(), options);
        }
        catch (IOException | ProvisioningException ex) {
            throw new CommandExecutionException(session.getPmSession(), CliErrors.diffFailed(), ex);
        }
    }

    @Override
    protected Set<PluginOption> getPluginOptions(FeaturePackLocation loc) throws ProvisioningException {
        try {
            return this.pmSession.getResolver().get(loc.toString(), PluginResolver.newResolver(this.pmSession, loc), "Resolving options").getDiff();
        }
        catch (InterruptedException ex) {
            Thread.interrupted();
            throw new ProvisioningException(ex);
        }
        catch (ExecutionException ex) {
            throw new ProvisioningException(ex.getCause());
        }
    }

    @Override
    protected List<ProcessedOption> getOtherOptions() throws OptionParserException {
        ArrayList<ProcessedOption> options = new ArrayList<ProcessedOption>();
        ProcessedOption srcDir = ProcessedOptionBuilder.builder().name(SRC_NAME).hasValue(true).type(String.class).optionType(OptionType.NORMAL).description("Customized source installation directory.").completer(FileOptionCompleter.class).build();
        options.add(srcDir);
        ProcessedOption targetDir = ProcessedOptionBuilder.builder().name(TARGET_NAME).hasValue(true).type(String.class).optionType(OptionType.NORMAL).description("Directory to save the feature pack to.").completer(FileOptionCompleter.class).build();
        options.add(targetDir);
        return options;
    }

    @Override
    protected String getName() {
        return "diff";
    }

    @Override
    protected String getDescription() {
        return "Saves current provisioned configuration changes into a feature pack.";
    }

    @Override
    protected Path getInstallationHome(AeshContext context) {
        String srcPath = (String)this.getValue(SRC_NAME);
        return this.toPath(srcPath, context);
    }

    private Path toPath(String value, AeshContext context) {
        Path workDir = PmSession.getWorkDir(context);
        return value == null ? PmSession.getWorkDir(context) : workDir.resolve(value);
    }

    @Override
    protected PmCommandActivator getActivator() {
        return new NoStateCommandActivator();
    }
}

